/*

  Copyright (c) 2003 Phillip Martin
  Copyright (c) 2003 Richard van Eijbergen <richardve@users.sourceforge.net>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <AztecGUICommonPCH.h>

#include <gui/qt3/MTextFieldImpl.h>
#include <gui/qt3/MContainerImpl.h>
#include <gui/qt3/MAppImpl.h>


namespace Aztec {

  MTextField::MTextField(int width)
    : MComponent()
  {
  }

  MTextField::~MTextField() {
  }

  void MTextField::setInternalValue(const std::string &value) {
    m_Value = value;
  }

  void MTextField::fireAcceptListeners() {
    fireListeners(acceptListeners);
  }

  void MTextField::fireCancelListeners() {
    fireListeners(cancelListeners);
  }

  bool MTextField::createImpl() {
    MApp* app;
    QWidget* parentWnd = 0l;

    // Get the parent widget handle, so we can create our button
    if (m_Parent != 0l) {
      parentWnd = m_Parent->getHandle();
    }

    app = MApp::getInstance();

    // create the actual widget
    m_Handle = new QLineEdit(parentWnd);

    // if it succeeded, update everything
    if (m_Handle != 0) {
      // Register this widget with the application
      app->registerComponent(m_Handle, this);

      // Call the create event handler
      onCreate();

      // Do NOT outcomment this visibility call,
      // It makes other windows flash (you'll understand
      // why when seeing this in action)
      //setVisible(true);

      /*::UpdateWindow(m_hWnd);*/

      return true;
    }

    return false;
  }

  void MTextField::setValue(const std::string &value) {
    if (value == m_Value) {
      return;
    }

    m_Value = value;
    if (m_Handle != 0l) {
      QLineEdit* ledit = dynamic_cast<QLineEdit*>(m_Handle);
      ledit->setText(value.c_str());
    }
  }

  std::string MTextField::getValue() {
    return m_Value;
  }

  bool MTextField::onChanged() {
    return false;
  }

  bool MTextField::onAccepted() {
    return false;
  }

  bool MTextField::onCancelled() {
    return false;
  }

  void MTextField::addAcceptListener(const TextListenerPtr &listener) {
    acceptListeners.push_back(listener);
  }

  void MTextField::addCancelListener(const TextListenerPtr &listener) {
    cancelListeners.push_back(listener);
  }

  bool MTextField::isMinimumSizeSet() {
    return true;
  }

  MSize2D MTextField::getMinimumSize() {
    static int hheight = m_Handle->height()-12;
    return MSize2D(100, (hheight < 16) ? 16 : hheight);
    //return MSize2D(10, 10);
  }

  void MTextField::fireListeners(const std::vector<TextListenerPtr> &v) {
    MTextFieldPtr field = this;
    for (std::vector<TextListenerPtr>::const_iterator i = v.begin(); i != v.end(); ++i) {
      (*i)->onListen(field);
    }
  }

}

