/*

  Copyright (c) 2003 Phillip Martin
  Copyright (c) 2003 Richard van Eijbergen <richardve@users.sourceforge.net>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  2111-1307  USA

*/

#include <AztecGUICommonPCH.h>

#include <gui/qt3/MAppImpl.h>

#include <stdlib.h>
#include <stdio.h>
#include <errno.h>

#include <sys/types.h>
#include <unistd.h>

#include <set>
#include <istream>
#include <fstream>
#include <iostream>

using std::string;
using std::map;
using std::iterator;


namespace Aztec {

  // this is the global set of application instances.
  std::set<IMApp::Ptr> g_allApps;

  MApp* g_CurrentApp;


  MApp::MApp() {
    // add this instance into the set of global instances.
    g_allApps.insert(this);
    g_CurrentApp = this;
  }

  MApp::~MApp() {
    m_HandleMap.clear();
    m_AllWindows.clear();
    /*menuItemMap.clear();*/
  }

  MApp* MApp::getInstance() {
    return g_CurrentApp;
  }

  void MApp::qt3init(const string& appName, int argc, char** argv) {
    m_Name = appName;

    // Create a new app, we can access this instance later
    // through the globally pre-defined qApp.
    static QApplication app(argc, argv);
  }

  MComponentPtr MApp::getComponent(QWidget* Handle) {
    std::map<QWidget*, MComponentPtr>::iterator it;

    it = m_HandleMap.find(Handle);
    if (it != m_HandleMap.end()) {
      return (*it).second;
    }

    return NULL;
  }

  void MApp::registerComponent(QWidget* Handle, const MComponentPtr &component) {
    // TODO: Remove this method and register the widget handles internally
    MWindowPtr window = AZTEC_CAST(MWindow, component);

    if (window != NULL) {
      m_AllWindows.insert(window);
    }

    m_HandleMap.insert(std::map<QWidget*, MComponentPtr>::value_type(Handle, component));
  }

  void MApp::unregisterComponent(QWidget* Handle) {
    m_AllWindows.erase(AZTEC_CAST(MWindow, m_HandleMap[Handle]));
    m_HandleMap.erase(Handle);
  }

  /*void MApp::registerMenu(MPopupMenu* item) {
    menuItemMap[item->getID()] = item;
  }

  void MApp::unregisterMenu(MPopupMenu* item) {
    menuItemMap.erase(item->getID());
  }

  MPopupMenu* MApp::getItemFromID(WORD id) {
    IDMenuItemMap::iterator it = menuItemMap.find(id);

    return (it != menuItemMap.end()) ? it->second : NULL;
  }*/


  // MApp methods

  bool MApp::initApp() {
    /**
     * This is a (hopefully) temporary fix for Red Hat 9.
     * The new NPTL threading library makes libjs behave
     * badly (eg. stops execution of Aztec when calling libc
     * functions) so we really need this.
     */

    std::ifstream redhat_release("/etc/redhat-release");
    if (!redhat_release.is_open()) {
      std::cerr << "WARNING: Cannot determine the Linux distribution you're using." << std::endl << std::endl
                << "         Aztec is doing a check because it will not run without issues" << std::endl
                << "         on systems that are using the NPTL." << std::endl << std::endl
                << "         If you're not able to run Aztec, please execute the following command" << std::endl
                << "         before starting Aztec:" << std::endl << std::endl
                << "         'export LD_ASSUME_KERNEL=2.4.1' (without quotes)" << std::endl;
    }

    // TODO: Check if we're using Red Hat 9 (string compare from file: 'Red Hat Linux release 9 (Shrike)')
    // ...

    // TODO: We possibly have to do this for the latest Mandrake Linux as well.
    if (setenv("LD_ASSUME_KERNEL", "2.4.1", 0) < 0) {
      std::cerr << "Cannot set environment variable, Aztec will possibly not run correctly" << std::endl;
    }

    // TODO: Hmz, Okay.. that doesn't seem to work at all.. =)
    //       Fix this asap.

    return true;
  }

  int MApp::run() {
    // Start the initial event loop
    return qApp->exec();
  }

  void MApp::cleanup() {
    // Remove us from the global list
    g_allApps.erase(this);
  }

  std::string MApp::getName() {
    return m_Name;
  }

  std::string MApp::getApplicationPath() {
    /**
     * Easy looking method name, but the real work we're doing here
     * is a lot harder than you would think at first sight..
     *
     * Have a look at the following discussion, of which I've taken the
     * code I'm using in this method:
     *
     * http://www.flipcode.com/cgi-bin/msg.cgi?showThread=COTD-getexename&forum=cotd&id=-1
     *
     * As already noted at that link, this method does NOT work on
     * operating systems other than Linux, we'll need to find another
     * way to get this thing working on xBSD (for example), preferably
     * at runtime.
     */

    // TODO: Move into initApp()
    if (appPath.empty()) {
      char buffer[512];  // TODO: Search for some MAX_PATH-like typedef
      char linkname[64];
      pid_t pid;
      int ret;

      // Get our PID and build the name of the link in /proc
      pid = getpid();

      if (snprintf(linkname, sizeof(linkname), "/proc/%i/exe", pid) < 0) {
        // TODO: Dunno what to do in here either (rve)
        assert(false);
      }

      // Read the symbolic link
      ret = readlink(linkname, buffer, sizeof(buffer));

      // TODO: Better error handling
      if (ret == -1) {
        std::cerr << "Cannot read from the proc file system (" << linkname << ")" << std::endl;
      }

      appPath = buffer;

      // Remove the executable name
      appPath = appPath.substr(0, appPath.find_last_of("/"));
      std::cout << "Application Path: " << appPath.c_str() << std::endl;
    }

    return appPath;
  }

  MWindowPtr MApp::getTopLevelWindow() {
    return m_AllWindows.size() == 0 ? NULL : *m_AllWindows.begin();
  }

  bool MApp::onCommand(const std::string &command, const MComponentPtr &component) {
    return false;
  }

  bool MApp::onMouseMove(const MMouseEvent &event) {
    return false;
  }

  bool MApp::onMousePressed(const MMouseEvent &event) {
    return false;
  }

  bool MApp::onMouseReleased(const MMouseEvent &event) {
    return false;
  }

  bool MApp::onKeyPressed(const MKeyEvent &event) {
    return false;
  }

  bool MApp::onKeyReleased(const MKeyEvent &event) {
    return false;
  }
}

