#include <AztecGUICommonPCH.h>
#include <gui/MKeyEvent.h>

#include <map>

namespace Aztec {

  MKeyEvent::MKeyEvent(KeyMessageType type, unsigned long time, KeyCode code, char ascii, const MShiftState &state, const MComponentPtr &component)
    : type(type), time(time), code(code), ascii(ascii), component(component), state(state)
  {
  }

  MKeyEvent::MKeyEvent(KeyMessageType type, unsigned long time, KeyCode code, const MShiftState &state, const MComponentPtr &component)
    : type(type), time(time), code(code), component(component), state(state)
  {
    ascii = ' ';

    switch (code) {
      case Key_Tab: ascii = '\t'; break;
      case Key_Return: ascii = '\n'; break;
      case Key_Space: ascii = ' '; break;
      case Key_QuoteDbl: ascii = '\"'; break;
      case Key_Dollar: ascii = '$'; break;
      case Key_Percent: ascii = '%'; break;
      case Key_Ampersand: ascii = '&'; break;
      case Key_Apostrophe: ascii = '\''; break;
      case Key_ParenLeft: ascii = '('; break;
      case Key_ParenRight: ascii = ')'; break;
      case Key_Asterisk: ascii = '*'; break;
      case Key_Plus: ascii = '+'; break;
      case Key_Comma: ascii = ','; break;
      case Key_Minus: ascii = '-'; break;
      case Key_Period: ascii = '.'; break;
      case Key_Slash: ascii = '/'; break;
      case Key_Colon: ascii = ':'; break;
      case Key_Semicolon: ascii = ';'; break;
      case Key_Less: ascii = '<'; break;
      case Key_Equal: ascii = '='; break;
      case Key_Greater: ascii = '>'; break;
      case Key_Question: ascii = '?'; break;
      case Key_At: ascii = '@'; break;
      case Key_BracketLeft: ascii = '['; break;
      case Key_Backslash: ascii = '\\'; break;
      case Key_BracketRight: ascii = ']'; break;
      case Key_AsciiCircum: ascii = '^'; break;
      case Key_Underscore: ascii = '_'; break;
      case Key_QuoteLeft: ascii = '`'; break;
      case Key_BraceLeft: ascii = '['; break;
      case Key_Bar: ascii = '_'; break;
      case Key_BraceRight: ascii = ']'; break;
      case Key_AsciiTilde: ascii = '~'; break;
      case Key_0: ascii = '0'; break;
      case Key_1: ascii = '1'; break;
      case Key_2: ascii = '2'; break;
      case Key_3: ascii = '3'; break;
      case Key_4: ascii = '4'; break;
      case Key_5: ascii = '5'; break;
      case Key_6: ascii = '6'; break;
      case Key_7: ascii = '7'; break;
      case Key_8: ascii = '8'; break;
      case Key_9: ascii = '9'; break;
      case Key_A: ascii = 'a'; break;
      case Key_B: ascii = 'b'; break;
      case Key_C: ascii = 'c'; break;
      case Key_D: ascii = 'd'; break;
      case Key_E: ascii = 'e'; break;
      case Key_F: ascii = 'f'; break;
      case Key_G: ascii = 'g'; break;
      case Key_H: ascii = 'h'; break;
      case Key_I: ascii = 'i'; break;
      case Key_J: ascii = 'j'; break;
      case Key_K: ascii = 'k'; break;
      case Key_L: ascii = 'l'; break;
      case Key_M: ascii = 'm'; break;
      case Key_N: ascii = 'n'; break;
      case Key_O: ascii = 'o'; break;
      case Key_P: ascii = 'p'; break;
      case Key_Q: ascii = 'q'; break;
      case Key_R: ascii = 'r'; break;
      case Key_S: ascii = 's'; break;
      case Key_T: ascii = 't'; break;
      case Key_U: ascii = 'u'; break;
      case Key_V: ascii = 'v'; break;
      case Key_W: ascii = 'w'; break;
      case Key_X: ascii = 'x'; break;
      case Key_Y: ascii = 'y'; break;
      case Key_Z: ascii = 'z'; break;
    }

  }

  MKeyEvent::MKeyEvent(const MKeyEvent &src) :
    type(src.type), 
    time(src.time) , 
    code(src.code), 
    ascii(src.ascii), 
    state(src.state),
    component(src.component) 
  { 
  }


  MKeyEvent::KeyMessageType MKeyEvent::getType() const {
    return type;
  }

  const MShiftState & MKeyEvent::getShiftState() const {
    return state;
  }

  bool MKeyEvent::isShiftDown() const {
    return state.shiftPressed;
  }

  bool MKeyEvent::isControlDown() const {
    return state.ctrlPressed;
  }

  bool MKeyEvent::isAltDown() const {
    return state.altPressed;
  }

  MComponentPtr MKeyEvent::getComponent() const {
    return component;
  }

  MKeyEvent::KeyCode MKeyEvent::getCode() const {
    return code;
  }

  char MKeyEvent::getChar() const {
    return ascii;
  }

  typedef std::map<MKeyEvent::KeyCode, std::string> KeyStringMap;
  typedef std::map<std::string, MKeyEvent::KeyCode> StringKeyMap;

  static KeyStringMap keyStringMap;
  static StringKeyMap stringKeyMap;

  static void addStringKey(MKeyEvent::KeyCode code, const std::string &str) {
    keyStringMap[code] = str;
    stringKeyMap[str] = code;
  }

  static void createMaps() {
    if (keyStringMap.size() > 0) {
      return;
    }
    
    addStringKey(MKeyEvent::Key_Unknown, "Unknown");
    addStringKey(MKeyEvent::Key_LeftButton, "LeftButton");
    addStringKey(MKeyEvent::Key_RightButton, "RightButton");
    addStringKey(MKeyEvent::Key_MiddleButton, "MiddleButton");
    addStringKey(MKeyEvent::Key_Escape, "Escape");
    addStringKey(MKeyEvent::Key_Tab, "Tab");
    addStringKey(MKeyEvent::Key_Backtab, "Backtab");
    addStringKey(MKeyEvent::Key_Backspace, "Backspace");
    addStringKey(MKeyEvent::Key_Return, "Return");
    addStringKey(MKeyEvent::Key_Insert, "Insert");
    addStringKey(MKeyEvent::Key_Delete, "Delete");
    addStringKey(MKeyEvent::Key_Pause, "Pause");
    addStringKey(MKeyEvent::Key_Print, "Print");
    addStringKey(MKeyEvent::Key_SysReq, "SysReq");
    addStringKey(MKeyEvent::Key_Home, "Home");
    addStringKey(MKeyEvent::Key_End, "End");
    addStringKey(MKeyEvent::Key_Left, "Left");
    addStringKey(MKeyEvent::Key_Up, "Up");
    addStringKey(MKeyEvent::Key_Right, "Right");
    addStringKey(MKeyEvent::Key_Down, "Down");
    addStringKey(MKeyEvent::Key_Prior, "Prior");
    addStringKey(MKeyEvent::Key_Next, "Next");
    addStringKey(MKeyEvent::Key_Shift, "Shift");
    addStringKey(MKeyEvent::Key_Control, "Control");
    addStringKey(MKeyEvent::Key_Meta, "Meta");
    addStringKey(MKeyEvent::Key_Alt, "Alt");
    addStringKey(MKeyEvent::Key_CapsLock, "CapsLock");
    addStringKey(MKeyEvent::Key_NumLock, "NumLock");
    addStringKey(MKeyEvent::Key_ScrollLock, "ScrollLock");
    addStringKey(MKeyEvent::Key_Clear, "Clear");
    addStringKey(MKeyEvent::Key_F1, "F1");
    addStringKey(MKeyEvent::Key_F2, "F2");
    addStringKey(MKeyEvent::Key_F3, "F3");
    addStringKey(MKeyEvent::Key_F4, "F4");
    addStringKey(MKeyEvent::Key_F5, "F5");
    addStringKey(MKeyEvent::Key_F6, "F6");
    addStringKey(MKeyEvent::Key_F7, "F7");
    addStringKey(MKeyEvent::Key_F8, "F8");
    addStringKey(MKeyEvent::Key_F9, "F9");
    addStringKey(MKeyEvent::Key_F10, "F10");
    addStringKey(MKeyEvent::Key_F11, "F11");
    addStringKey(MKeyEvent::Key_F12, "F12");
    addStringKey(MKeyEvent::Key_F13, "F13");
    addStringKey(MKeyEvent::Key_F14, "F14");
    addStringKey(MKeyEvent::Key_F15, "F15");
    addStringKey(MKeyEvent::Key_F16, "F16");
    addStringKey(MKeyEvent::Key_F17, "F17");
    addStringKey(MKeyEvent::Key_F18, "F18");
    addStringKey(MKeyEvent::Key_F19, "F19");
    addStringKey(MKeyEvent::Key_F20, "F20");
    addStringKey(MKeyEvent::Key_F21, "F21");
    addStringKey(MKeyEvent::Key_F22, "F22");
    addStringKey(MKeyEvent::Key_F23, "F23");
    addStringKey(MKeyEvent::Key_F24, "F24");
    addStringKey(MKeyEvent::Key_F25, "F25");
    addStringKey(MKeyEvent::Key_F26, "F26");
    addStringKey(MKeyEvent::Key_F27, "F27");
    addStringKey(MKeyEvent::Key_F28, "F28");
    addStringKey(MKeyEvent::Key_F29, "F29");
    addStringKey(MKeyEvent::Key_F30, "F30");
    addStringKey(MKeyEvent::Key_F31, "F31");
    addStringKey(MKeyEvent::Key_F32, "F32");
    addStringKey(MKeyEvent::Key_F33, "F33");
    addStringKey(MKeyEvent::Key_F34, "F34");
    addStringKey(MKeyEvent::Key_F35, "F35");
    addStringKey(MKeyEvent::Key_Menu, "Menu");
    addStringKey(MKeyEvent::Key_Help, "Help");
    addStringKey(MKeyEvent::Key_Space, "Space");
    addStringKey(MKeyEvent::Key_Any, "Any");
    addStringKey(MKeyEvent::Key_QuoteDbl, "QuoteDbl");
    addStringKey(MKeyEvent::Key_NumberSign, "NumberSign");
    addStringKey(MKeyEvent::Key_Dollar, "Dollar");
    addStringKey(MKeyEvent::Key_Percent, "Percent");
    addStringKey(MKeyEvent::Key_Ampersand, "Ampersand");
    addStringKey(MKeyEvent::Key_Apostrophe, "Apostrophe");
    addStringKey(MKeyEvent::Key_ParenLeft, "ParenLeft");
    addStringKey(MKeyEvent::Key_ParenRight, "ParenRight");
    addStringKey(MKeyEvent::Key_Asterisk, "Asterisk");
    addStringKey(MKeyEvent::Key_Plus, "Plus");
    addStringKey(MKeyEvent::Key_Comma, "Comma");
    addStringKey(MKeyEvent::Key_Minus, "Minus");
    addStringKey(MKeyEvent::Key_Period, "Period");
    addStringKey(MKeyEvent::Key_Slash, "Slash");
    addStringKey(MKeyEvent::Key_0, "0");
    addStringKey(MKeyEvent::Key_1, "1");
    addStringKey(MKeyEvent::Key_2, "2");
    addStringKey(MKeyEvent::Key_3, "3");
    addStringKey(MKeyEvent::Key_4, "4");
    addStringKey(MKeyEvent::Key_5, "5");
    addStringKey(MKeyEvent::Key_6, "6");
    addStringKey(MKeyEvent::Key_7, "7");
    addStringKey(MKeyEvent::Key_8, "8");
    addStringKey(MKeyEvent::Key_9, "9");
    addStringKey(MKeyEvent::Key_Colon, "Colon");
    addStringKey(MKeyEvent::Key_Semicolon, "Semicolon");
    addStringKey(MKeyEvent::Key_Less, "Less");
    addStringKey(MKeyEvent::Key_Equal, "Equal");
    addStringKey(MKeyEvent::Key_Greater, "Greater");
    addStringKey(MKeyEvent::Key_Question, "Question");
    addStringKey(MKeyEvent::Key_At, "At");
    addStringKey(MKeyEvent::Key_A, "A");
    addStringKey(MKeyEvent::Key_B, "B");
    addStringKey(MKeyEvent::Key_C, "C");
    addStringKey(MKeyEvent::Key_D, "D");
    addStringKey(MKeyEvent::Key_E, "E");
    addStringKey(MKeyEvent::Key_F, "F");
    addStringKey(MKeyEvent::Key_G, "G");
    addStringKey(MKeyEvent::Key_H, "H");
    addStringKey(MKeyEvent::Key_I, "I");
    addStringKey(MKeyEvent::Key_J, "J");
    addStringKey(MKeyEvent::Key_K, "K");
    addStringKey(MKeyEvent::Key_L, "L");
    addStringKey(MKeyEvent::Key_M, "M");
    addStringKey(MKeyEvent::Key_N, "N");
    addStringKey(MKeyEvent::Key_O, "O");
    addStringKey(MKeyEvent::Key_P, "P");
    addStringKey(MKeyEvent::Key_Q, "Q");
    addStringKey(MKeyEvent::Key_R, "R");
    addStringKey(MKeyEvent::Key_S, "S");
    addStringKey(MKeyEvent::Key_T, "T");
    addStringKey(MKeyEvent::Key_U, "U");
    addStringKey(MKeyEvent::Key_V, "V");
    addStringKey(MKeyEvent::Key_W, "W");
    addStringKey(MKeyEvent::Key_X, "X");
    addStringKey(MKeyEvent::Key_Y, "Y");
    addStringKey(MKeyEvent::Key_Z, "Z");
    addStringKey(MKeyEvent::Key_BracketLeft, "BracketLeft");
    addStringKey(MKeyEvent::Key_Backslash, "Backslash");
    addStringKey(MKeyEvent::Key_BracketRight, "BracketRight");
    addStringKey(MKeyEvent::Key_AsciiCircum, "AsciiCircum");
    addStringKey(MKeyEvent::Key_Underscore, "Underscore");
    addStringKey(MKeyEvent::Key_QuoteLeft, "QuoteLeft");
    addStringKey(MKeyEvent::Key_BraceLeft, "BraceLeft");
    addStringKey(MKeyEvent::Key_Bar, "Bar");
    addStringKey(MKeyEvent::Key_BraceRight, "BraceRight");
    addStringKey(MKeyEvent::Key_AsciiTilde, "AsciiTilde");
    addStringKey(MKeyEvent::Key_nobreakspace, "nobreakspace");
    addStringKey(MKeyEvent::Key_exclamdown, "exclamdown");
    addStringKey(MKeyEvent::Key_cent, "cent");
    addStringKey(MKeyEvent::Key_sterling, "sterling");
    addStringKey(MKeyEvent::Key_currency, "currency");
    addStringKey(MKeyEvent::Key_yen, "yen");
    addStringKey(MKeyEvent::Key_brokenbar, "brokenbar");
    addStringKey(MKeyEvent::Key_section, "section");
    addStringKey(MKeyEvent::Key_diaeresis, "diaeresis");
    addStringKey(MKeyEvent::Key_copyright, "copyright");
    addStringKey(MKeyEvent::Key_ordfeminine, "ordfeminine");
    addStringKey(MKeyEvent::Key_guillemotleft, "guillemotleft");
    addStringKey(MKeyEvent::Key_notsign, "notsign");
    addStringKey(MKeyEvent::Key_hyphen, "hyphen");
    addStringKey(MKeyEvent::Key_registered, "registered");
    addStringKey(MKeyEvent::Key_macron, "macron");
    addStringKey(MKeyEvent::Key_degree, "degree");
    addStringKey(MKeyEvent::Key_plusminus, "plusminus");
    addStringKey(MKeyEvent::Key_twosuperior, "twosuperior");
    addStringKey(MKeyEvent::Key_threesuperior, "threesuperior");
    addStringKey(MKeyEvent::Key_acute, "acute");
    addStringKey(MKeyEvent::Key_mu, "mu");
    addStringKey(MKeyEvent::Key_paragraph, "paragraph");
    addStringKey(MKeyEvent::Key_periodcentered, "periodcentered");
    addStringKey(MKeyEvent::Key_cedilla, "cedilla");
    addStringKey(MKeyEvent::Key_onesuperior, "onesuperior");
    addStringKey(MKeyEvent::Key_masculine, "masculine");
    addStringKey(MKeyEvent::Key_guillemotright, "guillemotright");
    addStringKey(MKeyEvent::Key_onequarter, "onequarter");
    addStringKey(MKeyEvent::Key_onehalf, "onehalf");
    addStringKey(MKeyEvent::Key_threequarters, "threequarters");
    addStringKey(MKeyEvent::Key_questiondown, "questiondown");
    addStringKey(MKeyEvent::Key_Agrave, "Agrave");
    addStringKey(MKeyEvent::Key_Aacute, "Aacute");
    addStringKey(MKeyEvent::Key_Acircumflex, "Acircumflex");
    addStringKey(MKeyEvent::Key_Atilde, "Atilde");
    addStringKey(MKeyEvent::Key_Adiaeresis, "Adiaeresis");
    addStringKey(MKeyEvent::Key_Aring, "Aring");
    addStringKey(MKeyEvent::Key_AE, "AE");
    addStringKey(MKeyEvent::Key_Ccedilla, "Ccedilla");
    addStringKey(MKeyEvent::Key_Egrave, "Egrave");
    addStringKey(MKeyEvent::Key_Eacute, "Eacute");
    addStringKey(MKeyEvent::Key_Ecircumflex, "Ecircumflex");
    addStringKey(MKeyEvent::Key_Ediaeresis, "Ediaeresis");
    addStringKey(MKeyEvent::Key_Igrave, "Igrave");
    addStringKey(MKeyEvent::Key_Iacute, "Iacute");
    addStringKey(MKeyEvent::Key_Icircumflex, "Icircumflex");
    addStringKey(MKeyEvent::Key_Idiaeresis, "Idiaeresis");
    addStringKey(MKeyEvent::Key_ETH, "ETH");
    addStringKey(MKeyEvent::Key_Ntilde, "Ntilde");
    addStringKey(MKeyEvent::Key_Ograve, "Ograve");
    addStringKey(MKeyEvent::Key_Oacute, "Oacute");
    addStringKey(MKeyEvent::Key_Ocircumflex, "Ocircumflex");
    addStringKey(MKeyEvent::Key_Otilde, "Otilde");
    addStringKey(MKeyEvent::Key_Odiaeresis, "Odiaeresis");
    addStringKey(MKeyEvent::Key_multiply, "multiply");
    addStringKey(MKeyEvent::Key_Ooblique, "Ooblique");
    addStringKey(MKeyEvent::Key_Ugrave, "Ugrave");
    addStringKey(MKeyEvent::Key_Uacute, "Uacute");
    addStringKey(MKeyEvent::Key_Ucircumflex, "Ucircumflex");
    addStringKey(MKeyEvent::Key_Udiaeresis, "Udiaeresis");
    addStringKey(MKeyEvent::Key_Yacute, "Yacute");
    addStringKey(MKeyEvent::Key_THORN, "THORN");
    addStringKey(MKeyEvent::Key_ssharp, "ssharp");
    addStringKey(MKeyEvent::Key_agrave, "agrave");
    addStringKey(MKeyEvent::Key_aacute, "aacute");
    addStringKey(MKeyEvent::Key_acircumflex, "acircumflex");
    addStringKey(MKeyEvent::Key_atilde, "atilde");
    addStringKey(MKeyEvent::Key_adiaeresis, "adiaeresis");
    addStringKey(MKeyEvent::Key_aring, "aring");
    addStringKey(MKeyEvent::Key_ae, "ae");
    addStringKey(MKeyEvent::Key_ccedilla, "ccedilla");
    addStringKey(MKeyEvent::Key_egrave, "egrave");
    addStringKey(MKeyEvent::Key_eacute, "eacute");
    addStringKey(MKeyEvent::Key_ecircumflex, "ecircumflex");
    addStringKey(MKeyEvent::Key_ediaeresis, "ediaeresis");
    addStringKey(MKeyEvent::Key_igrave, "igrave");
    addStringKey(MKeyEvent::Key_iacute, "iacute");
    addStringKey(MKeyEvent::Key_icircumflex, "icircumflex");
    addStringKey(MKeyEvent::Key_idiaeresis, "idiaeresis");
    addStringKey(MKeyEvent::Key_eth, "eth");
    addStringKey(MKeyEvent::Key_ntilde, "ntilde");
    addStringKey(MKeyEvent::Key_ograve, "ograve");
    addStringKey(MKeyEvent::Key_oacute, "oacute");
    addStringKey(MKeyEvent::Key_ocircumflex, "ocircumflex");
    addStringKey(MKeyEvent::Key_otilde, "otilde");
    addStringKey(MKeyEvent::Key_odiaeresis, "odiaeresis");
    addStringKey(MKeyEvent::Key_division, "division");
    addStringKey(MKeyEvent::Key_oslash, "oslash");
    addStringKey(MKeyEvent::Key_ugrave, "ugrave");
    addStringKey(MKeyEvent::Key_uacute, "uacute");
    addStringKey(MKeyEvent::Key_ucircumflex, "ucircumflex");
    addStringKey(MKeyEvent::Key_udiaeresis, "udiaeresis");
    addStringKey(MKeyEvent::Key_yacute, "yacute");
    addStringKey(MKeyEvent::Key_thorn, "thorn");
    addStringKey(MKeyEvent::Key_ydiaeresis, "ydiaeresis");
    
  }

  std::string MKeyEvent::keyCodeToStr(KeyCode code) {
    createMaps();
    return keyStringMap[code];
  }

  MKeyEvent::KeyCode MKeyEvent::strToKeyCode(const std::string &str) {
    createMaps();
    return stringKeyMap[str];
  }


}
