#include <AztecGUICommonPCH.h>

#include <gui/MColour.h>

namespace Aztec {

  static unsigned char getuchar(float value) {
    int val = 255.0 * value;
    if (val < 0) val = 0;
    if (val > 255) val = 255;
    return val;
  }

  static unsigned short getushort(float value) {
    int val = 65536.0 * value;
    if (val < 0) val = 0;
    if (val > 255) val = 255;
    return val;
  }


  MColour::MColour() 
    : r(0.0f), g(0.0f), b(0.0f), a(1.0f)
  {
    
  }

  MColour::MColour(const MColour &src) 
    : r(src.r), g(src.g), b(src.b), a(src.a)
  {
  }

  MColour::MColour(float red, float green, float blue, float alpha) 
    : r(red), g(green), b(blue), a(alpha)
  {
  }

  MColour::MColour(double red, double green, double blue, double alpha) 
    : r((float)red), g((float)green), b((float)blue), a((float)alpha)
  {
  }

  unsigned char MColour::getRuchar() const {
    return getuchar(r);
  }

  unsigned char MColour::getGuchar() const {
    return getuchar(g);
  }

  unsigned char MColour::getBuchar() const {
    return getuchar(b);
  }


  unsigned short MColour::getRushort() const {
    return getushort(r);
  }

  unsigned short MColour::getGushort() const {
    return getushort(g);
  }

  unsigned short MColour::getBushort() const {
    return getushort(b);
  }

  bool MColour::operator==(const MColour &rhs) const {
    return (r == rhs.r && g == rhs.g && b == rhs.b && a == rhs.a);
  }

  bool MColour::operator!=(const MColour &rhs) const {
    return !(r == rhs.r && g == rhs.g && b == rhs.b && a == rhs.a);
  }

  MColour MColour::operator+(const MColour &rhs) const {
    return MColour(r + rhs.r, g + rhs.g, b + rhs.b, a + rhs.a);
  }

  MColour MColour::operator*(float rhs) const {
    return MColour(r * rhs, g * rhs, b * rhs, a * rhs);
  }

  Aztec::MColour operator*(float lhs, Aztec::MColour &rhs) {
    return rhs * lhs;
  }
}

Aztec::MColour operator*(float lhs, Aztec::MColour &rhs) {
  return rhs * lhs;
}


