#ifndef MMenuItemImpl_Header
#define MMenuItemImpl_Header

#include <gui/MMenuItem.h>

#include <string>
#include <vector>

#include <windows.h>


namespace Aztec {

  class MMenu;

  class AZTECGUI_EXPORT MMenuItem : public virtual Aztec::IMMenuItem {
    friend class MMenu;

  public:
    MMenuItem(const std::string &caption, const std::string &command = "", const MMenuPtr &submenu = NULL);
    MMenuItem(const std::string &caption, const MMenuPtr &submenu);
    ~MMenuItem();

    /**
     * This creates the win32 MENUITEMINFO structure
     */
    MENUITEMINFO createMenuInfo();

    /**
     * This sets the menu item info structure
     *
     * @return true if it succeeds, false otherwise.
     */
    virtual bool setMenuItemInfo();

    unsigned short getID();
    unsigned short getOptionID();
    void setParent(MMenu *p);
    MMenu* getParent();

    void doClick();

    bool isSeparator();

    // MComponent methods
    virtual bool createImpl();

    // MMenuItem Methods
    void setCaption(const std::string &caption);
    std::string getCaption();
    void setCommand(const std::string &command);
    std::string getCommand();
    void setOptionCommand(const std::string &command);
    std::string getOptionCommand();
    void setChecked(bool isChecked);
    bool getChecked();
    void setEnabled(bool isEnabled);
    bool getEnabled();
    MMenuPtr getSubMenu();
    void setSubMenu(const MMenuPtr &menu);
    bool onClick();

  protected:
    std::string m_Caption;

    std::string m_Command;

    std::string m_OptionCommand;

    /**
     * This is the owning menu
     */
    MMenu *m_Parent;

    /**
     * This is the id number that defines the menu
     */
    unsigned short m_ID;

    /**
     * This is the id number that defines the menuitem's option box
     */
    unsigned short m_OptionID;

    /**
     * This is the position in the parent menu
     * that this item is placed.
     */
    unsigned int m_Position;

    /**
     * Is this menu item checked or not
     */
    bool m_Checked;

    /**
     * Is this menu item a separator.
     */
    bool m_Separator;

    /**
     * Is this menu item enabled or not.
     */
    bool m_Enabled;


    MMenuPtr m_SubMenu;

    static const std::string SEPARATOR;

    void init(const std::string &caption, const std::string &command, const MMenuPtr &submenu);
  };

}

#include <gui/win32/MMenuImpl.h>


#endif