#ifndef MHotKeyControlImpl_Header
#define MHotKeyControlImpl_Header

#include <gui/MHotKeyControl.h>
#include <gui/win32/MTextFieldImpl.h>

#include <string>

#include <windows.h>


namespace Aztec {

  class AZTECGUI_EXPORT MHotKeyControl : public virtual Aztec::IMHotKeyControl, public MTextField {
  public:
    /**
     * Creates a new text field with the minimum width of <code>width</code> characters.
     */
    MHotKeyControl(int width = 15);
    ~MHotKeyControl();

    // MComponentImpl methods
    bool createImpl();

    // MHotKeyControl Methods
    MKeyEvent::KeyCode getHotKey() const;
    MShiftState getModifiers() const;
    void setHotKey(MKeyEvent::KeyCode code, MShiftState modifiers);
    void clearHotKey();

 };

}


#endif