
#ifndef MTreeControlImpl_Header
#define MTreeControlImpl_Header

#include <gui/MTreeControl.h>
#include <gui/MLayoutManager.h>

#include <qlistview.h>

#include <string>
#include <vector>


namespace Aztec {

  class AZTECGUI_EXPORT MTreeControl : public virtual Aztec::IMTreeControl, public MComponent {
  public:
    MTreeControl();
    ~MTreeControl();
    
    // MTreeControl Methods
    void selectItem(const MTreeItemPtr &item, bool selected = true);

    void clear();
    MTreeItemPtr addItem(const std::string &text);
    MTreeItemPtr addItem(const std::string &text, const MTreeItemPtr &parent);
    void expandItem(const MTreeItemPtr &item, bool expand);
    bool onItemSelected(const MTreeItemPtr &item);

    // MComponentImpl methods
    bool createImpl();


    // MComponent Methods

  protected:

  public:
    int m_col;
  };


  class AZTECGUI_EXPORT MTreeItem : public Aztec::IMTreeItem {
  public:
    MTreeItem();
    MTreeItem(const MTreeItem &src);
    MTreeItem(MTreeControlPtr handle, QListViewItem* parent);

    // IMTreeItem methods.
    std::string getText() const;
    int compare(const MTreeItemPtr &rhs);
    MTreeItemPtr getParent() const;
    bool getSelected() const;

  private:
    friend class MTreeControl;

    QListViewItem* m_lviHandle;
    MTreeControl* m_parent;
  };


}


#endif

