
#ifndef MTextFieldImpl_Header
#define MTextFieldImpl_Header

#include <gui/MTextField.h>
#include <gui/qt3/MComponentImpl.h>

#include <string>
#include <qlineedit.h>


namespace Aztec {

  class AZTECGUI_EXPORT MTextField : public virtual Aztec::IMTextField, public MComponent {
  public:
    MTextField(int width = 15);
    ~MTextField();

    /**
     * This sets the internal value of the text field, without 
     * setting the value in the concrete Qt object, and
     * without firing any events.
     *
     * @param value The new value for the text field.
     */
    void setInternalValue(const std::string &value);

    void fireAcceptListeners();
    void fireCancelListeners();

    // MComponentImpl methods
    virtual bool createImpl();

    // MTextField Methods
    void setValue(const std::string &value);
    std::string getValue();
    bool onChanged();
    bool onAccepted();
    bool onCancelled();
    void addAcceptListener(const TextListenerPtr &listener);
    void addCancelListener(const TextListenerPtr &listener);

    // MComponent methods
    bool isMinimumSizeSet();
    MSize2D getMinimumSize();

  protected:
    /**
     * This is the value in the text field.
     */
    std::string m_Value;

    std::vector<TextListenerPtr> acceptListeners;
    std::vector<TextListenerPtr> cancelListeners;

    void fireListeners(const std::vector<TextListenerPtr> &v);
  };

}


#endif

