#ifndef MMessageDialog_Header
#define MMessageDialog_Header

#include "MRefCountedPtr.h"

namespace Aztec {

  class IMMessageDialog;
  class MMessageDialog;

  typedef MRefCountedPtr<IMMessageDialog> IMMessageDialogPtr;
  typedef MRefCountedPtr<MMessageDialog> MMessageDialogPtr;

}

#include <gui/MGuiBase.h>
#include <gui/MComponent.h>
#include <string>

namespace Aztec {

  class AZTECGUI_EXPORT IMMessageDialog : public virtual MRefCountedObject {
  protected:
    IMMessageDialog() { }
    ~IMMessageDialog() { }

  public:
    typedef enum { OK = 1, YES = 2, NO = 4, CANCEL = 8} Buttons;

    /**
     * Shows the text dialog, and returns which button the user picked.
     *
     * @param buttons An OR combination of the buttons that should be 
     *                displayed. Note that some platforms may only be 
     *                able to display certain combinations, so be careful.
     */
    virtual Buttons doModal(const MComponentPtr &owner, const std::string &caption, const std::string &body, int buttons) = 0;
  };

}


/**
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MMessageDialogImpl.h>


#endif

