#ifndef AztecGUICommon_MMenuShell_Header
#define AztecGUICommon_MMenuShell_Header

#include <MRefCountedPtr.h>

namespace Aztec {

  class MMenuShell;
  typedef MRefCountedPtr<MMenuShell> MMenuShellPtr;

}


#include <gui/MComponent.h>
#include <gui/MLayoutManager.h>
#include <gui/MMenuItem.h>

#include <string>


namespace Aztec {

  /**
   * MMenus are a collection of sub menu items.
   */
  class AZTECGUI_EXPORT IMMenuShell : public virtual IMGuiBase {
  public:

    /**
     * This gets the number of sub menus off this menu item.
     */
    virtual int getItemCount() = 0;

    /**
     * This gets the sub menu at the given index.
     */
    virtual MMenuItemPtr getItem(int index) = 0;

    /**
     * This adds the given item to this menu as a sub menu item.
     */
    virtual void addItem(MMenuItemPtr item) = 0;

    /**
     * This inserts the given item at the given index to 
     * this menu as a sub menu item.
     */
    virtual void addItem(MMenuItemPtr item, int index) = 0;

    /**
     * This adds a separator on the end of the menu.
     */
    virtual void addSeparator() = 0;

    /**
     * This inserts a separator at the given index.
     */
    virtual void addSeparator(int index) = 0;

    /**
     * This removes the sub menu at the given index.
     */
    virtual void removeItem(int index) = 0;

    /**
     * This is called when a child item has been clicked. This is only called 
     * if the onClick() method of the item itself didn't handle the click 
     * (i.e. returned false).
     *
     * @param item The menu item being clicked
     * @return true if the message was handled, false if it wasn;t.
     */
    virtual bool onItemClick(const MMenuItemPtr &item) = 0;
  };

}

/**
 * The following header is included via the AZTEC_GUI
 * variable that should be defined for each platform
 * and used to specify an include directory
 * (ie. ../AztecGUICommon/include/gui/$(AZTEC_GUI)
 * when compiling this lib
 */
#include <MMenuShellImpl.h>


#endif

