#ifndef MGridLayout_Header
#define MGridLayout_Header

#include <gui/MLayoutManager.h>
#include <gui/MPoint2D.h>

#include <string>
#include <vector>

namespace Aztec {

  class AZTECGUI_EXPORT MGridLayout : public virtual MLayoutManager {

  public:
    typedef unsigned short Position;

    static MConstraint getConstaint(Position row, Position column);

    MGridLayout(int columns, int rows);
    ~MGridLayout();

    int getRowCount() const;
    int getColumnCount() const;

    // Layoutmanager methods
    void addComponent(MComponentPtr component);

    void addComponent(MComponentPtr component, MConstraint constraints);

    void removeComponent(MComponentPtr component);

    void layoutContainer(MContainerPtr container);

    /**
     * This gets the minimum size of this layout. 
     * <P>
     * the minimum size of a grid layout is the largest minimum size of 
     * all the components multiplied by the number of grid cells in each
     * direction.
     */
    MSize2D getMinimumSize(MContainerPtr container);

    MSize2D getPreferredSize(MContainerPtr container);
    MConstraint getConstraint(const MComponentPtr &component);

  protected:
    class GridCell {
    public:
      GridCell();
      GridCell(const GridCell &src);

      MComponentPtr component;
    };


    typedef std::vector<GridCell> CellVector;
    typedef std::vector<CellVector> CellMatrix;
    CellMatrix cells;

    /**
     * This keeps track of where the most recent component was added. These 
     * values are used to work out where to place the next uncontrained 
     * component, as we look for an empty space from where we last left off.
     */
    int lastChangedRow, lastChangedColumn;
  };

}


#endif

