#include <Aztec3DPCH.h>
#include <views/OutlineView.h>

#include <controls/MultiSplitter.h>
#include <controls/FourWaySplitterMethod.h>
#include <controls/CommandButton.h>
#include <controls/ToolButton.h>
#include <tools/MGraphSelectTool.h>
#include <tools/MToolManager.h>
#include <views/AztecViewManager.h>

// AztecGUI includes
#include <gui/MBorderLayout.h>
#include <gui/MButton.h>
#include <gui/MFlowLayout.h>

// AztecLib inclues
#include <MListsTrees.h>
#include <MScene.h>

#include <assert.h>

namespace AztecGUI {

  static const int toolbarHeight = 33;

  static const int ParamListID = 10002;

  class OutlineViewTree : public MTreeControl {
  public:
    OutlineViewTree(OutlineView *v) {
      view = v;
    }

    bool onItemSelected(const MTreeItemPtr &item) {
      view->onSelChanged(item);
      return true;
    }

    OutlineView *view;
  };


  OutlineView::OutlineView()
    : AztecView("Scene Outline")
  {
    m_SplitPos = 100;
    splitBarWidth = 4;
    paramListTree = NULL;
    updatingTree = false;
    updatingSelection = false;
  }

  OutlineView::~OutlineView()
  {
  }

  void OutlineView::onCreate() {
    AztecView::onCreate();

    Aztec::MContainerPtr contentPane = new Aztec::MContainer();
    addComponent(contentPane, Aztec::MBorderLayout::CENTRE);
    contentPane->setLayoutManager(new Aztec::MBorderLayout());

    if (paramListTree == NULL) {
      paramListTree = new OutlineViewTree(this);

      contentPane->addComponent(paramListTree);
    }

  }

  template <class SET1, class SET2>
  bool areEqual(const SET1 &set1, const SET2 &set2) {
    typename SET1::const_iterator it;

    if (set1.size() != set2.size()) {
      return false;
    }

    int count = 0;

    for (it = set1.begin(); it != set1.end(); ++it) {
      if (set2.find(*it) == set2.end()) {
        return false;
      }
    }

    // if we managed to get here, we must be equal
    return true;
  }

  AztecViewPtr OutlineView::createCopy() {
    OutlineViewPtr result = new OutlineView();

    // TODO: Copy important information about cameras and whatever else here.

    return result;
  }

  std::string OutlineView::getViewGroup() const {
    return "graphView";
  }

  MToolTypePtr OutlineView::getSelectTool() {
    return new MGraphSelectTool();
  }


  void OutlineView::drawView() {
    updateTreeFromScene();

  }

  bool OutlineView::selectParent() {
    return false;
  }

  bool OutlineView::selectChild() {
    return false;
  }

  bool OutlineView::selectSiblingNext() {
    return false;
  }

  bool OutlineView::selectSiblingPrev() {
    return false;
  }

  bool OutlineView::selectNone() {
    return false;
  }

  bool OutlineView::selectAll() {
    return false;
  }

  bool OutlineView::selectInverse() {
    return false;
  }

  bool OutlineView::selectAllChildren() {
    return false;
  }

  bool OutlineView::anythingSelected() {
    /// TODO: need to change this
    return false;
  }

  MVector3 OutlineView::getSelectionCentre() {
    return MVector3(0,0,0);
  }

  bool OutlineView::deleteSelected() {
    /// TODO: NEed to fix this
    return true;
  }

  void OutlineView::onSelChanged(const MTreeItemPtr &item) {
    if (!updatingTree) {
      updatingSelection = true;
      MBaseObjectPtr object = itemObjectMap[item];

      if (object == NULL) {
        object = itemMaterialMap[item];
      }

      if (object != NULL) {
        MScene::getGlobalScene()->selectObject(object, item->getSelected());
      }

      AztecViewManager::redrawAllViews();
      updatingSelection = false;
    }
  }

  template <class LIST>
  bool hasChanged(MBaseObjectTreePtr tree, LIST list) {
    bool createList = false;

    std::set<LIST::key_type> doneObjects;
    Aztec::MBaseObjectPtr baseObject;

    tree->beginIteration();
    
    while (( baseObject = tree->getNext() ) != NULL ) {
      LIST::key_type Obj = AZTEC_CAST(LIST::key_type::PtrType, baseObject);

      if (Obj == NULL || doneObjects.find(Obj) != doneObjects.end()) {
        continue;
      }

      LIST::iterator it = list.find(Obj);
      if (it == list.end()) {
        createList = true;
        break;
      } else {
        doneObjects.insert(Obj);
        list.erase(it);
      }
    }
    tree->endIteration();

    // if we have any items left over, then the scene must be different to our list.
    if (list.size() > 0) {
      createList = true;
    }

    return createList;
  }

  template <class LIST, class TREE_COMPONENT>
  void updateSelection(MBaseObjectTreePtr tree, LIST list, TREE_COMPONENT paramListTree) {
    Aztec::MBaseObjectPtr baseObject;

    tree->beginIteration();
    
    while (( baseObject = tree->getNext() ) != NULL ) {
      LIST::key_type Obj = AZTEC_CAST(LIST::key_type::PtrType, baseObject);

      if (Obj == NULL) {
        continue;
      }

      LIST::iterator it = list.find(Obj);
      if (it != list.end()) {
        // first update the selection in the tree
        paramListTree->selectItem(it->second, Obj->isFlagged(OBJECTFLAG_SELECTED));

      }
    }
    tree->endIteration();

  }

  Aztec::MSceneObjectPtr getObjectParent(const Aztec::MSceneObjectPtr &sceneObject) {
    return sceneObject->getParent();
  }

  Aztec::MMaterialPtr getObjectParent(const Aztec::MMaterialPtr &material) {
    return NULL;
  }

  template <class OBJECT_ITEM_MAP, class ITEM_OBJECT_MAP, class TREE_COMPONENT>
  void createTree(MBaseObjectTreePtr tree, 
                  OBJECT_ITEM_MAP &objectItemMap, 
                  ITEM_OBJECT_MAP &itemObjectMap, 
                  TREE_COMPONENT paramListTree,
                  MTreeItemPtr objectRoot) {

    Aztec::MBaseObjectPtr baseObject;
    
    objectItemMap.clear();
    itemObjectMap.clear();

    tree->beginIteration();
    while (( baseObject = tree->getNext() ) != NULL ) {
      OBJECT_ITEM_MAP::key_type Obj = AZTEC_CAST(OBJECT_ITEM_MAP::key_type::PtrType, baseObject);

      if (Obj != NULL) {
        if (objectItemMap[Obj] == NULL) {
          OBJECT_ITEM_MAP::key_type parent = getObjectParent(Obj);
          MTreeItemPtr parentItem = objectRoot;
        
          if (parent != NULL) {
            parentItem = objectItemMap[parent];
            assert(parentItem != NULL);
          }

          MTreeItemPtr item = paramListTree->addItem(Obj->getName().c_str(), parentItem);

          objectItemMap[Obj] = item;
          itemObjectMap[item] = Obj;

          if (Obj->isFlagged(OBJECTFLAG_SELECTED)) {
            paramListTree->selectItem(item);
          }
        }
      }
    }
    tree->endIteration();
  }


  void OutlineView::updateTreeFromScene() {
    if (updatingSelection) return;

    updatingTree = true;

    MBaseObjectTreePtr Tree = MScene::getGlobalScene()->getObjectList();
    MBaseObjectPtr BaseObj;
    std::set<MParameterObjectPtr> objParams;

    bool createList = hasChanged(Tree, objectItemMap);

    if (!createList) {
      createList = hasChanged(Tree, materialItemMap);
    }

    if (createList) {
      paramListTree->selectItem(NULL);
      paramListTree->clear();
      MTreeItemPtr objectRoot = paramListTree->addItem("Objects");
      MTreeItemPtr materialRoot = paramListTree->addItem("Materials");

      createTree(Tree, objectItemMap, itemObjectMap, paramListTree, objectRoot);
      createTree(Tree, materialItemMap, itemMaterialMap, paramListTree, materialRoot);
    } else {
      updateSelection(Tree, objectItemMap, paramListTree);
      updateSelection(Tree, materialItemMap, paramListTree);
    }

    updatingTree = false;
  }

}
