#include <Aztec3DPCH.h>

// views
#include <views/Aztec3DView.h>


// tools
#include <tools/CameraTools.h>
#include <tools/MGLMoveTool.h>
#include <tools/MGLRotateTool.h>
#include <tools/MGLScaleTool.h>
#include <tools/MGraphInsertKeyTool.h>
#include <tools/MGraphMoveTool.h>
#include <tools/MGraphSelectTool.h>
#include <tools/MSelectTool.h>

#include <tools/ChamferTool.h>
#include <tools/ExtrudeTool.h>
#include <tools/MEdgeDivideTool.h>
#include <tools/MEdgeTurnTool.h>
#include <tools/MIKBoneTool.h>
#include <tools/MMovePivotTool.h>
#include <tools/MPolylineAddPointTool.h>
#include <tools/QuickSliceTool.h>
#include <tools/MCreatePolyTool.h>
#include <tools/InsetTool.h>
#include <tools/SlideEdgeTool.h>

#include <tools/MToolManager.h>




namespace AztecGUI {

  void registerDefaultTools() {
    MToolManager *toolMan = MToolManager::getInstance();

    toolMan->registerTool(new MSelectToolType());
    toolMan->registerTool(new MPanOrbitToolType());
    toolMan->registerTool(new MPanTrackToolType());
    toolMan->registerTool(new MPanZoomToolType());
    toolMan->registerTool(new MGLMoveToolType());
    toolMan->registerTool(new MGLRotateToolType());
    toolMan->registerTool(new MGLScaleToolType());

    toolMan->registerTool(new MGLMoveToolType(), "toolMoveUV");
    toolMan->registerTool(new MGLRotateToolType(), "toolRotateUV");

    toolMan->registerTool(new MGraphInsertKeyTool());
    toolMan->registerTool(new MGraphMoveTool());
    toolMan->registerTool(new MGraphSelectTool());

    toolMan->registerTool(new MExtrudeTool());
    toolMan->registerTool(new MEdgeDivideTool());
    toolMan->registerTool(new MEdgeTurnTool());
    toolMan->registerTool(new MIKBoneTool());
    toolMan->registerTool(new MMovePivotTool());
    toolMan->registerTool(new MPolylineAddPointTool());
    toolMan->registerTool(new ChamferTool(true));
    toolMan->registerTool(new ChamferTool(false));

    toolMan->registerTool(new QuickSliceTool());
    toolMan->registerTool(new MCreatePolyTool());
    toolMan->registerTool(new InsetTool());
    toolMan->registerTool(new SlideEdgeTool());

    // Set our default tool
    toolMan->setTool(new MGLMoveToolType(), Aztec3DView::VIEW_GROUP);
  }

}
