

function textBoxListener(event, value){
  var text = "Key Event: " + event.type + " " + MKeyEvent.keyCodeToStr(event.code) + " " + event.ascii;
  output.setValue(text);
}


function labelledSliderListener(slider, output, functionCall, redraw){
  var text = slider.getValue();
  output.setValue(text);
  aztecFunction(functionCall, text);
  if(redraw) Scene.redraw();
}
function createLabelledTextField(container, caption, units, value, functionCall) {
  var label = new MLabel(caption);
  var component = new MTextField(value,8);
  var units = new MLabel(units);
  container.addComponent(label);
  container.addComponent(component);
  container.addComponent(units);
  component.addAcceptListener(textFieldListener, functionCall, 1);
}

function createLabelledSlider(container, caption,units, min, max, value,functionCall) {
  var label = new MLabel(caption);
  var slider = new MSlider(min, max, value);
  var units = new MLabel(units);
  var sliderValue = new MTextField(value, 5);

  container.addComponent(label);
  container.addComponent(sliderValue);
  container.addComponent(slider);
   container.addComponent(units);

  slider.addListener(labelledSliderListener, slider, sliderValue, functionCall, 1);
  slider.setMinimumSize(150,1);
  sliderValue.setMinimumSize(10,1);
  sliderValue.addAcceptListener(sliderTextFieldListener, slider);

}

function textFieldListener(field, functionCall, redraw){
  var value = field.getValue();
  aztecFunction(functionCall, value);
  if(redraw) Scene.redraw();
}

function sliderTextFieldListener(textField, slider){
    var fieldValue = textField.getValue();
	slider.setValue(fieldValue);
}


function createLabel(container,label){
	var label = new MLabel(label);
    container.addComponent(label);
}

function aztecFunction(command, value) {
	eval(command + '(' + value + ')');
}

function gridComboListener(combobox) {
	if(combobox.value=="XY Plane") Scene.scene3DViewXYGrid();
	else if(combobox.value=="XZ Plane") Scene.scene3DViewXZGrid();
	else if(combobox.value=="YZ Plane") Scene.scene3DViewYZGrid();
	else if(combobox.value=="Camera Plane") Scene.scene3DViewGridFromCamera();
}

function gridComboBox(container, caption, width) {
  var label = new MLabel(caption);
  var comboBox = new MComboBox("", width);

  comboBox.add("XY Plane");
  comboBox.add("XZ Plane");
  comboBox.add("YZ Plane");
  comboBox.add("Camera Plane");
  container.addComponent(label);
  container.addComponent(comboBox);
  comboBox.addListener(gridComboListener);
}


function snapComboBoxListener(comboBox, boxValue){
  var value = comboBox.getValue();
  boxValue.setValue(value);
  if(value=="GRID") {
	Scene.setSnapGrid();
  } else if(value=="POINT"){
	  Scene.setSnapPoint();
  }
  else Scene.setSnapNone();
}


function createSnappingComboBox(container, caption, value, units) {
  var label = new MLabel(caption);
  var boxValue = new MLabel(units);
  var comboBox2 = new MComboBox();
  
  comboBox2.add("NONE");
  comboBox2.add("GRID");
  comboBox2.add("POINT");
  comboBox2.addListener(snapComboBoxListener,boxValue);

  container.addComponent(label);
  container.addComponent(comboBox2);
  container.addComponent(boxValue);
  comboBox2.index = value;
}

function checkBoxListener(field, functionCall, units, redraw){
  var value = field.getValue();
  var text = "OFF";
  var callVal = 0;
  if(value){ 
	text = "ON"; 
 	callVal = 1;
  }
  units.setValue(text);
  aztecFunction(functionCall, callVal);
  if(redraw) Scene.redraw();
}

function createLabelledCheckBox(container, caption, units, value, functionCall) {

  if(units==0) { units = "OFF";}
  else { units = "ON";}
  var label = new MLabel(caption);
  var checkBox = new MCheckbox();
  var units = new MLabel(units);
  container.addComponent(label);
  container.addComponent(checkBox);
  container.addComponent(units);
  units.setMinimumSize(50,20);
  checkBox.setValue(value);
  checkBox.addListener(checkBoxListener, checkBox, functionCall, units, 0);
}



function gridOptionsWindow() {

  var mainWindow = new MToolWindow("Grid Options");
  var gridRange = Scene.scene3DViewGetGridRange();
  var gridSpacing = Scene.scene3DViewGetGridSpacing();
  var gridMajorSpacing = Scene.scene3DViewGetGridMajorSpacing();
  var snapMode = Scene.getSnapMode();
  var snapViaComponentCP = Scene.getSnapViaComponentCP();

  mainWindow.setLayoutManager(new MFlowLayout(10,2,4));

  createLabelledTextField(mainWindow,  "Grid Range +/-","units",gridRange,"Scene.scene3DViewSetGridRange");
  createLabel(mainWindow," ");
  createLabelledTextField(mainWindow, "Grid Spacing","units",gridSpacing,"Scene.scene3DViewSetGridSpacing");
  createLabel(mainWindow," ");
  createLabelledSlider(mainWindow, "Major Lines every","units",1,25,gridMajorSpacing,"Scene.scene3DViewSetGridMajorSpacing");
  createLabel(mainWindow," ");
  gridComboBox(mainWindow, "Grid Plane", 10);
  createLabel(mainWindow," ");
  createSnappingComboBox(mainWindow, "Grid Snapping",snapMode, "         ")
  createLabel(mainWindow," ");  
  createLabelledCheckBox(mainWindow, "Use Component Selection Centrepoint", snapViaComponentCP, snapViaComponentCP, "Scene.setSnapViaComponentCP");
  createLabel(mainWindow," ");  

  mainWindow.setSize(300,100);
  mainWindow.setVisible(true);	

}
gridOptionsWindow();





