#include <Aztec3DPCH.h>

// Aztec2 includes
#include <functions/FunctionManager.h>
#include <views/AztecViewManager.h>

// AztecLib includes
#include <MSystemManager.h>
#include <MUIManager.h>
#include <MEditableMesh.h>

// Standard includes

namespace AztecGUI {

  int flattenComponentsToPlane(const StringVector &args, std::string &result) {
    if ( Aztec::MUIManager::getComponentMode() != Aztec::MComponentisedObject::FACET_TYPE && 
         Aztec::MUIManager::getComponentMode() != Aztec::MComponentisedObject::POINT_TYPE ) 
    {
      Aztec::MSystemManager::getInstance()->logOutput("Error: flattenComponentsToPlane() - Must be in Facet or Point mode to flatten components.");
      return FunctionManager::FAIL;
    }
    
    Aztec::MBaseObjectPtr obj;
    Aztec::MSceneObjectPtr sceneObj;
    Aztec::MScenePtr scene = Aztec::MScene::getGlobalScene();
    
    scene->getObjectList()->beginIteration();
    
    while (( obj = scene->getObjectList()->getNext() ) != NULL ) {
      Aztec::MShapeObjectPtr srcShape;
      Aztec::MEditableMeshPtr srcMesh;
      
      if (!obj->isFlagged(OBJECTFLAG_SELECTED)) {
        continue;
      }
      
      sceneObj = AZTEC_CAST(Aztec::MSceneObject, obj);
      if (sceneObj == NULL) {
        continue;
      }
      
      srcShape = sceneObj->getShapeObject();
      if (srcShape != NULL) {
        srcMesh = AZTEC_CAST(Aztec::MEditableMesh, srcShape->convertToMesh());
      }
      
      if (srcMesh == NULL) {
        continue;
      }
      
      // now we go over the components, and flatten them.
      Aztec::MVector3 normal, centre;
      int numSelected = 0;
      
      if (Aztec::MUIManager::getComponentMode() == Aztec::MComponentisedObject::FACET_TYPE) {
        for (int n = 0; n < srcMesh->getNumTris(); ++n) {
          if (srcMesh->isTriangleFlagged(n, TRIANGLE_SELECTED)) {
            normal += srcMesh->getTriangleNormal(n);
            centre += srcMesh->getTriangleCentre(n);
            ++numSelected;
          }
          
        }
        
        normal.normalize();
        centre /= numSelected;
        
        // now that we have our normal and centre, we can flatten the faces
        for (int n = 0; n < srcMesh->getNumTris(); ++n) {
          if (srcMesh->isTriangleFlagged(n, TRIANGLE_SELECTED)) {
            Aztec::MVector3 newPos, oldPos, diff;
            
            for (int i = 0; i < 3; ++i) {
              oldPos = srcMesh->getVertexPosition(srcMesh->getTriangleVertex(n, i));
              diff = oldPos - centre;
              diff = normal * ((oldPos - centre) * normal);
              newPos = oldPos - diff;
              srcMesh->setVertexPosition(srcMesh->getTriangleVertex(n, i), newPos);
            }
          }
          
        }
        
      } else if (Aztec::MUIManager::getComponentMode() == Aztec::MComponentisedObject::POINT_TYPE) {
        for (int n = 0; n < srcMesh->getNumVerts(); ++n) {
          if (srcMesh->isVertexFlagged(n, VERTEX_SELECTED)) {
            normal += srcMesh->getVertexNormal(n);
            centre += srcMesh->getVertexPosition(n);
            ++numSelected;
          }
          
        }
        
        normal.normalize();
        centre /= numSelected;
        
        // now that we have our normal and centre, we can flatten the faces
        for (int n = 0; n < srcMesh->getNumVerts(); ++n) {
          if (srcMesh->isVertexFlagged(n, VERTEX_SELECTED)) {
            Aztec::MVector3 newPos, oldPos, diff;
            
            oldPos = srcMesh->getVertexPosition(n);
            diff = oldPos - centre;
            diff = normal * ((oldPos - centre) * normal);
            newPos = oldPos - diff;
            srcMesh->setVertexPosition(n, newPos);
          }
        }
      }
      
      srcMesh->calculateNormals();
    }
    
    scene->getObjectList()->endIteration();
    
    AztecViewManager::redrawAllViews();
    return 1;
  }


}

