#ifndef CameraTools_Header
#define CameraTools_Header

#include <tools/MToolType.h>

namespace AztecGUI {

  class MCameraTool : public MToolType {
  public:
    MCameraTool();

    // MToolType methods
    virtual int onMouseDown(const Aztec::MMouseEvent &event);

  protected:
    int m_OldX, m_OldY;
  };

  class MPanOrbitToolType : public MCameraTool {
  protected:
  public:
     MPanOrbitToolType() {
       m_OldX = 0; 
       m_OldY = 0;
     };

     // MToolType methods
     std::string getName();
     virtual int onMouseMove(const Aztec::MMouseEvent &event);
     virtual int wrapMouse() {return 1;};
  };

  class MPanTrackToolType : public MCameraTool {
  public:
     MPanTrackToolType();

     // MToolType methods
     std::string getName();
     virtual int onMouseMove(const Aztec::MMouseEvent &event);
     virtual int wrapMouse() {
       return 1;
     }
  };

  class MPanZoomToolType : public MCameraTool {
  public:
     MPanZoomToolType();

     // MToolType methods
     std::string getName();
     virtual int onMouseMove(const Aztec::MMouseEvent &event);
     virtual int wrapMouse() {
       return 1;
     }
  };

}

#endif

