#ifndef AztecGLViewImpl_Header
#define AztecGLViewImpl_Header

#include <controls/AztecGLFontCanvas.h>
#include <views/AztecView.h>

#include <MMath.h>
#include <MSelectionItem.h>
#include <tools/MToolType.h>

#include <map>

namespace AztecGUI {

  class AztecGLCanvas : public AztecGLFontCanvas {
  public:
    AztecGLCanvas(AztecView *parentView);
    virtual ~AztecGLCanvas();

    /**
     * This method should be overridden by all open derived classes. It calls 
     * SwapBuffers at the end of it, to ensure what is drawn is actually
     * displayed on the screen.
     */
    virtual void draw3D() = 0;

    /**
     * This performs the transformations on the open gl matricies that set up
     * the viewport ready to render objcets. For 3d scenes, this would include
     * any camera transformations. For 2D scenes, it would include any panning
     * or zooming.
     */
    virtual void doCameraTransform() = 0;

    virtual const Aztec::Matrix3& getInverseTransform() const = 0;

    virtual const Aztec::MVector3& getViewNormal() const = 0;

    virtual const Aztec::MMatrix4& getModelView() const = 0;

    virtual void initProjectionMatrix(Aztec::MSelectMethod, float left, float top, float right, float bottom) = 0;

    virtual int drawManipulators(bool selecting) = 0;

    // gl utility functions

    /**
     * This gets the aspect ratio of this view. The aspect ratio is used to 
     * generate the projection matrix so the coordinates -1,-1 to 1,1 will
     * a correct sqaure, instead of a squashed rectangle.
     *
     * @return The aspect ratio.
     */
    float getAspectRatio();

    
    /**
     * This gets the amount that we need to scale by in order to produce a 
     * consitently sized object on the screen, no matter the distance from 
     * the camera.
     */
    virtual float getScalingFactor(const Aztec::MVector3 &position) = 0;

    /**
     * This gets the objets and components that were inside the given box in the viewport.
     */
    virtual void getSelection(float left, float top, float right, float bottom, std::vector<Aztec::MSelectionItem> &items);

    /**
     * This gets the objets and components that were inside the given box in the viewport.
     */
    virtual void getSelection(float x, float y, std::vector<Aztec::MSelectionItem> &items);

    /**
     * This gets the ray that points into the world from the given pixel 
     * coordinates.
     */
    Aztec::MRay getRay(int x, int y);

    std::string getViewGroup() const;

    void glAdjustMatrixForSelection(float x, float y);
    void glAdjustMatrixForSelection(float left, float top, float right, float bottom);

    void setGridBasis(const Aztec::MVector3 &gridX, const Aztec::MVector3 &gridY);
    Aztec::MPlane getGridPlane() const;
    bool getGridVisible() const;
    void setGridVisible(bool visible);
	
	float getGridRange();
	void setGridRange(float range);

	float getGridSpacing();
	void setGridSpacing(float spacing);
	
	int getGridMajorSpacing();
	void setGridMajorSpacing(int spacing);

    int getSnapViaComponentCP();
    void setSnapViaComponentCP(int state);


    // MComponent methods    
    bool onResize(int newWidth, int newHeight);
    bool onPaint();
    bool onMousePressed(const Aztec::MMouseEvent &event);
    bool onMouseReleased(const Aztec::MMouseEvent &event);
    bool onMouseMove(const Aztec::MMouseEvent &event);
    bool onMouseWheel(const Aztec::MMouseEvent &event);
	
  protected:
    float aspectRatio;

    AztecView *parentView;

    void calculateAspectRatio();
    void getBigAndSmallViewSize(int &bigSize, int &smallSize);

    MToolTypePtr getToolFor(const Aztec::MShiftState &rhs);

    Aztec::MVector3 gridBasisX, gridBasisY;
    bool gridVisible;
    Aztec::MPoint2D mouseDownPos, mouseUpPos;
    int undoCount;
    int gridMajorSpacing;
    float gridSpacing;
    float gridRange;
	int snapViaComponentCP;
    bool menuPopping;

  };

  typedef Aztec::MRefCountedPtr<AztecGLCanvas> AztecGLCanvasPtr;

}

#endif

