-------------------------------------------------------------------------
--MD2/MDX Exporter V3.0
--Version 3.0 for 3ds Max 2012
--Adam Barton (adam@add3d.co.uk)
--Updated by Ruiner (http://www.netdoo.com/wodx)
--New: Added Export Support for multiple object/mesh selections

--hypov8: Added setup for kingpin, using paths from diffuse slot (md2/mdx importer default to this )
--hypov8: Added option to get multiple model bounds to fix seam errors in multi part player models
--hypov8: Moved all code out of global varable. conflicts with other exporters
--hypov8: Added frame file suport without comma seperated. CVS still works. "1,1,framename"  "2,20,framename"
--v3.0 beta added glCommands. required by kingpin. (code base from quark py script)
-- added try/catch after open file. prevented file acess if script crashed
-- added suport for .mdx and .md2 files
-- 
-- todo: multi selected models to split into mdx objects(option)
--todo tween frames?
-------------------------------------------------------------------------


----------------
--  additional code (glCommands)
-- QuArK  -  Quake Army Knife
-- Original code from Blender, md2_exporter.py, author - Bob Holcomb.",
-- "author":        "cdunde/DanielPharos",
-- "author e-mail": "cdunde@sbcglobal.net",
----------------




utility MD2Export_KP "_KP Model Export v3"
(
	----------------------------------		
	-- global varables---------------
	----------------------------------	
	local Kingpin_MD2_Exporter_ver = "Kingpin MD2 Exporter V3.0"	

	local md2lastfile_kp=""
	--local MD2Export_KP
	local framenamelist_kp=#()
	local nlist_kp=#([-0.525731, 0.000000, 0.850651],[-0.442863, 0.238856, 0.864188],[-0.295242, 0.000000, 0.955423],[-0.309017, 0.500000, 0.809017],[-0.162460, 0.262866, 0.951056],[0.000000, 0.000000, 1.000000],[0.000000, 0.850651, 0.525731],[-0.147621, 0.716567, 0.681718],[0.147621, 0.716567, 0.681718],[0.000000, 0.525731, 0.850651],[0.309017, 0.500000, 0.809017],[0.525731, 0.000000, 0.850651],[0.295242, 0.000000, 0.955423],[0.442863, 0.238856, 0.864188],[0.162460, 0.262866, 0.951056],[-0.681718, 0.147621, 0.716567],[-0.809017, 0.309017, 0.500000],[-0.587785, 0.425325, 0.688191],[-0.850651, 0.525731, 0.000000],[-0.864188, 0.442863, 0.238856],[-0.716567, 0.681718, 0.147621],[-0.688191, 0.587785, 0.425325],[-0.500000, 0.809017, 0.309017],[-0.238856, 0.864188, 0.442863],[-0.425325, 0.688191, 0.587785],[-0.716567, 0.681718, -0.147621],[-0.500000, 0.809017, -0.309017],[-0.525731, 0.850651, 0.000000],[0.000000, 0.850651, -0.525731],[-0.238856, 0.864188, -0.442863],[0.000000, 0.955423, -0.295242],[-0.262866, 0.951056, -0.162460],[0.000000, 1.000000, 0.000000],[0.000000, 0.955423, 0.295242],[-0.262866, 0.951056, 0.162460],[0.238856, 0.864188, 0.442863],[0.262866, 0.951056, 0.162460],[0.500000, 0.809017, 0.309017],[0.238856, 0.864188, -0.442863],[0.262866, 0.951056, -0.162460],[0.500000, 0.809017, -0.309017],[0.850651, 0.525731, 0.000000],[0.716567, 0.681718, 0.147621],[0.716567, 0.681718, -0.147621],[0.525731, 0.850651, 0.000000],[0.425325, 0.688191, 0.587785],[0.864188, 0.442863, 0.238856],[0.688191, 0.587785, 0.425325],[0.809017, 0.309017, 0.500000],[0.681718, 0.147621, 0.716567],[0.587785, 0.425325, 0.688191],[0.955423, 0.295242, 0.000000],[1.000000, 0.000000, 0.000000],[0.951056, 0.162460, 0.262866],[0.850651, -0.525731, 0.000000],[0.955423, -0.295242, 0.000000],[0.864188, -0.442863, 0.238856],[0.951056, -0.162460, 0.262866],[0.809017, -0.309017, 0.500000],[0.681718, -0.147621, 0.716567],[0.850651, 0.000000, 0.525731],[0.864188, 0.442863, -0.238856],[0.809017, 0.309017, -0.500000],[0.951056, 0.162460, -0.262866],[0.525731, 0.000000, -0.850651],[0.681718, 0.147621, -0.716567],[0.681718, -0.147621, -0.716567],[0.850651, 0.000000, -0.525731],[0.809017, -0.309017, -0.500000],[0.864188, -0.442863, -0.238856],[0.951056, -0.162460, -0.262866],[0.147621, 0.716567, -0.681718],[0.309017, 0.500000, -0.809017],[0.425325, 0.688191, -0.587785],[0.442863, 0.238856, -0.864188],[0.587785, 0.425325, -0.688191],[0.688191, 0.587785, -0.425325],[-0.147621, 0.716567, -0.681718],[-0.309017, 0.500000, -0.809017],[0.000000, 0.525731, -0.850651],[-0.525731, 0.000000, -0.850651],[-0.442863, 0.238856, -0.864188],[-0.295242, 0.000000, -0.955423],[-0.162460, 0.262866, -0.951056],[0.000000, 0.000000, -1.000000],[0.295242, 0.000000, -0.955423],[0.162460, 0.262866, -0.951056],[-0.442863, -0.238856, -0.864188],[-0.309017, -0.500000, -0.809017],[-0.162460, -0.262866, -0.951056],[0.000000, -0.850651, -0.525731],[-0.147621, -0.716567, -0.681718],[0.147621, -0.716567, -0.681718],[0.000000, -0.525731, -0.850651],[0.309017, -0.500000, -0.809017],[0.442863, -0.238856, -0.864188],[0.162460, -0.262866, -0.951056],[0.238856, -0.864188, -0.442863],[0.500000, -0.809017, -0.309017],[0.425325, -0.688191, -0.587785],[0.716567, -0.681718, -0.147621],[0.688191, -0.587785, -0.425325],[0.587785, -0.425325, -0.688191],[0.000000, -0.955423, -0.295242],[0.000000, -1.000000, 0.000000],[0.262866, -0.951056, -0.162460],[0.000000, -0.850651, 0.525731],[0.000000, -0.955423, 0.295242],[0.238856, -0.864188, 0.442863],[0.262866, -0.951056, 0.162460],[0.500000, -0.809017, 0.309017],[0.716567, -0.681718, 0.147621],[0.525731, -0.850651, 0.000000],[-0.238856, -0.864188, -0.442863],[-0.500000, -0.809017, -0.309017],[-0.262866, -0.951056, -0.162460],[-0.850651, -0.525731, 0.000000],[-0.716567, -0.681718, -0.147621],[-0.716567, -0.681718, 0.147621],[-0.525731, -0.850651, 0.000000],[-0.500000, -0.809017, 0.309017],[-0.238856, -0.864188, 0.442863],[-0.262866, -0.951056, 0.162460],[-0.864188, -0.442863, 0.238856],[-0.809017, -0.309017, 0.500000],[-0.688191, -0.587785, 0.425325],[-0.681718, -0.147621, 0.716567],[-0.442863, -0.238856, 0.864188],[-0.587785, -0.425325, 0.688191],[-0.309017, -0.500000, 0.809017],[-0.147621, -0.716567, 0.681718],[-0.425325, -0.688191, 0.587785],[-0.162460, -0.262866, 0.951056],[0.442863, -0.238856, 0.864188],[0.162460, -0.262866, 0.951056],[0.309017, -0.500000, 0.809017],[0.147621, -0.716567, 0.681718],[0.000000, -0.525731, 0.850651],[0.425325, -0.688191, 0.587785],[0.587785, -0.425325, 0.688191],[0.688191, -0.587785, 0.425325],[-0.955423, 0.295242, 0.000000],[-0.951056, 0.162460, 0.262866],[-1.000000, 0.000000, 0.000000],[-0.850651, 0.000000, 0.525731],[-0.955423, -0.295242, 0.000000],[-0.951056, -0.162460, 0.262866],[-0.864188, 0.442863, -0.238856],[-0.951056, 0.162460, -0.262866],[-0.809017, 0.309017, -0.500000],[-0.864188, -0.442863, -0.238856],[-0.951056, -0.162460, -0.262866],[-0.809017, -0.309017, -0.500000],[-0.681718, 0.147621, -0.716567],[-0.681718, -0.147621, -0.716567],[-0.850651, 0.000000, -0.525731],[-0.688191, 0.587785, -0.425325],[-0.587785, 0.425325, -0.688191],[-0.425325, 0.688191, -0.587785],[-0.425325, -0.688191, -0.587785],[-0.587785, -0.425325, -0.688191],[-0.688191, -0.587785, -0.425325])

	local img_with_kp=256
	local img_hight_kp=256
	local isMDX = true

	--info about
	local string_1 = "Updated to use the Bitmap path from material diffuse slot\n"
	local string_2 = "Path will be trimmed at  \"models/\"  or  \"players/ \"\n"
	local string_3 = "eg..   C:\Games\Kingpin\main\models\weapons\pipe\p.tga\n" 
	local string_4 = "to..   models/weapons/pipe/p.tga\n" 
	local string_5 = "\nFor players, select 3 model parts in the viewport then, hit \"Add\"\n"
	local string_6 = "Then select each model part in viewport and \"Export\"\n"
	local string_7 = "\nThis fixes vertex miss aligment from differnt float compresion\n\n"
	local string_8 = "Frame file supoorts comma seperated \"time,time,name\"\n1,1,Tpose\n2,10,Jumping\n11,22,Running"
	
	--local num_commands =0
	local MAX_TRI = 4096	
	local MAX_VERT = 2048
	local MAX_FRAMES=512
	local MAX_SKINS = 32
	
	----------------------------------		
	-- user controls ---------------
	----------------------------------	
	checkbox 	UI_save_ani "Animated" checked:false align:#left tooltip:"Enable for Animated modes\nDisable for static models"
	--checkbox 	UI_glCommands "glCommands" checked:true align:#left  tooltip:"Required for Kingpin.exe and kpdata.exe.\nGPU uses glComands to load models faster.\nFORCED ON for MDX"	

	checkbox 	UI_vertex_norn "Normals" align:#left checked:true across:2  tooltip:"Generate vertex normals.\nThe angle of the vertex normal is used in calculate model shading"
	checkbox 	UI_vertex_viewNorn "View Models" align:#left checked:false tooltip:"Invert vertex normals for 1st persson player models.\nLight dir will be inverted, making the model brigher from behind when looking at ligth source"	

	spinner 	UI_frame_steps "Frame Skip" range:[1,200,1] fieldwidth:20 type:#integer  align:#left 
	checkbox 	UI_usefile4frame "Frame names from File" checked:false align:#left 
	button 		UI_btn_browse4frame "File" align:#left across:2 height:18
	editText 	UI_file_4frame "" width: 100 align:#right
	group ""
	(
		radiobuttons 	UI_anim_time_from labels:#("Active Time Segment","Custom Time Segment")
		spinner 		UI_animstart_time "from" range:[0,1000,0] type:#integer fieldwidth:40 across:2  align:#centre
		spinner 		UI_animend_time "to" range:[0,1000,40] type:#integer fieldwidth:40  align:#centre 
	)
	
	group ""
	(
		checkbox 	UI_multipart_mdl 	"Player Model" align:#left checked:false tooltip:"Fix for multi part Player Model seam aligment issues\nSets bounding box to the size of all model parts\nDISABLE for player weapons etc.." across:2
		button 		UI_AddModelToList " Add " align:#right  height:18	 --width:64
		listbox 	UI_listbox "" items:#("Select head, body, legs") height:3  --tooltip:"pick head body and legs"--width:144 
	) --end group multi part model
		
	--checkbox 	UI_save_mdx "Save as .mdx" checked:false align:#left tooltip:"md2 or mdx"
	button 		UI_btn_export "Export .md2/.mdx"	align:#centre	width:126  height:24	 
	button 		UI_info_about "Info" align:#centre  height:24	 --width:64

	-- Unbelievably, doesFileExist doesn't work properly!
	-- Here's my replacement...
	fn doesMyKPFileExist fname=
	(
		local temp = fopen fname "rb"
		if temp != undefined then
		(
			fclose temp
			true
		)
		else
		(
			false
		)
	)
	

	fn makemd2_kp object=
	(	
		struct MD2_Tex
		(
			s,t,
			x,y --add hypov8 float for gl commands
		)
		
		--struct MD2_Vertex
		--(
		--	pos, lightNormalIndex
		--)

		struct MD2_Frame
		(
			scale, translate, name,
			vList,vNorm,
			vListFloat --add hypov8 float for bbox/hitbox
		)

		struct MD2_Tri
		(
			v1,v2,v3,				--vertIndices
			t1,t2,t3,				--texCoordIndices
			gl_v1, gl_v2, gl_v3, 	--hypov8 glcmd index. 
			gl_t1, gl_t2, gl_t3		--store triangles in original windings before calculating glComands
		)
			
		--add hypov8 glCommands
		struct MD2_glcmd
		(
			s, --s texture coord.
			t, --t texture coord.
			index --vertex index
		)
		struct MD2_glcmd_list
		(
			num, --tri count
			cmd_list
		)	
		

		struct MD2_model
		(
			skinlist,
			texlist,
			trilist,
			framelist,
			glcmdlist,
			glcmd_num
		)
		
		local astart, aend
		
		if UI_anim_time_from.state==1 then --default auto time
		(
			astart=animationrange.start
			aend=animationrange.end
		)
		else
		(	--use imput time
			astart=UI_animstart_time.value
			aend=UI_animend_time.value
		)	
		if not UI_save_ani.state then 
		(
			astart=1
			aend=1
		)

		-----------------------------------------------------------------------------------------------------
		-----------------------------------------------------------------------------------------------------
		md2=md2_model skinlist:#() texlist:#() trilist:#() framelist:#() glcmdlist:#() glcmd_num:0
		-----------------------------------------------------------------------------------------------------
		-----------------------------------------------------------------------------------------------------	
		
		--hypo textures list. get material name
		local modelTexName
		local modelIndex
		local error
		local	fdslash = "/"
		local bkslash	= "\\"	
		local mdlPath ="models/"
		local plyerPath ="players/"
		
		------------------------------------
		-- build skins
		------------------------------------ 	
		for k = 1 to $selection.count do --hypov8 todo: should only be 1 skin per group items.
		( 								 --allow multi material to set consecitive skins
			obj=	$selection[k]
			error = 0
			
			if obj.material == Undefined  then	
			(
				error = 1
				print "--> NO valid skin on model"	
			)
			else if (stricmp (classof obj.material as string) "Standardmaterial") == 0 then	
			(	--set folder path	
				if (stricmp (classof obj.material.diffusemap as string) "Bitmaptexture")==0 then
				(			
					print( "--> skin index: "+(k as string) + "\n\"--> skin name:  " +(obj.material.diffusemap.filename as string) )	
				
					modelTexName = obj.material.diffusemap.filename
					try
					(						
						img_with_kp = obj.material.diffusemap.bitmap.width --hypov8 todo: error on .pcx
						img_hight_kp = obj.material.diffusemap.bitmap.height
					)
					catch
					(
						error = 1	
						
						if (stricmp (getFilenameType modelTexName) ".pcx") == 0 then  --(doesMyKPFileExist  modelTexName) and
						( 
							error = 2
							messagebox ("Error: Cannot read image dimensions in\n" + modelTexName + "\n\nExport using 256x256 image size" )	title:"ERROR PCX Bitmaptexture" 
						)
					)
					if img_with_kp == undefined or img_hight_kp == undefined  then 
						if error != 2 then	
						(
							print "err1\n"
							error = 1
						)
					if obj.material != undefined then	
					(			
						--print( "--> skin strip root <--") 
						modelTexName = substituteString modelTexName bkslash fdslash --replace backSlash with forwardSlash
						modelIndex = findString modelTexName mdlPath					--find index to a folder named "models/"
						if modelIndex == undefined then
							modelIndex = findString modelTexName plyerPath
						if modelIndex == undefined then
							modelIndex = 1 --error in path name. use whole string
						
						if modelIndex < 1 then 
							modelIndex = 1
						
						modelTexName = substring modelTexName modelIndex -1 	--rename  to mod path
						print( "--> skin trunc: " +(modelTexName as string)+"\n") 					
					)	
					else					
					(
						error = 1
						print "err2\n"
					)
				)
				else	
				(
					modelTexName = obj.material.name
					if modelTexName != undefined then
					(
						error = 1
						print "err1\n"
					)
				)
			)
			else
				error = 1
			
			format "error= % \n" error
			
			if error == 1 then
			(
				messagebox "Cannot find image for model\nUsing defaults\ntris.tga and 256px" title:"ERROR Bitmap Missing!!"
				modelTexName = "tris.tga"
				img_with_kp = 256
				img_hight_kp = 256	
			)	
			if error == 2 then(img_with_kp = 256; img_hight_kp = 256)
			append md2.skinlist (modelTexName)			
		)
		-->end get material name
		
		
		

		------------------------------------
		-- build texture vert list
		------------------------------------  
		for k = 1 to $selection.count do 
		(
			obj=	$selection[k]
			
			for i=1 to getnumtverts obj do
			(
				--s=(((getTVert obj i).x)*256) as integer
				--t=((-(getTVert obj i).y+1)*256) as integer
				s=(((getTVert obj i).x)*img_with_kp) as integer --hypov8
				t=((-(getTVert obj i).y+1)*img_hight_kp) as integer --hypov8
				--float for glCmds
				x=((getTVert obj i).x) as float --hypov8 	glCmd
				y=((getTVert obj i).y) as float --hypov8	 glCmd		
				
				append md2.texlist (md2_tex s:s t:t x:x y:y)
			)
		)
		-->end texture vert list
		

		------------------------------------
		-- build triangle list
		------------------------------------
		total = total2 = 0
		for k = 1 to $selection.count do 
		(
			local gl_v=#(0,0,0), gl_t=#(0,0,0)	
			obj=	$selection[k]
			temp = 0
			temp2 = 0
			
			for i=1 to obj.numfaces do
			(
				v1=((getFace obj i).z)-1
				v2=((getFace obj i).y)-1
				v3=((getFace obj i).x)-1
				
				if v1 > temp then temp = v1	
				if v2 > temp then temp = v2
				if v3 > temp then temp = v3
				
				v1 = (v1 +total) as integer
				v2 = (v2 +total) as integer
				v3 = (v3 +total) as integer
				
				t1 = 0
				t2 = 0
				t3 = 0
				
				try
				(
					t1=((getTVFace obj i).z)-1
					t2=((getTVface obj i).y)-1
					t3=((getTVface obj i).x)-1
				)
				catch (
					print "------------------------"
					print obj.name
					print "------------------------"
				)

				if t1 > temp2 then temp2 = t1
				if t2 > temp2 then temp2 = t2
				if t3 > temp2 then temp2 = t3

				t1 = (t1 + total2) as integer
				t2 = (t2 + total2) as integer
				t3 = (t3 + total2) as integer
				
				--glCommands
				gl_v3=v1 
				gl_v2=v2 
				gl_v1=v3 
				gl_t3=t1 
				gl_t2=t2 
				gl_t1=t3
				
				--format "vt(%,%,%,%,%,%)\n"	gl_v3	gl_v2		gl_v1	gl_t3		gl_t2	gl_t1
						
				append md2.trilist (md2_Tri v1 v2 v3 t1 t2 t3 gl_v1 gl_v2 gl_v3 gl_t1 gl_t2 gl_t3)
	_
				if i == obj.numfaces then
				(
					total = total + temp + 1
					total2 = total2 + temp2 + 1
				)
			)
		)



		-------------------------------------
		-- build frame list
		-------------------------------------
		local frameindex = astart as integer + 1
		local end_task=false-- getProgressCancel()	
		progressStart "Calculating Frames"
		for f=astart to aend by UI_frame_steps.value do 
		(
			if end_task == false then
			(
				progressUpdate (100.0*f/aend)
				end_task=getProgressCancel() 
		
				local vertlist=#()
				local vertlistFloats=#() --add hypov8 bbox/hitbox calculation
				local normlist=#()

				local framename = "FRAME 000......"

				if (UI_usefile4frame.checked) then
				(
					framename = framenamelist_kp[frameindex]
					if framename != undefined then framename	= substring  framename 1 15 --hypov8 make sure its not longer than 15 chars
					print framename
					frameindex = frameindex + UI_frame_steps.value
				)		
				
				if framename == undefined then
				(
					print ("-->ERROR frame missing name index= "+(frameindex as string))
					framename = "FRAME 000......"
				)

				frame=MD2_frame scale:[1,1,1] translate:[0,0,0] name:framename 
				vmin=[0,0,0]
				vmax=[0,0,0]
				
				-- test listbox for valid models
				local validListbox = true
				for arrayMDL in UI_listbox.items do
				(
					local	obj = getNodeByName arrayMDL 
					if obj == undefined	then
					(
						validListbox = false	
						exit
					)
				)	
				
				--print("using multi models= "+(UI_multipart_mdl.state as string))
				--hypo models with multilpe parts are going out of alignment at the seams. Calculating bbox size for complet model
				if (UI_multipart_mdl.state) and (UI_listbox.items.count > 1) and (validListbox) then --must have 2 or more
				(
					--print("using multi models")
					for arrayMDL in UI_listbox.items do
					(
						obj = getNodeByName arrayMDL 
						for i=1 to obj.numverts do at time f
						(
							local v=in coordsys world(getvert obj i)
							if v.x<vmin.x then vmin.x=v.x
							if v.y<vmin.y then vmin.y=v.y
							if v.z<vmin.z then vmin.z=v.z
							if v.x>vmax.x then vmax.x=v.x
							if v.y>vmax.y then vmax.y=v.y
							if v.z>vmax.z then vmax.z=v.z	
						)
					)	
				)
				else
				(	
					for k = 1 to $selection.count do 
					(
						obj=	$selection[k]	
						for i=1 to obj.numverts do at time f
						(
							local v=in coordsys world(getvert obj i)
							if v.x<vmin.x then vmin.x=v.x
							if v.y<vmin.y then vmin.y=v.y
							if v.z<vmin.z then vmin.z=v.z
							if v.x>vmax.x then vmax.x=v.x
							if v.y>vmax.y then vmax.y=v.y
							if v.z>vmax.z then vmax.z=v.z	
						)
					)
				)
				
				frame.translate=vmin
				frame.scale=(vmax-vmin)/[255,255,255]
				
				
				for k = 1 to $selection.count do 
				(
					obj=	$selection[k]
					for i=1 to obj.numverts do
					(
						local v = at time f in coordsys world (getvert obj i)
						append vertlistFloats v	--add hypov8 bbox/hitbox
						--v+=object.pos
						--v*=object.scale
						--v-=object.pos
						v-=frame.translate
						v/=frame.scale
						append vertlist v
						
						------------------------------------
						--do normals
						------------------------------------
						if UI_vertex_norn.state then	
						(							
							local vn = at time f in coordsys world (getnormal obj i)
							--local vn=in coordsys world (getnormal obj i)
							--		in coordsys world rotate (getnormal obj i) (EulerAngles 0 0 90)
							local maxdot=-99999.0
							local normindex=1
							
							if UI_vertex_viewNorn.state then
							(							
								--todo rotate normals!!!!
								local vn_Mat = matrixFromNormal vn
								--preRotateX vn_Mat 180
								--preRotateY vn_Mat 180
								--preRotateZ vn_Mat 180
												
								--rotateYPRMatrix --yaw pitch roll
								--vn.x += 1 --vn.x* (-1)
								--if vn.x > 1.0 then vn.x -= 2
								--vn.y += .5 --vn.x* (-1)
								--if vn.y > 1.0 then vn.y -= 2							
								
								--vn.z += .5 --vn.x* (-1)
								--if vn.z > 1.0 then vn.z -= 2							

								vn.x=  vn.x* (-1)
								--vn.y=  vn.y* (-1)
								vn.z=  vn.z* (-1)
								--if vn.x > 0.0 then vn.x -=1.0
								--else 	vn.x +=1.0
								--vn = [0,0,1]
							)
								
							for j=1 to nlist_kp.count do
							(
								local dotvalue
								dotvalue=dot nlist_kp[j] vn
								if dotvalue>maxdot then
								(
									maxdot=dotvalue
									normindex=j
								)
							)
							
							--normindex=1
							--format "% vnormMDL=%\n" i vn
							--format "% vnormIDX=%\n" i nlist_kp[normindex]						
							--format "% vnormIDX=%\n" i (normindex-1) --nlist_kp[normindex]
					)
						append normlist (normindex-1) -- hypov8 add -1 
					)
				)
				frame.vList=vertlist
				frame.vListFloat=vertlistFloats	--add hypov8 bbox/hitbox
				frame.vNorm=normlist
				append md2.framelist frame
			)
		)	
		--progressEnd()
		
		------------------------------------
		-- build glcmdlist (note useing quark python method)
		------------------------------------  	
		--if UI_glCommands.state then
		(
			progressStart "Calculating glCommands"
					
			--######################################################
			--# Tri-Strip/Tri-Fan functions
			--######################################################
			fn find_strip_length md2_trilist start_tri start_vert strip_tris strip_vert strip_st used =
			(
				local strip_count
				local tri_max= md2_trilist.count
				
				m1=m2=0
				st1=st2=0
				used[start_tri]=2
				last=start_tri
				
				strip_tris[1]=start_tri
				strip_count=1
				--look for matching triangle
				check=start_tri+1	
				
				if start_vert == 1 then (				--v1
					strip_vert[1]=		md2_trilist[last].v1;			strip_st[1]=		md2_trilist[last].t1
					strip_vert[2]=m2=	md2_trilist[last].v2;			strip_st[2]=st2=	md2_trilist[last].t2
					strip_vert[3]=m1=	md2_trilist[last].v3;			strip_st[3]=st1=	md2_trilist[last].t3
				)
				else if start_vert == 2 then (			--v2
					strip_vert[1]=		md2_trilist[last].v2;			strip_st[1]=		md2_trilist[last].t2
					strip_vert[2]=m2=	md2_trilist[last].v3;			strip_st[2]=st2=	md2_trilist[last].t3
					strip_vert[3]=m1=	md2_trilist[last].v1;			strip_st[3]=st1=	md2_trilist[last].t1

				)
				else (									--v3
					strip_vert[1]=		md2_trilist[last].v3;			strip_st[1]=		md2_trilist[last].t3
					strip_vert[2]=m2=	md2_trilist[last].v1;			strip_st[2]=st2=	md2_trilist[last].t1
					strip_vert[3]=m1=	md2_trilist[last].v2;			strip_st[3]=st1=	md2_trilist[last].t2

				)
				--format "tri_start: #%    v(%,%,%)\n" start_tri strip_vert[1] strip_vert[2] strip_vert[3]
				local finished_tri =0			
				for tri_counter=(start_tri+1) to tri_max do
				(
					if finished_tri == 0 then		
					(	--format "tri:#% 1#%=% 2#%=% 3#%=% 4#%=%\n"tri_counter	 md2_trilist[check].v1   m1   md2_trilist[check].t1   st1  md2_trilist[check].v2   m2   md2_trilist[check].t2   st2  
						if md2_trilist[check].v1 == m1 and md2_trilist[check].t1 == st1 and
						   md2_trilist[check].v2 == m2 and md2_trilist[check].t2 == st2 then
						(
							if (used[tri_counter]!=0)  then
							(
								for clear_counter=(start_tri+1) to  tri_max do (		
									if used[clear_counter]==2 then
										used[clear_counter]=0 )
								finished_tri =1 --; print("in use1")
							)
							else	
							(						
								if (bit.and 1 strip_count) !=0 then	(
									m2=	md2_trilist[check].v3
									st2=md2_trilist[check].t3
								)	
								else(
									m1=	md2_trilist[check].v3	
									st1=md2_trilist[check].t3
								)	
								strip_vert[strip_count+3]=md2_trilist[tri_counter].v3
								strip_st[strip_count+3]=md2_trilist[tri_counter].t3 
								strip_tris[strip_count+1]=tri_counter --hypov8 add +1
								strip_count+=1
								used[tri_counter]=2								
							)
						)
						--format "tri:#% 1#%=% 2#%=% 3#%=% 4#%=%\n"tri_counter md2_trilist[check].v2   m1   md2_trilist[check].t2   st1   md2_trilist[check].v3   m2  md2_trilist[check].t3   st2  
						else if md2_trilist[check].v2 == m1 and md2_trilist[check].t2 == st1 and 
						   md2_trilist[check].v3 == m2 and md2_trilist[check].t3 == st2 then
						(
							if (used[tri_counter]!=0)  then
							(
								for clear_counter=(start_tri+1) to tri_max do(
									if used[clear_counter]==2 then
										used[clear_counter]=0)
								 finished_tri =1 --;print("in use2")
							)	
							else
							(						
								if (bit.and 1 strip_count) !=0 then	
								(
									m2=	md2_trilist[check].v1
									st2=md2_trilist[check].t1
								)	
								else 
								(
									m1=	md2_trilist[check].v1
									st1=md2_trilist[check].t1
								)	
								strip_vert[strip_count+3]=md2_trilist[tri_counter].v1
								strip_st[strip_count+3]=md2_trilist[tri_counter].t1
								strip_tris[strip_count+1]=tri_counter --hypov8 add +1
								strip_count+=1
								used[tri_counter]=2
							)
						) --format "tri:#% 1#%=% 2#%=% 3#%=% 4#%=%\n"tri_counter md2_trilist[check].v3 m1  md2_trilist[check].t3 st1 md2_trilist[check].v1 m2 md2_trilist[check].t1 st2
						else if md2_trilist[check].v3==m1 and md2_trilist[check].t3==st1 and 
						   md2_trilist[check].v1==m2 and md2_trilist[check].t1==st2 then
						(
							if (used[tri_counter]!=0)  then
							(
								for clear_counter=(start_tri+1) to tri_max do(
									if used[clear_counter]==2 then
										used[clear_counter]=0)
								 finished_tri =1 --;print("in use3")
							)
							else								
							(						
								if (bit.and 1 strip_count) !=0 then	(
									m2=	md2_trilist[check].v2
									st2=md2_trilist[check].t2
								)	
								else (
									m1=	md2_trilist[check].v2
									st1=md2_trilist[check].t2
								)	
								strip_vert[strip_count+3]=md2_trilist[tri_counter].v2
								strip_st[strip_count+3]=md2_trilist[tri_counter].t2
								strip_tris[strip_count+1]=tri_counter
								strip_count+=1
								used[tri_counter]=2								
							)
						)	
					)	
					check+=1
				)	
			--format "\n"
				strip_count
			)

			fn find_fan_length md2_trilist start_tri start_vert strip_tris strip_vert strip_st used =
			(
				--print ("-= fan0 Start=-")	
				local fan_count
				local tri_max= md2_trilist.count
				m1=m2=0
				st1=st2=0
				used[start_tri]=2
				last=start_tri
				strip_tris[1]=start_tri
				fan_count=1
				check=start_tri+1	
				
				--hypov8 note vertex are stored in reverse order
				if start_vert == 1 then ( 				--v1
					strip_vert[1]=m1=	md2_trilist[last].gl_v1;			strip_st[1]=st1=	md2_trilist[last].gl_t1
					strip_vert[2]=		md2_trilist[last].gl_v2;			strip_st[2]=		md2_trilist[last].gl_t2
					strip_vert[3]=m2=	md2_trilist[last].gl_v3;			strip_st[3]=st2=	md2_trilist[last].gl_t3
				)
				else if start_vert == 2 then( 			--v2
					strip_vert[1]=m1=	md2_trilist[last].gl_v2;			strip_st[1]=st1=	md2_trilist[last].gl_t2
					strip_vert[2]=		md2_trilist[last].gl_v3;			strip_st[2]=		md2_trilist[last].gl_t3
					strip_vert[3]=m2=	md2_trilist[last].gl_v1;			strip_st[3]=st2=	md2_trilist[last].gl_t1
				)
				else ( 									--v3
					strip_vert[1]=m1=	md2_trilist[last].gl_v3;			strip_st[1]=st1=	md2_trilist[last].gl_t3
					strip_vert[2]=		md2_trilist[last].gl_v1;			strip_st[2]=		md2_trilist[last].gl_t1
					strip_vert[3]=m2=	md2_trilist[last].gl_v2;			strip_st[3]=st2=	md2_trilist[last].gl_t2
				)
				--format "tri_start: #%    v(%,%,%)\n" start_tri strip_vert[1] strip_vert[2] strip_vert[3]	
				--format "tri_start: #%    v(%,%,%)\n" start_tri strip_st[1] 	 strip_st[2]   strip_st[3]			
				local finished_tri=0	
				for tri_counter=(start_tri+1) to tri_max do
				(
					if finished_tri != 1 then
					(
						--format "tri_01: #%    v(%,%,%)\n" tri_counter md2_trilist[check].gl_v1   md2_trilist[check].gl_v2  md2_trilist[check].gl_v3
						--format "tri_01: #%    v(%,%,%)\n" tri_counter md2_trilist[check].gl_t1   md2_trilist[check].gl_t2  md2_trilist[check].gl_t3				
						if md2_trilist[check].gl_v1 == m1 and md2_trilist[check].gl_t1 == st1 and   md2_trilist[check].gl_v2 == m2 and md2_trilist[check].gl_t2 == st2 then
						(		--format "okayed_compare. 1: #% tri: #%\n" tri_counter
							if (used[tri_counter]!=0) then 
							(
								--format "used. k: #% tri: #%\n" k tri_counter							
								for clear_counter=(start_tri+2) to tri_max do (--ok? was +1	
									if used[clear_counter]==2 then
										used[clear_counter]=0 )
								finished_tri =1 --; print("in use1")
							)	
							else
							(
								strip_vert[fan_count+3]=	m2=		md2_trilist[check].gl_v3
								strip_st[fan_count+3]=		st2=	md2_trilist[check].gl_t3
								strip_tris[fan_count+1]=tri_counter						
								fan_count+=1							
								used[tri_counter]=2
							)								
						)
						else if md2_trilist[check].gl_v2 == m1 and md2_trilist[check].gl_t2 == st1 and  md2_trilist[check].gl_v3 == m2 and md2_trilist[check].gl_t3 == st3 then
						 ( 		--format "okayed_compare. 2: #% tri: #%\n" tri_counter
							if (used[tri_counter]!=0) then
							(	 --format "used. k: #% tri: #%\n" k tri_counter	
								for clear_counter=(start_tri+2) to tri_max do (--ok? was +1						
									if used[clear_counter]==2 then
										used[clear_counter]=0 )
								finished_tri =1 --; print("in use1")
							)	
							else
							(
								strip_vert[fan_count+3]=	m2=		md2_trilist[check].gl_v1
								strip_st[fan_count+3]=		st2=	md2_trilist[check].gl_t1
								strip_tris[fan_count+1]=tri_counter						
								fan_count+=1							
								used[tri_counter]=2
							)								
						)					
						else if md2_trilist[check].gl_v3 == m1 and md2_trilist[check].gl_t3 == st1 and   md2_trilist[check].gl_v1 == m2 and md2_trilist[check].gl_t1 == st2 then
						(		--format "okayed_compare. 3: #% tri: #%\n" tri_counter
							if (used[tri_counter]!=0) then
							( --format "used. k: #% tri: #%\n" k tri_counter	
								for clear_counter=(start_tri+2) to tri_max do (						
									if used[clear_counter]==2 then
										used[clear_counter]=0 )
								finished_tri =1 --; print("in use1")
							)	
							else
							(
								strip_vert[fan_count+3]=	m2=		md2_trilist[check].gl_v2
								strip_st[fan_count+3]=		st2=	md2_trilist[check].gl_t2
								strip_tris[fan_count+1]=tri_counter						
								fan_count+=1							
								used[tri_counter]=2				
							)
						)
					)
					check+=1 --next tri
				)
				--output tri count
				fan_count
			)
			
			------------------------------------
			-- build glcmdlist (note useing quark python method)
			------------------------------------  
			(
				--variables
				local num_commands=0 --add up byte pool for writing model
				local fan_length=strip_length=0
				local best_type=0
				local best_vert = #()
				local best_st = #()
				local best_tris = #()
				local s=0.0
				local t=0.0
				local time_int = timeStamp()		
				local total_tri_count=md2.trilist.count	
				
				--variables shared between fan and strip functions
				local strip_tris = #()
				local strip_vert=#()
				local strip_st=#()	
				local used=#()

				strip_tris[MAX_TRI]=0	
				strip_vert[MAX_VERT]=0		
				strip_st[MAX_VERT]=0	
				best_vert[MAX_VERT]=0 
				best_st[MAX_VERT]=0
				best_tris[MAX_TRI]=0
				used[total_tri_count]=0				
				
				--setup default vale's for arrays
				for i=1 to MAX_VERT do(	strip_vert[i]=0 ;strip_st[i]=0 ;best_vert[i]=0 ;best_st[i]=0 )
				for i=1 to MAX_TRI do(	strip_tris[i]=0; best_tris[i]=0	)	
				for i=1 to total_tri_count do( used[i]=0 )

				for face_counter = 1 to	total_tri_count do
				(
					--time_int = timeStamp()		
					--format "timestamp1: #% face: #%\n" (timeStamp() - time_int) face_counter
					if end_task == false then
					(
						if (bit.and 10 face_counter) !=0 then	
						(
							progressUpdate (100.0*face_counter/total_tri_count)
							end_task=getProgressCancel() 
						)
								
						if used[face_counter]!=1 then 
						(
							local best_length=0
							
							--loop through each vertex of the face
							for start_vert=1 to 3 do 
							(
							--strip_length=0
								strip_length = find_strip_length md2.trilist face_counter start_vert strip_tris strip_vert strip_st used  --do fn
								if (strip_length>best_length) then
								(
									best_type=0
									best_length=strip_length
									for index=1 to (best_length+2) do(
										best_st[index]=strip_st[index]
										best_vert[index]=strip_vert[index]
									)
									for index=1 to (best_length) do
										best_tris[index]=strip_tris[index]
								)
							--fan_length =0
								fan_length = find_fan_length md2.trilist face_counter start_vert strip_tris strip_vert strip_st used  --do fn
								if (fan_length>best_length) then
								(
									best_type=1
									best_length=fan_length
									for index=1 to best_length+2 do(
										best_st[index]=strip_st[index]
										best_vert[index]=strip_vert[index]
									)	
									for index=1 to (best_length) do
										best_tris[index]=strip_tris[index]

								)				
							)

							for used_counter=1 to (best_length) do
								used[best_tris[used_counter]]=1
								
							--if 	best_type ==1 then	
							--	format "-->fan:  #% best_length: #%\n" face_counter best_length	
							--else
							--	format "-->str:  #% best_length: #%\n" face_counter best_length	
								
							local num=0
							if best_type==1 then --fan
								num=(-(best_length+2))
							else --strip		
								num=best_length+2
														
							num_commands+=1	 --add fantype to byte pool
								
							if isMDX == true then num_commands +=1 --hypov8 add group number to byte pool 
							
							local temp_cmdlist = MD2_glcmd_list num:num cmd_list:#()
							for command_counter=1 to (best_length+2) do	
							(
								local index=best_st[command_counter]
								s=md2.texlist[index+1].x --hypov8 add+1 q2 uses vIndex0
								t=(1-md2.texlist[index+1].y)  --invert V			
								append temp_cmdlist.cmd_list(MD2_glcmd s:s t:t index:best_vert[command_counter])
								num_commands+=3
							)	
							append md2.glcmdlist temp_cmdlist --) (MD2_glcmd_list
						)
					)
					--format "timestamp5: #% face: #%\n" (timeStamp() - time_int) face_counter		
				)	--end of triangle list
				
				--Done. insert blank record (end)
				num_commands+=1 --fan type 0
				if isMDX == true then num_commands +=1 --hypov8 objectnumber
				append md2.glcmdlist (MD2_glcmd_list num:0 cmd_list:0)
				num_commands+=3 --S T Idx
				md2.glcmd_num = num_commands
			)
			
		)
		progressEnd()
		
		md2
	)

	----------------------------------		
	-- write md2
	----------------------------------	
	fn writemd2_kp obj md2file=
	(
		if obj==undefined then return"No object"
		
		for k = 1 to $selection.count do 
		(
			obj=	$selection[k]
			if (classof obj)!=editable_mesh then return "Object is not a mesh"
		)

		--process the objects into uable data
		model=makemd2_kp obj

		print("begin: open file")
		f=fopen md2file "wb"
		
		try
		(
		----------------------------------------
		-- write the header
		----------------------------------------
		if isMDX == False then	
		(		
			magic=844121161
			version=8
			skinw=img_with_kp
			skinh=img_hight_kp 
			framenum=model.framelist.count
			skinnum=model.skinlist.count
			print( "skinn count= " +(model.skinlist.count as string))
				
			vertnum=model.framelist[1].vlist.count
			texnum=model.texlist.count
			trinum=model.trilist.count
			glnum=model.glcmd_num --model.glcmdlist.count	
			texsize=4
			trisize=12
			framesize=40+(4*vertnum)
			
			headersize=68				-- bytes in header
			offsetskins=headersize
			offsettexcoords=offsetskins+(skinnum*64)
			offsettris=offsettexcoords+(texnum*texsize)
			offsetframes=offsettris+(trinum*trisize)
			offsetgl=offsetframes+(framenum*framesize)
			offsetend=offsetgl+(glnum*4) --hypov8 add last zero..	
			
			
			print("write headder")
			writelong f magic
			writelong f version
			writelong f skinw				--(blitz dont care)
			writelong f skinh				--(blitz dont care)
			writelong f framesize
			writelong f skinnum
			writelong f vertnum

			writelong f texnum
			writelong f trinum
			writelong f glnum  --36 offset
			writelong f framenum
			writelong f offsetskins		--offset to skins
			writelong f offsettexcoords	--offset to texture coords
			writelong f offsettris		--offset to triangles
			writelong f offsetframes		--offset to frames
			writelong f offsetgl			--offset to gl commands
			writelong f offsetend			--offset to end --64 offset
		)
		else
		(
			magic=1481655369
			version=4
			skinw=img_with_kp
			skinh=img_hight_kp 
			framesize=40+(4*model.framelist[1].vlist.count)
			skinnum=model.skinlist.count;print( "skinn count= " +(model.skinlist.count as string))			
			vertnum=model.framelist[1].vlist.count
			--texnum=model.texlist.count
			trinum=model.trilist.count
			glnum=model.glcmd_num --model.glcmdlist.count
			framenum=model.framelist.count			
			numSfxDefines =0
			numSfxEntries =0
			numSubObjects = 1
			

			headersize=(23*4) --92				-- bytes in header
			offsetskins=headersize
			--offsettexcoords=offsetskins+(skinnum*64)
			offsettris=offsetskins+(skinnum*64)
			offsetframes=offsettris+(trinum*12) --short x y z t1 t2 t3
			offsetgl=offsetframes+(framenum*framesize)
			offsetVertexInfo=offsetgl+(glnum*4) --hypov8 add object number
			offsetSfxDefines=offsetVertexInfo+(vertnum*4) --verts containing group num
			offsetSfxEntries=offsetSfxDefines+(numSfxDefines)
			offsetBBoxFrames=offsetSfxEntries+(numSfxEntries)
			offsetDummyEnd=offsetBBoxFrames+(framenum*numSubObjects*24) --(6vert*4bytes) todo subobjects
			offsetend=offsetDummyEnd	
			
			format "offsettrisH=%\n" (bit.intAsHex offsettris)
			format "offsetframes=%\n" (bit.intAsHex offsetframes)
			format "offsetgl=%\n" (bit.intAsHex offsetgl)			
			format "offsetVertexInfo=%\n" (bit.intAsHex offsetVertexInfo)
			format "offsetBBoxFrames=%\n" (bit.intAsHex offsetBBoxFrames)			


			print("write headder")
			writelong f magic		--4
			writelong f version		--8
			writelong f skinw		--12
			writelong f skinh		--16
			writelong f framesize	--20
			writelong f skinnum		--24
			writelong f vertnum		--28
			writelong f trinum		--32
			writelong f glnum  		--36 offset
			writelong f framenum		--40
			writelong f numSfxDefines	--44
			writelong f numSfxEntries	--48
			writelong f numSubObjects	--52
			
			writelong f offsetskins		--56 offset to skins
			writelong f offsettris		--60 offset to triangles
			writelong f offsetframes	--64 offset to frames
			writelong f offsetgl		--68 offset to gl commands
			
			writelong f offsetVertexInfo	--72
			writelong f	offsetSfxDefines	--76
			writelong f	offsetSfxEntries	--80
			writelong f	offsetBBoxFrames	--84
			writelong f	offsetDummyEnd		--88
			writelong f offsetend			--offset to end --92 offset

		)
		-----------------------------------------------------
		-- end of header
		-----------------------------------------------------
		
		-----------------------------------------------------
		-- write out the skin names
		-----------------------------------------------------
		print("write out the skin names")
		for i in model.skinlist do
		(
			local index = 1
			skinname=i
			if 	skinname.count >64 then	MessageBox("Skin name is to long. 64 char's is maximum allowed.\n\nSkin index = " +(index as string) +"\nSkin char count = " +(skinname.count as string) +"\nSkin name = "+skinname) title:"Error: Skin Name"
			
			for k=1 to 64 do
			(
				if k > skinname.count then
					writebyte f 0 --add NULL
				else
					writebyte f (bit.charAsInt skinname[k])
			)	
			index += 1			
		)
		

		-----------------------------------------------------
		-- write texture coordinate list
		-----------------------------------------------------
		if isMDX == False then
		(
			print("write texture coordinate list")	
			for i in model.texlist do
			(
				writeshort f i.s #unsigned
				writeshort f i.t #unsigned
			)
		)
		-----------------------------------------------------
		--write triangles
		-----------------------------------------------------	
		print("write triangles")
		for i in model.trilist do
		(
			--format "--vert=%\n" i.v1
			writeshort f i.v1 #unsigned
			writeshort f i.v2 #unsigned
			writeshort f i.v3 #unsigned
			writeshort f i.t1 #unsigned
			writeshort f i.t2 #unsigned
			writeshort f i.t3 #unsigned
		)

		-----------------------------------------------------
		-- write frames
		-----------------------------------------------------
		print("write frames")	
		for i in model.framelist do
		(
			writefloat f i.scale.x
			writefloat f i.scale.y
			writefloat f i.scale.z
			writefloat f i.translate.x
			writefloat f i.translate.y
			writefloat f i.translate.z
			writestring f i.name
			for l = 1 to (16 - i.name.count) - 1 do
			(
				writestring f ""
			)		
			k=0
			for j=1 to i.vlist.count do
			(
				writebyte f i.vlist[j].x
				writebyte f i.vlist[j].y
				writebyte f i.vlist[j].z
				writebyte f i.vNorm[j]
			)
		)
		
		-----------------------------------------------------
		-- write glcmds --add hypov8
		-----------------------------------------------------
		print("write glcmds")	
		--if UI_glCommands.state then
		(
			for i in model.glcmdlist do
			(
				writelong f i.num --write gl cmd strip/fan count

				if isMDX == true then				
					writelong f 0 #unsigned --object number hypov8 todo: objects??	
							
				if i.num > 0 then -- write strip
				(
					for j = 1 to i.num do
					(
						writefloat f i.cmd_list[j].s
						writefloat f i.cmd_list[j].t
						writelong f i.cmd_list[j].index				
					)		
				)
				else if  i.num < 0 then --write fan. 
				(
					writefloat f i.cmd_list[1].s
					writefloat f i.cmd_list[1].t
					writelong f i.cmd_list[1].index				
				
					for j = i.cmd_list.count to 2 by -1 do --reverse fan windings
					(
						writefloat f i.cmd_list[j].s
						writefloat f i.cmd_list[j].t
						writelong f i.cmd_list[j].index				
					)
				)
				else --must be 0
				(	--null last object
					writefloat f 0.0
					writefloat f 0.0
					writelong f 0
					print "end glCmds"
				)
			)
		)
		
		-----------------------------------------------------
		-- write vertexInfo --add hypov8
		-----------------------------------------------------
		print("write MDX")	
		if isMDX == true then
		(
			--offsetVertexInfo		--todo groups
			for i = 1 to model.framelist[1].vlist.count do
			(
				writelong  f 1 --object1
			)
			
			
			--offsetSfxDefines;
			--offsetSfxEntries;
			
			
			--offsetBBoxFrames;			--todo: groups
			for i = 1 to model.framelist.count do --per frame
			(
				local vmin=[9999,9999,9999]
				local vmax=[-9999,-9999,-9999]

				for j = 1 to model.framelist[i].vListFloat.count do --per vertex	
				(	
					local v=model.framelist[i].vListFloat[j]
					--format "vert=%\n" v
					
					if v.x<vmin.x then vmin.x=v.x
					if v.y<vmin.y then vmin.y=v.y
					if v.z<vmin.z then vmin.z=v.z
						
					if v.x>vmax.x then vmax.x=v.x
					if v.y>vmax.y then vmax.y=v.y
					if v.z>vmax.z then vmax.z=v.z	
					
				)
				--writelong  f i --write frame num??
				writefloat  f vmin.x
				writefloat  f vmin.y				
				writefloat  f vmin.z	
				
				writefloat  f vmax.x	
				writefloat  f vmax.y	
				writefloat  f vmax.z				
				
			)
			
			
			--offsetDummyEnd; 
			--WriteString   f "hypo"
		)			

		------------------------------------------------------
		-- end of file writing
		------------------------------------------------------
		
		fclose f
		MessageBox("Export Done!!")
		)
	catch --hypov8 todo re'enable
		(
			fclose f --closes file
			MessageBox("--= ERROR: Export invalid =--\nSee log \n")	
			throw() --hypov8 terminate the program. closes file first		
		)	
	)
	-->end write md2


	----------------------------------		
	-- local functions
	----------------------------------	

	fn md2_addcheck_kp cb=
	(
		if classof cb==string then messagebox cb title:"MD2 Export Error"
	)


	----------------------------------		
	-- startup defaults
	----------------------------------		
	on MD2Export_KP open do 
	(
		UI_file_4frame.enabled = UI_usefile4frame.checked
		UI_btn_browse4frame.enabled = UI_usefile4frame.checked

		UI_listbox.enabled = false --UI_multipart_mdl.checked	

		
		if UI_anim_time_from.state == 1 then
		(
			UI_animstart_time.enabled = false	
			UI_animend_time.enabled = false	
		)
	)	-- on MD2Export_KP open do
		
	----------------------------------
	-- ui state change events
	----------------------------------
	on UI_anim_time_from changed theState do
	(
		if UI_anim_time_from.state == 1 then
		(
			UI_animstart_time.enabled = false	
			UI_animend_time.enabled = false	
		)
		else
		(
			UI_animstart_time.enabled = true	
			UI_animend_time.enabled = true	
		)
	)
	----------------------------------	
	---| radio button |--- use frames file
	----------------------------------
	on UI_usefile4frame changed theState do
	(
		UI_file_4frame.enabled = UI_usefile4frame.checked
		UI_btn_browse4frame.enabled = UI_usefile4frame.checked
	)
	----------------------------------	
	---| button |--- info
	----------------------------------
	on UI_info_about pressed do
	(
		print("into------")
		messagebox(string_1 +string_2+string_3+string_4+string_5+string_6+string_7+string_8) title:Kingpin_MD2_Exporter_ver
	)
	----------------------------------
	---| button |--- brows for frames file
	----------------------------------
	on UI_btn_browse4frame pressed do
	(
		framefile=getopenfilename caption:"Open Frame File" filename:"" types:"MD2 Frame File (*.txt)|*.txt|All Files (*.*)|*.*|"
		if framefile != undefined then
		(
			if DoesFileExist framefile then
			(
				UI_file_4frame.text = framefile 
				
				framenamelist_kp=#()

				local file = openFile framefile mode:"r"
	
				while not EOF file do
		 		(
					local strTmp = readLine file
					if (findString strTmp ",") == undefined then --missing "," delimiter
					(	
							print("--> no delim frame= " +strTmp)
							framename =	strTmp
							append framenamelist_kp framename	--hypov8 ToDo: does this append multiple times? not reset
					)					
					else --found token. use frame x to x and name
					(
						local lineDelim = filterString strTmp ","
						local framefrom = lineDelim[1] as integer
						local frameto = lineDelim[2] as integer
						local framename = ""
						local counter = 1;

						for i = framefrom to frameto do
						(
							framename = lineDelim[3] + "_" +counter as string
							append framenamelist_kp framename

							counter += 1
						)
					)					
				)
				close file
			)
		)
	)
	----------------------------------	
	---| button |--- add player models to list	
	----------------------------------
	on UI_AddModelToList pressed do
	(
		if UI_listbox.items.count > 0 then
		(	
			for listnum=1 to UI_listbox.items.count do
			UI_listbox.items = deleteItem UI_listbox.items 1  -- UI_listbox.selection
		)
		
		For CurrentObject in $selection do 
		( 
			if (superClassOf CurrentObject == GeometryClass) and
				(classOf CurrentObject != BoneGeometry) and (classOf CurrentObject != Biped_Object) and
				(classOf CurrentObject != Blizzard) and (classOf CurrentObject != PF_Source) and (classOf CurrentObject != Spray) and
				(classOf CurrentObject != PCloud) and (classOf CurrentObject != Snow) and
				(classOf CurrentObject != PArray) and (classOf CurrentObject != SuperSpray)	then
			(
				temp_array = UI_listbox.items
				insertItem (CurrentObject.name as string) temp_array 1
				UI_listbox.items = temp_array
			)
		)	
	)		
	----------------------------------	
	---| button |--- export md2
	----------------------------------	
	on UI_btn_export pressed do
	( 
		print("Export button pressed")
		if UI_usefile4frame.checked then
		(	
			if DoesFileExist UI_file_4frame.text == false then 
			(
				messagebox("Frame file is missing")
				return "Frame file is missing"
			)
		)
		md2Savefilename_kp=getsavefilename caption:"Save MD2" filename:md2lastfile_kp types:"Kingpin MDX (*.mdx)|*.mdx|Kingpin MD2 (*.md2)|*.md2|All Files (*.*)|*.*|"
		print("Save file name selected")
		if md2Savefilename_kp!=undefined then 
		(				
			local fileExt = getFilenameType md2Savefilename_kp	
			format "fileEXT= %\n" fileExt
		
			if (stricmp fileExt ".mdx") == 0 then
				isMDX = True
			else if (stricmp fileExt ".md2") == 0 then
				isMDX = False
			else
			(
				messageBox "Incorrect file type" title:"MDX/MD2 Exporter"
				return false
			)
			
			print("--== Start Write File ==--")
			md2_addcheck_kp (writemd2_kp $ md2Savefilename_kp) --hypov8 todo report error and remove ok messagebox
			print("--== File Write Done ==--")
			md2lastfile_kp = md2Savefilename_kp
		)
	)
)

