--------------------------------------------------------------------
-- Kingpin MD2/MDX Importer
-- v3.0 for 3ds Max 2012
--
-- by TiCaL (tical@kingpin.com)
-- BIG Thanks to Chris Cookson
-- http://gmax.digitalarenas.com
-- gmax Scripts, News, Articles and More:
--
-- Version history:
-- 1.0 First Release
-- 2.0 hypov8
-- fix frame1 missing data by shifting all frames -1
-- 3.0 combined importing .mdx and .md2 into one script
-- mod folder not required but will use first if exists
-- load textutes in model / players folder if mod dir failed. searches in file load path
-- load texture cords from glCommands if they exist. more presice (floats)
-- set whole model smoothgroup to 1
-- set tangent(tween) type to step. then returns to previous setting

--todo: .pcx files cant load in max. rename .tga??
--------------------------------------------------------------------

utility KP_Model_Importer "_KP Model Import v3" silentErrors:false
(
	--------------------
	-- User Interface --
	--------------------
	--Group "Import"
	--(
	checkbox animCheck "Load all frames" checked:false  align:#centre
	edittext UI_basePathEdit text:"<undefined>" readonly:true width:136 align:#left labelOnTop:true		
	button setBasePathButton "main/mod  Folder.." height:24  width:136  align:#left
	button importButton_MDX "Import KP Models..." height:24	 width:136 align:#left  
	--button importButton_MD2 "Import MD2..."	 align:#left  width:136 	height:24
	button UI_info_about " Info " align:#centre  height:24	
	--)
	
	--rollout baz "foofoo"
	--(
	--checkbox animCheck2 "Load all frames" checked:false  align:#centre		
	--)
	
	
	local appName = "MDX Importer"
	local g_basePath ="<undefined>"	
	local g_fullPath = undefined		
	
	-- info about	
	local Kingpin_MDX_Importer_ver = "Kingpin MDX Importer V2.0.1"	
	local string_1 = "by Chris Cookson & TiCaL\n"
	local string_2 = "cjcookson@hotmail.com\n\n"
	local string_3 = "Updated by hypov8\n" 
	local string_4 = "hypov8@hotmail.com" 

	--------------
	-- Utilities
	--------------
	
	-- Unbelievably, doesFileExist doesn't work properly!
	-- Here's my replacement...
	fn doesMyKPFileExist fname=
	(
		local temp = fopen fname "rb"
		if temp != undefined then
		(
			fclose temp
			true
		)
		else
		(
			false
		)
	)

	-- Error handling
	fn ShowError msg=
	(
		format "*** Error: %\n" msg
		messageBox msg title:appName;
		ok
	)
	
	fn FatalError msg=
	(
		ShowError msg;
		throw (appName + ":" + msg)
	)
	
	fn Check condition msg =
	(
		if not condition do
		(
			if msg == unsupplied do msg = "Check failed"
			format "*** Check failed: %\n" msg
			FatalError msg
		)
	)
	
	-----------------
	-- Binstream tools
	-----------------
	fn SkipBytes bstream count=
	(
		local unknown
		case count of
		(
			2: unknown = ReadShort bstream #unsigned
			4: unknown = ReadLong bstream #unsigned
			default:
			(
				for i = 1 to count do
				(
					unknown = ReadByte bstream #unsigned
				)
			)
		)
	)
	
	fn ReadFixedString bstream fixedLen=
	(
		local str = ""
		for i = 1 to fixedLen do
		(
			str += bit.intAsChar (ReadByte bstream #unsigned)
		)
		str
	)
	
	-----------------	
	-- String utils
	-----------------	
	fn LongToString num=
	(
		local str = ""
		for i = 1 to 4 do
		(
			str += bit.intAsChar (bit.and num 0xff)
			-- num = bit.shift num -8
			num /= 256
		)
		str
	)
	
	fn GetFullTexturePath internTexPath=
	(
		local fdslash = "/"
		local bkslash	= "\\"		
		local modelTexPath = substituteString internTexPath fdslash bkslash -- models\weapons\v_tomgun\tgskin.tga


			
		--is mod folder set?
		if (g_basePath != undefined) and (stricmp g_basePath "<undefined>") !=0 then --stricmp lowercase
		(
			format "==g_basePath= %\n" (g_basePath+ modelTexPath)			
			if doesFileExist (g_basePath+ modelTexPath) then 
				return (g_basePath + modelTexPath)	
		)		
		
		--use opened file path	
		if g_fullPath != undefined then
		(
			--hypo textures list. get material name
			local modFolderName = substituteString g_fullPath fdslash bkslash --c:\games\kingpin\main\models\weapons\v_tomgun\tomgun.mdx
			local modFolderPath = getFilenamePath modFolderName --c:\games\kingpin\main\models\weapons\v_tomgun\			
			local modelFilePath = getFilenamePath modelTexPath --models\weapons\v_tomgun\
			local modelFileName = filenameFromPath modelTexPath --tgskin.tga
			local mdlPath ="models\\", plyerPath ="players\\", iIdx

			format "==modFolderName1= %\n" modFolderName	
			format "==modelFilePath= %\n" modelFilePath	
			format "==modelFileName= %\n" modelFileName	
			
			
			iIdx = findString modFolderName mdlPath --find index to a folder named "models\"					
			if iIdx == undefined then
				iIdx = findString modFolderName plyerPath --find index to a folder named "players\"	

			if iIdx == undefined or iIdx < 1 then -- models/players folder NOT FOUND!!!!!
			(
				format "==(modFolderPath + modelFileName)= %\n" (modFolderPath + modelFileName)	
				if doesFileExist (modFolderPath + modelFileName) then	
					return (modFolderPath + modelFileName)
					
				iIdx = 0 --error in path name. use whole string
			)
			
			modFolderName = substring modFolderName 1 (iIdx-1) --rename  to mod path
			format "==modFolderName2= %\n" modFolderName
			format "==(modFolderName+modelTexPath)= %\n" (modFolderName+ modelTexPath)			
			
			if doesFileExist (modFolderName+ modelTexPath) then	
				return (modFolderName + modelTexPath)

				
				
				
			modelFileName = filenameFromPath g_fullPath
			format "==modFolderName+modelFileName= %\n" (modFolderName+ modelFileName)				
			if doesFileExist (modFolderName+ modelFileName) then	
				return (modFolderName + modelFileName)
			
		)
		return internTexPath			
	)
	
	--------------------------------------------------------------------
	-- MDX Importer
	--------------------------------------------------------------------
	struct MDX_Vertex
	(
		pos,
		lightNormalIndex,
		
		fn LoadFromStream bstream=
		(
			local x = ReadByte bstream #unsigned
			local y = ReadByte bstream #unsigned
			local z = ReadByte bstream #unsigned
			pos = [x, y, z]
			lightNormalIndex = ReadByte bstream #unsigned
		)
	)

	struct MDX_Frame
	(
		scale,
		translate,
		name,
		
		fn LoadFromStream bstream=
		(
			local sx = ReadFloat bstream
			local sy = ReadFloat bstream
			local sz = ReadFloat bstream
			
			scale = [sx, sy, sz]
			
			local tx = ReadFloat bstream
			local ty = ReadFloat bstream
			local tz = ReadFloat bstream
			
			translate = [tx, ty, tz]
			
			name = ReadFixedString bstream 16
		)
	)
	
	struct MDX_Tri
	(
		vertIndices,
		texCoordIndices
	)
	
	struct MDX_glVertex
	(
		st,
		vertexIndex,
		
		fn LoadFromStream bstream=
		(
			local s = ReadFloat bstream
			local t = ReadFloat bstream
			t -= 1.0 --add hypov8
			st = [s, -t, 0.0]
			vertexIndex = ReadLong bstream #unsigned
		)
	)

	struct MDXReader
	(
		modelFilename, modelName, modelPath,
		bstream,
		skinList,
		triList,
		texCoordList,
		frameList,
		
		numVerts,

		offsetFrames,	
		numFrames,
		
		glTris,
		glTexTris,
				
		fn Open filename=
		(
			print("==fOpen==")
			modelFilename = filename
			modelName = getFilenameFile filename
			modelPath = getFileNamePath filename
			bstream = fopen filename "rb"
			ok
		),
		
		fn Close=
		(
			fclose bstream
			ok
		),
		
		fn ReadSkins offset numSkins=
		(
			fseek bstream offset #seek_set
			
			skinList = #()
			
			format "Reading % skins..." numSkins
			for i = 1 to numSkins do
			(
				append skinList (ReadFixedString bstream 64)
				format "Skin %: %\n" i skinList[i]
			)
		--	format "OK\n"
		),
		
		fn ReadTris offset numTris=
		(
			fseek bstream offset #seek_set
			
			triList = #()
			
			format "Reading % tris..." numTris
			
			for i = 1 to numTris do
			(
				local v1 = ReadShort bstream #unsigned
				local v2 = ReadShort bstream #unsigned
				local v3 = ReadShort bstream #unsigned
				
				local uv1 = ReadShort bstream #unsigned
				local uv2 = ReadShort bstream #unsigned
				local uv3 = ReadShort bstream #unsigned
				
				append triList (MDX_Tri vertIndices:[v1, v2, v3] texCoordIndices:[uv1,uv2,uv3])
			)
			
		--	format "OK\n"
		),
		
		fn ReadGLCmds offset numGLCmds=
		(
			fseek bstream offset #seek_set
			
		--	format "GLCmds at %\n" (bit.intAsHex offset)
			format "Reading % GLCmds...\n" numGLCmds
			
			local isFinished = false
			
			texCoordList = #()
			
			local totalTris = 0
			
			glTris = #()
			glTexTris = #()
			
			while not isFinished do
			(
				local first = ReadLong bstream #signed
				
				-- Subobject iD?
				local something = ReadLong bstream #unsigned --hypov8 todo break up models
				format "mdx model group#%\n" something
				
				if first > 0 then
				(
					-- Triangle strip
					local numStripVerts = first
					
					totalTris += numStripVerts - 2
					
					Check (numStripVerts > 2) "Triangle strip has too few vertices!"

					--format "Tri strip % verts\n" numStripVerts
					
					local v1 = MDX_glVertex()
					local v2 = MDX_glVertex()
					v2.LoadFromStream bstream
					local v3 = MDX_glVertex()
					v3.LoadFromStream bstream
					
					local texCoordStart = texCoordList.count
					
					append texCoordList v2.st
					append texCoordList v3.st
				
					for i = 1 to (numStripVerts - 2) do
					(
						v1 = copy v2
						v2 = copy v3
						v3.LoadFromStream bstream
						
						append texCoordList v3.st
						
						-- As we create the strip, the vertex winding changes...
						if (bit.and i 1) == 0 then
						(
							append glTris		[v1.vertexIndex + 1, v2.vertexIndex + 1, v3.vertexIndex + 1]
							append glTexTris	[texCoordStart + i + 2, texCoordStart + i + 1, texCoordStart + i]
						)
						else
						(
							append glTris		[v3.vertexIndex + 1, v2.vertexIndex + 1, v1.vertexIndex + 1]
							append glTexTris	[texCoordStart + i, texCoordStart + i + 1, texCoordStart + i + 2]
						)
					)
					
					
				)
				else if first < 0 then
				(
					-- Triangle fan
					
					local numFanVerts = -first
				--	format "Tri fan % verts\n" numFanVerts
					
					totalTris += numFanVerts - 2
					
					local v1 = MDX_glVertex()
					v1.LoadFromStream bstream
					local v2 = MDX_glVertex()
					local v3 = MDX_glVertex()
					v3.LoadFromStream bstream
					
					local texCoordStart = texCoordList.count
					
					append texCoordList v1.st
					append texCoordList v3.st
					
					for i = 1 to (numFanVerts - 2) do
					(
						v2 = copy v3
						v3.LoadFromStream bstream
						
						append texCoordList v3.st
						append glTris		[v3.vertexIndex + 1, v2.vertexIndex + 1, v1.vertexIndex + 1]
						append glTexTris	[texCoordStart + 1, texCoordStart + i + 1, texCoordStart + i + 2]
					)
					
				) else if first == 0 then
				(
					isFinished = true
				)
			)
		--	format "OK (% total strip/fan tris)\n" totalTris
		), --end glCmd
	
		fn LoadModel=
		(
			fseek bstream 0 #seek_set
			
			local magic 			= ReadLong bstream #unsigned
			
			if magic != 0x58504449 then
			(
				FatalError "File does not appear to be an MDX model!"
			)
			
			local version			= ReadLong bstream #unsigned
			
			if version != 0x4 then
			(
				FatalError "Unsupported version!"
			)
			
			local skinWidth			= ReadLong bstream #unsigned
			local skinHeight 		= ReadLong bstream #unsigned
			local frameSize			= ReadLong bstream #unsigned
			local numSkins			= ReadLong bstream #unsigned
			numVerts				= ReadLong bstream #unsigned
			local numTris			= ReadLong bstream #unsigned
			local numGLCmds			= ReadLong bstream #unsigned
			numFrames				= ReadLong bstream #unsigned
			local numSfxDefines		= ReadLong bstream #unsigned
			local numSfxEntries		= ReadLong bstream #unsigned
			local numSubObjects		= ReadLong bstream #unsigned
			
			local offsetSkins		= ReadLong bstream #unsigned
			local offsetTris		= ReadLong bstream #unsigned
			offsetFrames			= ReadLong bstream #unsigned
			local offsetGLCmds		= ReadLong bstream #unsigned
			local offsetVertexInfo 		= ReadLong bstream #unsigned
   			local offsetSfxDefines 		= ReadLong bstream #unsigned
   			local offsetSfxEntries 		= ReadLong bstream #unsigned
   			local offsetBBoxFrames 		= ReadLong bstream #unsigned
   			local offsetDummyEnd 		= ReadLong bstream #unsigned
			local offsetEnd			= ReadLong bstream #unsigned
			
			format "Skin size (%, %)\n" skinWidth skinHeight
			format "Frame size % bytes\n" frameSize
			format "% skins, % verts, % tris, % glCmds, % frames, % sfx-defines, % sfx-entries, % sub-objects\n" numSkins numVerts numTris numGLCmds numFrames numSfxDefines numSfxEntries numSubObjects
			
			if not animCheck.checked then
			(
				numFrames = 1
			)
			
			ReadSkins offsetSkins numSkins
			--Read GLCmds and hopefully get the texture coords out of it
			ReadGLCmds offsetGLCmds numGLCmds
			
		),
		
		fn CreateMAXModel=
		(
			-- Firstly, create our material
			local skinMaterial = standardMaterial name:(modelName + " material")

			-- Load .TGA skins either from proper game path or current directory
			if skinList.count > 0 then
			(
				local localPath = GetFullTexturePath skinList[1]
				local skinTexture
				local doRename = False
				
				format "complete Skin= %\n" localPath	
				-- Try and load from game base path
				if (doesMyKPFileExist localPath) then
				(	
					--pcx file!!!
					if (stricmp (getFilenameType localPath) ".pcx") == 0 then
					(
						doRename = queryBox \
									"Cannot load/display .pcx files in max.\n" \
									"_KP Exporter will still use this file if it exists,\n" \ 
									"but it will use the image size of 256x256\n\n" \
									"Do you want to rename max shader to .tga?\n" \
									title:"Found .PCX file"		
						if doRename == True then 
							localPath = substituteString localPath ".pcx" ".tga"
					)		

					try
					(
						skinTexture = bitmapTexture filename:localPath
						
						skinMaterial.maps[2] = skinTexture
						skinMaterial.mapEnables[2] = true
						showTextureMap skinMaterial skinTexture true
						format "Skin texture % loaded\n" localPath
					)
					catch
					(
						format "Warning: Invalid texture %\n" localPath
					)
				)
				else
				(
					-- Try using the path of the model
					newLocalPath = modelPath + (filenameFromPath localPath)
					
					if doesMyKPFileExist newLocalPath then
					(
						try
						(
							skinTexture = bitmapTexture filename:newLocalPath
							
							skinMaterial.maps[2] = skinTexture
							skinMaterial.mapEnables[2] = true
							showTextureMap skinMaterial skinTexture true
							
							format "Skin texture % loaded\n" newLocalPath
						)
						catch
						(
							format "Warning: Invalid texture %\n" newLocalPath
						)
					)
					else
					(
						--format "Warning: Cannot find texture file % or %\n" localPath newLocalPath
						messageBox "Could not load the model skin!\nPlease locate the skin to load it" title:"MDX Importer"

						local newSkinFilename = getOpenFileName caption:"Load TGA Skin" \
						types:"Targa TGA (*.tga)|*.tga|All Files (*.*)|*.*|"

						if newSkinFilename == undefined then
						(
							format "Warning: Could not load the skin for this model!\n"
						)
						else
						(
							if doesMyKPFileExist newSkinFilename then
							(
								try
								(
									skinTexture = bitmapTexture filename:newSkinFilename
						
									skinMaterial.maps[2] = skinTexture
									skinMaterial.mapEnables[2] = true
									showTextureMap skinMaterial skinTexture true
						
									format "Skin texture % loaded\n" newSkinFilename
								)
								catch
								(
									format "Warning: Invalid texture %\n" newSkinFilename
								)
							)
						)
					)
				)
			)
			--maxOps.setKeyFilters??
			--get current tangent type (max 8+)
			maxops.getDefaultTangentType &inTangent &outTangent		
			--set tangent to step { #smooth|#linear|#step|#fast|#slow|#custom|#flat } 
			maxops.setDefaultTangentType #step #step
						
			-- Load vertices for first frame
			local verts = #()
			fseek bstream offsetFrames #seek_set
			
			local firstFrame = MDX_Frame()
			firstFrame.LoadFromStream bstream
					
			for v = 1 to numVerts do
			(
				local mdxVertex = MDX_Vertex()
				mdxVertex.LoadFromStream bstream
				append verts ((mdxVertex.pos * firstFrame.scale) + firstFrame.translate)
			)
			
			-- Create the mesh object
			local theMesh = mesh name:(modelName + ".mdx") vertices:verts faces:glTris\
								material:skinMaterial tverts:texCoordList
			
			-- Add in the texture faces to get our texcoords ready
			buildTVFaces theMesh false
			for i = 1 to glTexTris.count do
			(
				local theFace = glTexTris[i]
				setTVFace theMesh i [theFace.z, theFace.y, theFace.x]
				setFaceSmoothGroup theMesh i 1 --hypov8 add smothgtoups set all to 1
			)
			update theMesh		
								
			-- Load and set animation frames from disk (not preloaded to save memory)
			gc()
			
			fseek bstream offsetFrames #seek_set
			
			progressStart "Loading frames, please wait..."
			animate on
			(
				format "Loading % frames...\n" numFrames
				
				-- (FIX: This was moved up here for all frames to get properly scaled in 3dsMax's timeline after Reset is pressed)
				-- Set animation FPS 
				frameRate = 10.0
				
				-- Now create animation frames
				
				local mdxFrame = MDX_Frame()
				
				for i = 1 to numFrames do
				(
					mdxFrame.LoadFromStream bstream
					
					at time (i-1) --hypov8 -1
					(
						local mdxVertex = MDX_Vertex()
						for v = 1 to numVerts do
						(
							mdxVertex.LoadFromStream bstream
							meshop.SetVert theMesh v ((mdxVertex.pos * mdxFrame.scale) + mdxFrame.translate)
						)
					)
					
					if (mod i 4) == 0 then
					(
						progressUpdate ((100*i) / numFrames)
					)
				)
			)
			--set tangent back to default. linear? { #smooth | #linear | #step | #fast | #slow | #custom | #flat } 
			maxops.setDefaultTangentType inTangent outTangent
			
			progressEnd()
			update theMesh
			
			-- Set animation slider range and FPS
			if numFrames > 1 then
			(
				animationRange = interval 0 (numFrames-1) --hypov8 -1
			)
			
			--frameRate = 10.0
			
			gc()
		)
	)






	
	--------------------------------------------------------------------
	-- MD2 Importer
	--------------------------------------------------------------------
	struct MD2_Vertex
	(
		pos, lightNormalIndex
	)

	struct MD2_Frame
	(
		scale, translate, name,
		vertListOffset
	)
	
	struct MD2_Tri
	(
		vertIndices,
		texCoordIndices
	)

	struct MD2_glVertex
	(
		st,
		vertexIndex,
		
		fn LoadFromStream bstream=
		(
			local s = ReadFloat bstream
			local t = ReadFloat bstream
			t -= 1.0 --add hypov8
			st = [s, -t, 0.0]
			vertexIndex = ReadLong bstream #unsigned
		)
	)
	
	struct MD2Reader
	(
		modelFilename, modelName, modelPath,
		bstream,
		skinList,
		triList,
		frameList,
		texCoordList,
		--glCmdList,
		numVerts,
		
		glTris,
		glTexTris,
				
		fn Open filename=
		(
			print("==fOpen==")
			modelFilename = filename
			modelName = getFilenameFile filename
			modelPath = getFileNamePath filename
			bstream = fopen filename "rb"
			ok
		),
		
		fn Close=
		(
			fclose bstream
			ok
		),
		
		fn ReadSkins offset numSkins=
		(
			fseek bstream offset #seek_set
			
			skinList = #()
			
			format "Reading % skins..." numSkins
			for i = 1 to numSkins do
			(
				append skinList (ReadFixedString bstream 64)
				format "Skin %: %\n" i skinList[i]
			)
			format "OK\n"
		),
		
		fn ReadTris offset numTris=
		(
			fseek bstream offset #seek_set
			
			triList = #()
			
			format "Reading % tris..." numTris
			
			for i = 1 to numTris do
			(
				local v1 = ReadShort bstream #unsigned
				local v2 = ReadShort bstream #unsigned
				local v3 = ReadShort bstream #unsigned
				
				local uv1 = ReadShort bstream #unsigned
				local uv2 = ReadShort bstream #unsigned
				local uv3 = ReadShort bstream #unsigned
				append triList (MD2_Tri vertIndices:[v1, v2, v3] texCoordIndices:[uv1,uv2,uv3])
			)
			
			format "OK\n"
		),
		
		--hypov8 add glCmd
				
		fn ReadGLCmds offset numGLCmds=
		(
			fseek bstream offset #seek_set
			
		--	format "GLCmds at %\n" (bit.intAsHex offset)
			format "Reading % GLCmds...\n" numGLCmds
			
			local isFinished = false
			
			texCoordList = #()
			
			local totalTris = 0
			
			glTris = #()
			glTexTris = #()
			
			while not isFinished do
			(
				local first = ReadLong bstream #signed
				
				-- Subobject iD? --hypo not in md2
				--local something = ReadLong bstream #unsigned
				
				if first > 0 then
				(
					-- Triangle strip
					local numStripVerts = first
					
					totalTris += numStripVerts - 2
					
					Check (numStripVerts > 2) "Triangle strip has too few vertices!"

					--format "Tri strip % verts\n" numStripVerts
					
					local v1 = MD2_glVertex()
					local v2 = MD2_glVertex()
					v2.LoadFromStream bstream
					local v3 = MD2_glVertex()
					v3.LoadFromStream bstream
					
					local texCoordStart = texCoordList.count
					
					append texCoordList v2.st
					append texCoordList v3.st
				
					for i = 1 to (numStripVerts - 2) do
					(
						v1 = copy v2
						v2 = copy v3
						v3.LoadFromStream bstream
						
						append texCoordList v3.st
						
						-- As we create the strip, the vertex winding changes...
						if (bit.and i 1) == 0 then
						(
							append glTris		[v1.vertexIndex + 1, v2.vertexIndex + 1, v3.vertexIndex + 1]
							append glTexTris	[texCoordStart + i + 2, texCoordStart + i + 1, texCoordStart + i]
						)
						else
						(
							append glTris		[v3.vertexIndex + 1, v2.vertexIndex + 1, v1.vertexIndex + 1]
							append glTexTris	[texCoordStart + i, texCoordStart + i + 1, texCoordStart + i + 2]
						)
					)
					
					
				)
				else if first < 0 then
				(
					-- Triangle fan
					
					local numFanVerts = -first
				--	format "Tri fan % verts\n" numFanVerts
					
					totalTris += numFanVerts - 2
					
					local v1 = MD2_glVertex()
					v1.LoadFromStream bstream
					local v2 = MD2_glVertex()
					local v3 = MD2_glVertex()
					v3.LoadFromStream bstream
					
					local texCoordStart = texCoordList.count
					
					append texCoordList v1.st
					append texCoordList v3.st
					
					for i = 1 to (numFanVerts - 2) do
					(
						v2 = copy v3
						v3.LoadFromStream bstream
						
						append texCoordList v3.st
						append glTris		[v3.vertexIndex + 1, v2.vertexIndex + 1, v1.vertexIndex + 1]
						append glTexTris	[texCoordStart + 1, texCoordStart + i + 1, texCoordStart + i + 2]
					)
					
				) else if first == 0 then
				(
					isFinished = true
				)
			)
		--	format "OK (% total strip/fan tris)\n" totalTris
		), --end glCmd
		
		fn ReadFrames offset numFrames=
		(
			fseek bstream offset #seek_set
			frameList = #()
			format "Reading % frames..." numFrames
			for i = 1 to numFrames do
			(
				local sx = ReadFloat bstream
				local sy = ReadFloat bstream
				local sz = ReadFloat bstream
				
				local tx = ReadFloat bstream
				local ty = ReadFloat bstream
				local tz = ReadFloat bstream
				
				local name = ReadFixedString bstream 16
				
				local newFrame = MD2_Frame scale:[sx, sy, sz] translate:[tx,ty, tz] name:name

				-- Just remember where the verts are
				newFrame.vertListOffset = ftell bstream
				
				-- Skip all verts 'cos we'll read 'em later
				SkipBytes bstream (numVerts * 4)
					
				append frameList newFrame
			)
			format "OK\n"
		),
		
		fn ReadTexCoords offset numTexCoords skinWidth skinHeight=
		(
			fseek bstream offset #seek_set
			texCoordList = #()
			glTris = #() --add hypo just incase
			glTexTris = #() --add hypo just incase
			
			format "Reading % texcoords..." numTexCoords
			for i = 1 to numTexCoords do
			(
				local s = (ReadShort bstream #unsigned) as float
				local t = (ReadShort bstream #unsigned) as float
				local t1 = (-t / skinHeight) + 1.0 -- FIX: Before the texture wasn't fitted in the box but below it (3dsmax)
				
				append texCoordList [s / skinWidth, t1, 0]
			)
			format "OK\n"
		),
	
		fn LoadModel=
		(
			fseek bstream 0 #seek_set
			
			local magic 			= ReadLong bstream #unsigned
			
			if magic != 0x32504449 then
			(
				FatalError "File does not appear to be an MD2 model!"
			)
			
			local version			= ReadLong bstream #unsigned
			
			if version != 0x8 then
			(
				FatalError "Unsupported version!"
			)
			
			local skinWidth			= ReadLong bstream #unsigned
			local skinHeight 		= ReadLong bstream #unsigned
			local frameSize			= ReadLong bstream #unsigned
			local numSkins			= ReadLong bstream #unsigned
			numVerts				= ReadLong bstream #unsigned
			local numTexCoords		= ReadLong bstream #unsigned
			local numTris			= ReadLong bstream #unsigned
			local numGLCmds			= ReadLong bstream #unsigned
			local numFrames			= ReadLong bstream #unsigned
			local offsetSkins		= ReadLong bstream #unsigned
			local offsetTexCoords	= ReadLong bstream #unsigned
			local offsetTris		= ReadLong bstream #unsigned
			local offsetFrames		= ReadLong bstream #unsigned
			local offsetGLCmds		= ReadLong bstream #unsigned
			local offsetEnd			= ReadLong bstream #unsigned
			
			format "--== num glCmd ==-- %\n" numGLCmds	
			
			format "Skin size (%, %)\n" skinWidth skinHeight
			format "Frame size % bytes\n" frameSize
			format "% skins, % verts, % texcoords, % tris, % glCmds, % frames\n" numSkins numVerts numTexCoords numTris numGLCmds numFrames
			
			if not animCheck.checked then
			(
				numFrames = 1
			)
			
			ReadSkins offsetSkins numSkins
			ReadTexCoords offsetTexCoords numTexCoords skinWidth skinHeight
			ReadTris offsetTris numTris	
			ReadFrames offsetFrames numFrames
			
			if numGLCmds > 1 then --add hypov8. glCmds are floats. kp requires these to load so should allways exist
				ReadGLCmds offsetGLCmds numGLCmds		
		),
		
		fn GetVertsForFrame frameNum=
		(
			local verts = #()
			for i = 1 to ((frameList[frameNum]).vertList).count do
			(
				local theVert = (frameList[frameNum].vertList[i]).pos
				
				theVert *= frameList[frameNum].scale
				theVert += frameList[frameNum].translate
			
				append verts theVert
			)
			verts				
		),
		
		fn CreateMAXModel=
		(
			-- Firstly, create our material
			local skinMaterial = standardMaterial name:(modelName + ".skin")

			-- Sadly, we can't load PCX files in gmax - so no skins! :(
----------hypo skins			
			-- Load .TGA skins either from proper game path or current directory
			if skinList.count > 0 then
			(
				local localPath = GetFullTexturePath skinList[1]
				local skinTexture
				
				format "complete Skin= %\n" localPath
				format "exten= %\n" (getFilenameType localPath)

				-- Try and load from game base path
				if (doesMyKPFileExist localPath) then
				(
					try
					(
						skinTexture = bitmapTexture filename:localPath
						
						skinMaterial.maps[2] = skinTexture
						skinMaterial.mapEnables[2] = true
						showTextureMap skinMaterial skinTexture true
						format "Skin texture % loaded" localPath
					)
					catch
					(
						format "Warning: Invalid texture %\n" localPath
					)
				
				)
				else
				(
					-- Try using the path of the model
					newLocalPath = modelPath + (filenameFromPath localPath)
					
					if doesMyKPFileExist newLocalPath then
					(
						try
						(
							skinTexture = bitmapTexture filename:newLocalPath
							
							skinMaterial.maps[2] = skinTexture
							skinMaterial.mapEnables[2] = true
							showTextureMap skinMaterial skinTexture true
							
							format "Skin texture % loaded" newLocalPath
						)
						catch
						(
							format "Warning: Invalid texture %\n" newLocalPath
						)
					)
					else
					(
						--format "Warning: Cannot find texture file % or %\n" localPath newLocalPath
						messageBox "Could not load the model skin!\nPlease locate the skin to load it" title:"MDX Importer"

						local newSkinFilename = getOpenFileName caption:"Load TGA Skin" \
						types:"Targa TGA (*.tga)|*.tga|All Files (*.*)|*.*|"

						if newSkinFilename == undefined then
						(
							format "Warning: Could not load the skin for this model!\n"
						)
						else
						(
							if doesMyKPFileExist newSkinFilename then
							(
								try
								(
									skinTexture = bitmapTexture filename:newSkinFilename
						
									skinMaterial.maps[2] = skinTexture
									skinMaterial.mapEnables[2] = true
									showTextureMap skinMaterial skinTexture true
						
									format "Skin texture % loaded\n" newSkinFilename
								)
								catch
								(
									format "Warning: Invalid texture %\n" newSkinFilename
								)
							)

						)
					)
				)
			)
--------end hypo skins	

			--get current tangent type
			maxops.getDefaultTangentType &inTangent &outTangent
			--set tangent to step { #smooth|#linear|#step|#fast|#slow|#custom|#flat } 
			maxops.setDefaultTangentType #step #step
			
			-- Load vertices for first frame
			local verts = #()
			fseek bstream (frameList[1].vertListOffset) #seek_set
			
			for i = 1 to numVerts do
			(
				local x = ReadByte bstream #unsigned
				local y = ReadByte bstream #unsigned
				local z = ReadByte bstream #unsigned
				local normIndex = ReadByte bstream #unsigned
				
				local theVert = ([x, y, z] * (frameList[1].scale)) + (frameList[1].translate)
			
				append verts theVert
			)
			
			local tris = #()
			for i = 1 to triList.count do
			(
				local v = triList[i].vertIndices + [1,1,1]
				append tris [v.z, v.y, v.x]
				
			)
			
			if glTris.count > 1 then
				tris = glTris
			
			-- Create the mesh object
			local theMesh = mesh name:(modelName + ".md2") vertices:verts faces:tris \
								material:skinMaterial tverts:texCoordList

			-- Set texcoord faces (so user just needs to load a converted skin PCX file)
			buildTVFaces theMesh false
			if glTexTris.count <= 1 then
			(
				format "no glCommands #%\n"glTexTris.count
				for i = 1 to triList.count do
				(
					local tcVert = triList[i].texCoordIndices + [1,1,1]
					setTVFace theMesh i [tcVert.z, tcVert.y, tcVert.x]
					setFaceSmoothGroup theMesh i 1 --hypov8 add smothgtoups set all to 1
				)
			)	
			else
			(
				--glCmds
				for i = 1 to glTexTris.count do
				(
					local theFace = glTexTris[i]
					setTVFace theMesh i [theFace.z, theFace.y, theFace.x]
					setFaceSmoothGroup theMesh i 1 --hypov8 add smothgtoups set all to 1
				)		
			)
			
			-- Set vertices up for animation
			animateVertex theMesh #all
			local animVerts = theMesh[4][1]
											
			-- Set animation frames			
			progressStart "Loading frames"
			animate on
			(
				-- Now create animation frames
				
				
				-- (FIX: This was moved up here for all frames to get properly scaled in 3dsMax's timeline after Reset is pressed)
				-- Set animation FPS 
				frameRate = 10.0
				
				
				for i = 1 to frameList.count do --hypov8 todo got twice??
				(
					local frameScale = frameList[i].scale
					local frameTranslate = frameList[i].translate

					
					
					fseek bstream (frameList[i].vertListOffset) #seek_set
					
					at time (i-1) --hypov8 -1
					(
						for j = 1 to numVerts do
						(
							local x = ReadByte bstream #unsigned
							local y = ReadByte bstream #unsigned
							local z = ReadByte bstream #unsigned
							local normIndex = ReadByte bstream #unsigned
							
							animVerts[j].value = ([x, y, z] * frameScale) + frameTranslate
						)
					)
					if (mod i 5) == 0 then
					(
						progressUpdate ((100 * i) / frameList.count)
					)
				)
			)
			--set tangent back to default. linear? { #smooth | #linear | #step | #fast | #slow | #custom | #flat } 
			maxops.setDefaultTangentType inTangent outTangent
			
			progressEnd()
			update theMesh
			
			-- Set animation slider range
			if frameList.count > 1 then
			(
				animationRange = interval 0 (frameList.count-1) --hypov8 -1
			)
			--frameRate = 10.0
			
			
			gc()
		)
	) --end MD2Reader
	
	
	--mdx / md2 
	on importButton_MDX pressed do
	(
		g_fullPath = undefined
		local sTmp = "/tris.mdx"
		local modelFilename = getOpenFileName caption:"Import MDX Model" \
							types:"Kingpin Models (.mdx/.md2)|*.md*|Kingpin MDX|*.mdx|Kingpin MD2|*.md2|All Files (*.*)|*.*|" \
							filename:(g_basePath + sTmp)
		
		if modelFilename != undefined and (doesMyKPFileExist modelFilename) then
		(		
			g_fullPath = modelFilename
			local fileExt = getFilenameType modelFilename
			local reader
			
			format "fileEXT= %\n" fileExt
			
			--try
			(			
				if (stricmp fileExt ".mdx") == 0 then
					reader = MDXReader()
				else if (stricmp fileExt ".md2") == 0 then
					reader = MD2Reader()
				else
				(
					messageBox "Incorrect file type" title:"MDX/MD2 Importer"
					return false
				)
				
				reader.Open modelFilename
				reader.LoadModel()
				reader.CreateMAXModel()
				reader.Close()	
				max views redraw				
			)
			--catch
			(
				--throw
				--FatalError "Error end"
			)
		)
	)
	

	
	fn UpdateUI=
	(
		local theDir = g_basePath
		if theDir == undefined do
		(
			theDir = "<undefined>"
		)
		UI_basePathEdit.text = theDir
	)	
	
	----------------------------------	
	---| button |--- info
	----------------------------------
	on UI_info_about pressed do
	(
		print("info------")
		messagebox(string_1 +string_2+string_3+string_4) title:Kingpin_MDX_Importer_ver
	)
	

	
	on KP_Model_Importer open do
	(
		--addRollout baz rolledUp:false
		
		local sTmp1 = "C:\\Program Files\\Kingpin\\main"
		local sTmp2 = "C:\\Games\\Kingpin\\main"	
		local sTmp3 = "D:\\Games\\Kingpin\\main"		

		if (doesFileExist sTmp1) == true then
		(
			g_basePath = sTmp1; print "path1\n"
			
		)
		else if (doesFileExist sTmp2) == true then 
		(
			g_basePath = sTmp2; print "path2\n"
		)
		else if (doesFileExist sTmp3) == true then 
		(
			g_basePath = sTmp3; print "path3\n"
		)
		
		format "pathFount=%\n" g_basePath
		
		UpdateUI()
	)
	on KP_Model_Importer close do
	(	
		--removeRollout baz
	
	)
	
	on UI_basePathEdit entered newText do
	(
		print("***bsePath md2 update\n")
		g_basePath = newText
	)

 	on setBasePathButton pressed do
	(
		local newBasePath = getSavePath caption:"Set Base Kingpin Directory"
		if newBasePath != undefined do
		(
			g_basePath = newBasePath
			UpdateUI()
		)
	)
	
	
)



