/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

public class Config {
    private final File configFile = new File("surface_generator.config");
    private File workingDirectory;
    private int screenWidth;
    private int screenHeight;

    public Config() {
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        this.screenWidth = screenSize.width;
        this.screenHeight = screenSize.height;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.configFile));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] token = line.split("\t");
                if (!token[0].equals("workingDirectory")) continue;
                this.setWorkingDirectory(new File(token[1]));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void saveConfig() {
        try (PrintWriter writer = new PrintWriter(new FileWriter(this.configFile));){
            if (this.workingDirectory != null) {
                writer.println("workingDirectory\t" + this.workingDirectory.getAbsolutePath());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File newWorkingDirectory) {
        if (newWorkingDirectory != null & newWorkingDirectory.isDirectory()) {
            this.workingDirectory = newWorkingDirectory;
            this.saveConfig();
        }
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }
}

