/*
 * Decompiled with CFR 0.152.
 */
package generators;

import com.nerius.math.geom.Point3D;
import com.nerius.math.xform.AffineTransform3D;
import com.nerius.math.xform.AxisRotation3D;
import com.nerius.math.xform.Translation3D;
import generators.Shutdown;
import tools.MapFactory;

class GenerationUtils {
    public static final int SHINGLES_TYPE_CYL = 0;
    public static final int SHINGLES_TYPE_RAMP_SQTOP = 1;
    public static final int SHINGLES_TYPE_RAMP_TRITOP = 2;
    static final int ADJUST_FOR_OVERLAPPING_BOWL_CUTS = 2;
    static final int ADJUST_FOR_OVERLAPPING_PIPE_CUTS = 1;
    static final int ADJUST_NONE = 0;
    private static int FUDGE_DIVISIONS_QUARTER = 1000000;
    private static double FUDGE_ANGLE_INCR = 1.5707963267948966 / (double)FUDGE_DIVISIONS_QUARTER;
    private static int brushCount = 0;

    GenerationUtils() {
    }

    static Point3D[] generatePipeCurve(double radius, int slices, int extrudeTopNSlices, double extrudeRadiusFactor, int adjustMask) {
        int z2;
        int z1;
        Point3D pt0 = new Point3D(radius, 0.0, 0.0);
        Point3D[] curve = new Point3D[slices + 1];
        for (int i = 0; i <= slices; ++i) {
            AxisRotation3D rot = new AxisRotation3D(2, Math.PI * (double)i / (double)(2 * slices));
            curve[i] = rot.transform(pt0);
        }
        Point3D extrudePt0 = null;
        Point3D centerExtrude = null;
        double radiansExtrudeStep = 0.0;
        if (extrudeTopNSlices > 0) {
            extrudePt0 = curve[extrudeTopNSlices];
            centerExtrude = new Point3D(extrudePt0.x - extrudeRadiusFactor * extrudePt0.x, extrudePt0.y, extrudePt0.z - extrudeRadiusFactor * extrudePt0.z);
            double radiansToRim = 0.0;
            double alpha = Math.PI * (double)extrudeTopNSlices / (double)(2 * slices);
            double c = radius * extrudeRadiusFactor;
            double b = extrudePt0.z - extrudeRadiusFactor * extrudePt0.z;
            double gamma = Math.asin(b / c);
            radiansToRim = alpha - gamma;
            radiansExtrudeStep = radiansToRim / (double)extrudeTopNSlices;
            for (int i = extrudeTopNSlices - 1; i >= 0; --i) {
                double radians = radiansExtrudeStep * (double)(extrudeTopNSlices - i);
                AffineTransform3D xform = new Translation3D(-centerExtrude.x, 0.0, -centerExtrude.z);
                xform = xform.concatenatePost(new AxisRotation3D(2, -radians));
                xform = xform.concatenatePost(new Translation3D(centerExtrude.x, 0.0, centerExtrude.z));
                curve[i] = xform.transform(extrudePt0);
            }
        }
        if ((adjustMask & 1) != 0 || (adjustMask & 2) != 0) {
            int adjusted = 0;
            while (0 - (z1 = (int)Math.round(curve[1].z)) < z1 - (z2 = (int)Math.round(curve[2].z))) {
                Point3D pt;
                AffineTransform3D xform;
                ++adjusted;
                if (1 < extrudeTopNSlices) {
                    xform = new Translation3D(-centerExtrude.x, 0.0, -centerExtrude.z);
                    xform = xform.concatenatePost(new AxisRotation3D(2, (double)adjusted * FUDGE_ANGLE_INCR - radiansExtrudeStep * (double)(extrudeTopNSlices - 1)));
                    xform = xform.concatenatePost(new Translation3D(centerExtrude.x, 0.0, centerExtrude.z));
                    pt = extrudePt0;
                } else {
                    xform = new AxisRotation3D(2, Math.PI / (double)(2 * slices) + FUDGE_ANGLE_INCR * (double)adjusted);
                    pt = pt0;
                }
                curve[1] = xform.transform(pt);
            }
            if (adjusted > 0) {
                System.err.println("WARNING: Adjusted vertex second from top by moving it down\n  " + adjusted + "/" + FUDGE_DIVISIONS_QUARTER + " of a quarter circle.");
            }
        }
        if ((adjustMask & 2) != 0) {
            int z3;
            int z22;
            int adjusted = 0;
            while (0 - (z1 = (int)Math.round(curve[1].z)) != z1 - (z2 = (int)Math.round(curve[2].z))) {
                Point3D pt;
                AffineTransform3D xform;
                ++adjusted;
                if (2 < extrudeTopNSlices) {
                    xform = new Translation3D(-centerExtrude.x, 0.0, -centerExtrude.z);
                    xform = xform.concatenatePost(new AxisRotation3D(2, (double)adjusted * FUDGE_ANGLE_INCR - radiansExtrudeStep * (double)(extrudeTopNSlices - 2)));
                    xform = xform.concatenatePost(new Translation3D(centerExtrude.x, 0.0, centerExtrude.z));
                    pt = extrudePt0;
                } else {
                    xform = new AxisRotation3D(2, Math.PI * 2 / (double)(2 * slices) + FUDGE_ANGLE_INCR * (double)adjusted);
                    pt = pt0;
                }
                curve[2] = xform.transform(pt);
            }
            if (adjusted > 0) {
                System.err.println("WARNING: Adjusted vertex third from top by moving it down\n  " + adjusted + "/" + FUDGE_DIVISIONS_QUARTER + " of a quarter circle.");
            }
            adjusted = 0;
            while (((z22 = (int)Math.round(curve[2].z)) - (z3 = (int)Math.round(curve[3].z))) * 2 > 0 - z22) {
                Point3D pt;
                AffineTransform3D xform;
                ++adjusted;
                if (3 < extrudeTopNSlices) {
                    xform = new Translation3D(-centerExtrude.x, 0.0, -centerExtrude.z);
                    xform = xform.concatenatePost(new AxisRotation3D(2, (double)adjusted * FUDGE_ANGLE_INCR - radiansExtrudeStep * (double)(extrudeTopNSlices - 3)));
                    xform = xform.concatenatePost(new Translation3D(centerExtrude.x, 0.0, centerExtrude.z));
                    pt = extrudePt0;
                } else {
                    xform = new AxisRotation3D(2, Math.PI * 3 / (double)(2 * slices) + FUDGE_ANGLE_INCR * (double)adjusted);
                    pt = pt0;
                }
                curve[3] = xform.transform(pt0);
            }
            if (adjusted > 0) {
                System.err.println("WARNING: Adjusted vertex fourth from top by moving it down\n  " + adjusted + "/" + FUDGE_DIVISIONS_QUARTER + " of a quarter circle.");
            }
        }
        if ((adjustMask & 1) != 0) {
            int x2;
            int x1;
            int adjusted = 0;
            int inx = slices - 1;
            while ((x1 = (int)Math.round(curve[inx].x)) - 0 < (x2 = (int)Math.round(curve[inx - 1].x)) - x1) {
                Point3D pt;
                AffineTransform3D xform;
                ++adjusted;
                if (inx <= extrudeTopNSlices) {
                    xform = new Translation3D(-centerExtrude.x, 0.0, -centerExtrude.z);
                    xform = xform.concatenatePost(new AxisRotation3D(2, -((double)adjusted * FUDGE_ANGLE_INCR) - radiansExtrudeStep * (double)(extrudeTopNSlices - inx)));
                    xform = xform.concatenatePost(new Translation3D(centerExtrude.x, 0.0, centerExtrude.z));
                    pt = extrudePt0;
                } else {
                    xform = new AxisRotation3D(2, Math.PI * (double)inx / (double)(2 * slices) - FUDGE_ANGLE_INCR * (double)adjusted);
                    pt = pt0;
                }
                curve[inx] = xform.transform(pt);
            }
            if (adjusted > 0) {
                System.err.println("WARNING: Adjusted vertex second from bottom by moving it up\n  " + adjusted + "/" + FUDGE_DIVISIONS_QUARTER + " of a quarter circle.");
            }
        }
        return curve;
    }

    static void startMap() {
        brushCount = 0;
        MapFactory.newText();
        MapFactory.addLine("{");
        MapFactory.addLine("\"classname\" \"worldspawn\"");
    }

    static void endMap() {
        MapFactory.addLine("}");
        System.err.println("Wrote " + brushCount + " brushes.");
        Shutdown.abort();
    }

    static void startBrush() {
        ++brushCount;
        MapFactory.addLine("{");
    }

    static void endBrush() {
        MapFactory.addLine("}");
    }

    static void writeFace(Point3D pt1, Point3D pt2, Point3D pt3) {
        MapFactory.addLine("");
        GenerationUtils.writePoint(pt1);
        MapFactory.add(" ");
        GenerationUtils.writePoint(pt2);
        MapFactory.add(" ");
        GenerationUtils.writePoint(pt3);
        MapFactory.add(" common/caulk 0 0 0 0.500000 0.500000 0 0 0");
    }

    private static void writePoint(Point3D pt) {
        MapFactory.add("( " + Math.round(pt.x) + " " + Math.round(pt.y) + " " + Math.round(pt.z) + " )");
    }

    static void writeBrushExtendX(int x, Point3D pt1, Point3D pt2, Point3D pt3, boolean extrude) {
        if (extrude) {
            pt1 = new Point3D(Math.round(pt1.x), Math.round(pt1.y), Math.round(pt1.z));
            pt2 = new Point3D(Math.round(pt2.x), Math.round(pt2.y), Math.round(pt2.z));
            pt3 = new Point3D(Math.round(pt3.x), Math.round(pt3.y), Math.round(pt3.z));
            Point3D newPt1 = new Point3D(pt1.x + (pt1.x - pt2.x) + (pt1.x - pt3.x), pt1.y + (pt1.y - pt2.y) + (pt1.y - pt3.y), pt1.z + (pt1.z - pt2.z) + (pt1.z - pt3.z));
            Point3D newPt2 = new Point3D(pt2.x + (pt2.x - pt1.x) + (pt2.x - pt3.x), pt2.y + (pt2.y - pt1.y) + (pt2.y - pt3.y), pt2.z + (pt2.z - pt1.z) + (pt2.z - pt3.z));
            Point3D newPt3 = new Point3D(pt3.x + (pt3.x - pt1.x) + (pt3.x - pt2.x), pt3.y + (pt3.y - pt1.y) + (pt3.y - pt2.y), pt3.z + (pt3.z - pt1.z) + (pt3.z - pt2.z));
            pt1 = newPt1;
            pt2 = newPt2;
            pt3 = newPt3;
        }
        GenerationUtils.startBrush();
        GenerationUtils.writeFace(pt1, pt2, pt3);
        GenerationUtils.writeFace(pt1, new Point3D(x, pt1.y, pt1.z), pt2);
        GenerationUtils.writeFace(pt2, new Point3D(x, pt2.y, pt2.z), pt3);
        GenerationUtils.writeFace(pt3, new Point3D(x, pt3.y, pt3.z), pt1);
        GenerationUtils.writeFace(new Point3D(x, pt3.y, pt3.z), new Point3D(x, pt2.y, pt2.z), new Point3D(x, pt1.y, pt1.z));
        GenerationUtils.endBrush();
    }

    static void writeBrushExtendX(int x, Point3D pt1, Point3D pt2, Point3D pt3, Point3D pt4) {
        GenerationUtils.startBrush();
        GenerationUtils.writeFace(pt1, pt2, pt3);
        GenerationUtils.writeFace(pt1, new Point3D(x, pt1.y, pt1.z), pt2);
        GenerationUtils.writeFace(pt2, new Point3D(x, pt2.y, pt2.z), pt3);
        GenerationUtils.writeFace(pt3, new Point3D(x, pt3.y, pt3.z), pt4);
        GenerationUtils.writeFace(pt4, new Point3D(x, pt4.y, pt4.z), pt1);
        GenerationUtils.writeFace(new Point3D(x, pt3.y, pt3.z), new Point3D(x, pt2.y, pt2.z), new Point3D(x, pt1.y, pt1.z));
        GenerationUtils.endBrush();
    }

    static void writeBrushExtendY(int y, Point3D pt1, Point3D pt2, Point3D pt3, boolean extrude) {
        if (extrude) {
            pt1 = new Point3D(Math.round(pt1.x), Math.round(pt1.y), Math.round(pt1.z));
            pt2 = new Point3D(Math.round(pt2.x), Math.round(pt2.y), Math.round(pt2.z));
            pt3 = new Point3D(Math.round(pt3.x), Math.round(pt3.y), Math.round(pt3.z));
            Point3D newPt1 = new Point3D(pt1.x + (pt1.x - pt2.x) + (pt1.x - pt3.x), pt1.y + (pt1.y - pt2.y) + (pt1.y - pt3.y), pt1.z + (pt1.z - pt2.z) + (pt1.z - pt3.z));
            Point3D newPt2 = new Point3D(pt2.x + (pt2.x - pt1.x) + (pt2.x - pt3.x), pt2.y + (pt2.y - pt1.y) + (pt2.y - pt3.y), pt2.z + (pt2.z - pt1.z) + (pt2.z - pt3.z));
            Point3D newPt3 = new Point3D(pt3.x + (pt3.x - pt1.x) + (pt3.x - pt2.x), pt3.y + (pt3.y - pt1.y) + (pt3.y - pt2.y), pt3.z + (pt3.z - pt1.z) + (pt3.z - pt2.z));
            pt1 = newPt1;
            pt2 = newPt2;
            pt3 = newPt3;
        }
        GenerationUtils.startBrush();
        GenerationUtils.writeFace(pt1, pt2, pt3);
        GenerationUtils.writeFace(pt1, new Point3D(pt1.x, y, pt1.z), pt2);
        GenerationUtils.writeFace(pt2, new Point3D(pt2.x, y, pt2.z), pt3);
        GenerationUtils.writeFace(pt3, new Point3D(pt3.x, y, pt3.z), pt1);
        GenerationUtils.writeFace(new Point3D(pt3.x, y, pt3.z), new Point3D(pt2.x, y, pt2.z), new Point3D(pt1.x, y, pt1.z));
        GenerationUtils.endBrush();
    }

    static void writeBrushExtendY(int y, Point3D pt1, Point3D pt2, Point3D pt3, Point3D pt4) {
        GenerationUtils.startBrush();
        GenerationUtils.writeFace(pt1, pt2, pt3);
        GenerationUtils.writeFace(pt1, new Point3D(pt1.x, y, pt1.z), pt2);
        GenerationUtils.writeFace(pt2, new Point3D(pt2.x, y, pt2.z), pt3);
        GenerationUtils.writeFace(pt3, new Point3D(pt3.x, y, pt3.z), pt4);
        GenerationUtils.writeFace(pt4, new Point3D(pt4.x, y, pt4.z), pt1);
        GenerationUtils.writeFace(new Point3D(pt3.x, y, pt3.z), new Point3D(pt2.x, y, pt2.z), new Point3D(pt1.x, y, pt1.z));
        GenerationUtils.endBrush();
    }

    static void writeBrushExtendZ(int z, Point3D pt1, Point3D pt2, Point3D pt3, boolean extrude) {
        if (extrude) {
            pt1 = new Point3D(Math.round(pt1.x), Math.round(pt1.y), Math.round(pt1.z));
            pt2 = new Point3D(Math.round(pt2.x), Math.round(pt2.y), Math.round(pt2.z));
            pt3 = new Point3D(Math.round(pt3.x), Math.round(pt3.y), Math.round(pt3.z));
            Point3D newPt1 = new Point3D(pt1.x + (pt1.x - pt2.x) + (pt1.x - pt3.x), pt1.y + (pt1.y - pt2.y) + (pt1.y - pt3.y), pt1.z + (pt1.z - pt2.z) + (pt1.z - pt3.z));
            Point3D newPt2 = new Point3D(pt2.x + (pt2.x - pt1.x) + (pt2.x - pt3.x), pt2.y + (pt2.y - pt1.y) + (pt2.y - pt3.y), pt2.z + (pt2.z - pt1.z) + (pt2.z - pt3.z));
            Point3D newPt3 = new Point3D(pt3.x + (pt3.x - pt1.x) + (pt3.x - pt2.x), pt3.y + (pt3.y - pt1.y) + (pt3.y - pt2.y), pt3.z + (pt3.z - pt1.z) + (pt3.z - pt2.z));
            pt1 = newPt1;
            pt2 = newPt2;
            pt3 = newPt3;
        }
        GenerationUtils.startBrush();
        GenerationUtils.writeFace(pt1, pt2, pt3);
        GenerationUtils.writeFace(pt1, new Point3D(pt1.x, pt1.y, z), pt2);
        GenerationUtils.writeFace(pt2, new Point3D(pt2.x, pt2.y, z), pt3);
        GenerationUtils.writeFace(pt3, new Point3D(pt3.x, pt3.y, z), pt1);
        GenerationUtils.writeFace(new Point3D(pt3.x, pt3.y, z), new Point3D(pt2.x, pt2.y, z), new Point3D(pt1.x, pt1.y, z));
        GenerationUtils.endBrush();
    }

    static void writeBrushExtendZ(int z, Point3D pt1, Point3D pt2, Point3D pt3, Point3D pt4) {
        GenerationUtils.startBrush();
        GenerationUtils.writeFace(pt1, pt2, pt3);
        GenerationUtils.writeFace(pt1, new Point3D(pt1.x, pt1.y, z), pt2);
        GenerationUtils.writeFace(pt2, new Point3D(pt2.x, pt2.y, z), pt3);
        GenerationUtils.writeFace(pt3, new Point3D(pt3.x, pt3.y, z), pt4);
        GenerationUtils.writeFace(pt4, new Point3D(pt4.x, pt4.y, z), pt1);
        GenerationUtils.writeFace(new Point3D(pt3.x, pt3.y, z), new Point3D(pt2.x, pt2.y, z), new Point3D(pt1.x, pt1.y, z));
        GenerationUtils.endBrush();
    }

    static void writeWedge(Point3D topTri1, Point3D topTri2, Point3D topTri3, Point3D bottomTri1, Point3D bottomTri2, Point3D bottomTri3) {
        GenerationUtils.startBrush();
        GenerationUtils.writeFace(topTri1, topTri2, topTri3);
        GenerationUtils.writeFace(bottomTri3, bottomTri2, bottomTri1);
        GenerationUtils.writeFace(topTri2, topTri1, bottomTri1);
        GenerationUtils.writeFace(topTri3, topTri2, bottomTri2);
        GenerationUtils.writeFace(topTri1, topTri3, bottomTri3);
        GenerationUtils.endBrush();
    }

    static boolean equals(Point3D pt1, Point3D pt2) {
        return Math.round(pt1.x) == Math.round(pt2.x) && Math.round(pt1.y) == Math.round(pt2.y) && Math.round(pt1.z) == Math.round(pt2.z);
    }
}

