/*
 * Decompiled with CFR 0.152.
 */
package main;

import generators.DiscGenerator;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import main.Config;
import tools.MapFactory;

public class DiscGeneratorGUI
extends JFrame {
    private Config configuration;
    private Color shaded = new Color(200, 200, 200);
    private Color normal = this.getBackground();
    private String radiusTitle = "Radius";
    private String radiusDescription = "The radius of the disc.";
    private String facesTitle = "Faces";
    private String facesDescription = "The number of faces along the circumference on this half-disc. The number of faces on a full disc would be twice this number. If the disc is to be chopped into a quarter disc, you should probably use an even number of faces there.";
    private String heightTitle = "Height";
    private String heightDescription = "How tall the profile of the disc is.";
    private String offsetAngleTitle = "Extrude Radius Factor";
    private String offsetAngleDescription = "The angle, in degrees, by which to rotate the disc counter-clockwise.";
    private String adjustForOverlappingCylinderCutsTitle = "Adjust For Overlapping Cylinder Cuts";
    private String adjustForOverlappingCylinderCutsDescription = "This flag only has an effect if faces is even. If that is the case, use this flag to generate a disc that will align perfectly with a cylinder that was generated with the Cylinder Generator using adjustForOverlappingCylinderCuts.";
    private JCheckBox adjustForOverlappingCylinderCuts;
    private JPanel adjustForOverlappingCylinderCutsPanel;
    private JTextArea description;
    private JPanel descriptionPanel;
    private JScrollPane descriptionScrollPane;
    private JLabel descriptionTitle;
    private JPanel facesPanel;
    private JButton generate;
    private JPanel heightPanel;
    private JLabel icon;
    private JPanel iconPanel;
    private JTextField inFaces;
    private JTextField inHeight;
    private JTextField inOffsetAngle;
    private JTextField inRadius;
    private JLabel labFaces;
    private JLabel labHeight;
    private JLabel labOffsetAngle;
    private JLabel labRadius;
    private JPanel offsetAnglePanel;
    private ButtonGroup options;
    private JPanel radiusPanel;
    private JTextArea status;
    private JPanel statusPanel;
    private JScrollPane statusScrollPane;
    private JLabel subtitle;
    private JPanel subtitlePanel;
    private JPanel valuesPanel;

    public DiscGeneratorGUI(Config configuration) {
        this.initComponents();
        this.configuration = configuration;
    }

    private void initComponents() {
        this.options = new ButtonGroup();
        this.valuesPanel = new JPanel();
        this.radiusPanel = new JPanel();
        this.labRadius = new JLabel();
        this.inRadius = new JTextField();
        this.facesPanel = new JPanel();
        this.labFaces = new JLabel();
        this.inFaces = new JTextField();
        this.heightPanel = new JPanel();
        this.labHeight = new JLabel();
        this.inHeight = new JTextField();
        this.offsetAnglePanel = new JPanel();
        this.labOffsetAngle = new JLabel();
        this.inOffsetAngle = new JTextField();
        this.adjustForOverlappingCylinderCutsPanel = new JPanel();
        this.adjustForOverlappingCylinderCuts = new JCheckBox();
        this.subtitlePanel = new JPanel();
        this.subtitle = new JLabel();
        this.descriptionPanel = new JPanel();
        this.descriptionScrollPane = new JScrollPane();
        this.description = new JTextArea();
        this.descriptionTitle = new JLabel();
        this.statusPanel = new JPanel();
        this.generate = new JButton();
        this.statusScrollPane = new JScrollPane();
        this.status = new JTextArea();
        this.iconPanel = new JPanel();
        this.icon = new JLabel();
        this.setTitle("Disc Generator");
        this.setLocationByPlatform(true);
        this.radiusPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DiscGeneratorGUI.this.radiusPanelFocusGained(evt);
            }
        });
        this.labRadius.setLabelFor(this.inRadius);
        this.labRadius.setText("radius:");
        this.inRadius.setText("512");
        this.inRadius.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DiscGeneratorGUI.this.inRadiusFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                DiscGeneratorGUI.this.inRadiusFocusLost(evt);
            }
        });
        GroupLayout radiusPanelLayout = new GroupLayout(this.radiusPanel);
        this.radiusPanel.setLayout(radiusPanelLayout);
        radiusPanelLayout.setHorizontalGroup(radiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(radiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labRadius).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inRadius, -2, 64, -2).addContainerGap()));
        radiusPanelLayout.setVerticalGroup(radiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, radiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(radiusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labRadius).addComponent(this.inRadius, -2, -1, -2)).addContainerGap()));
        this.labFaces.setLabelFor(this.inFaces);
        this.labFaces.setText("faces:");
        this.inFaces.setText("48");
        this.inFaces.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DiscGeneratorGUI.this.inFacesFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                DiscGeneratorGUI.this.inFacesFocusLost(evt);
            }
        });
        GroupLayout facesPanelLayout = new GroupLayout(this.facesPanel);
        this.facesPanel.setLayout(facesPanelLayout);
        facesPanelLayout.setHorizontalGroup(facesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(facesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labFaces).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inFaces, -2, 64, -2).addContainerGap()));
        facesPanelLayout.setVerticalGroup(facesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, facesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(facesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labFaces).addComponent(this.inFaces, -2, -1, -2)).addContainerGap()));
        this.labHeight.setLabelFor(this.inHeight);
        this.labHeight.setText("height:");
        this.inHeight.setText("64");
        this.inHeight.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DiscGeneratorGUI.this.inHeightFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                DiscGeneratorGUI.this.inHeightFocusLost(evt);
            }
        });
        GroupLayout heightPanelLayout = new GroupLayout(this.heightPanel);
        this.heightPanel.setLayout(heightPanelLayout);
        heightPanelLayout.setHorizontalGroup(heightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(heightPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labHeight).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inHeight, -2, 64, -2).addContainerGap()));
        heightPanelLayout.setVerticalGroup(heightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(heightPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(heightPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labHeight).addComponent(this.inHeight, -2, -1, -2))));
        this.labOffsetAngle.setLabelFor(this.inOffsetAngle);
        this.labOffsetAngle.setText("offsetAngle:");
        this.inOffsetAngle.setText("0.0");
        this.inOffsetAngle.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DiscGeneratorGUI.this.inOffsetAngleFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                DiscGeneratorGUI.this.inOffsetAngleFocusLost(evt);
            }
        });
        GroupLayout offsetAnglePanelLayout = new GroupLayout(this.offsetAnglePanel);
        this.offsetAnglePanel.setLayout(offsetAnglePanelLayout);
        offsetAnglePanelLayout.setHorizontalGroup(offsetAnglePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(offsetAnglePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labOffsetAngle).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inOffsetAngle, -2, 64, -2).addContainerGap()));
        offsetAnglePanelLayout.setVerticalGroup(offsetAnglePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, offsetAnglePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(offsetAnglePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labOffsetAngle).addComponent(this.inOffsetAngle, -2, -1, -2)).addContainerGap()));
        this.adjustForOverlappingCylinderCuts.setText("adjustForOverlappingCylinderCuts");
        this.adjustForOverlappingCylinderCuts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiscGeneratorGUI.this.adjustForOverlappingCylinderCutsActionPerformed(evt);
            }
        });
        this.adjustForOverlappingCylinderCuts.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                DiscGeneratorGUI.this.adjustForOverlappingCylinderCutsFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                DiscGeneratorGUI.this.adjustForOverlappingCylinderCutsFocusLost(evt);
            }
        });
        GroupLayout adjustForOverlappingCylinderCutsPanelLayout = new GroupLayout(this.adjustForOverlappingCylinderCutsPanel);
        this.adjustForOverlappingCylinderCutsPanel.setLayout(adjustForOverlappingCylinderCutsPanelLayout);
        adjustForOverlappingCylinderCutsPanelLayout.setHorizontalGroup(adjustForOverlappingCylinderCutsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, adjustForOverlappingCylinderCutsPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.adjustForOverlappingCylinderCuts).addContainerGap()));
        adjustForOverlappingCylinderCutsPanelLayout.setVerticalGroup(adjustForOverlappingCylinderCutsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, adjustForOverlappingCylinderCutsPanelLayout.createSequentialGroup().addGap(0, 10, Short.MAX_VALUE).addComponent(this.adjustForOverlappingCylinderCuts, -2, 23, -2)));
        GroupLayout valuesPanelLayout = new GroupLayout(this.valuesPanel);
        this.valuesPanel.setLayout(valuesPanelLayout);
        valuesPanelLayout.setHorizontalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.adjustForOverlappingCylinderCutsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.radiusPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.facesPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.heightPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.offsetAnglePanel, -1, -1, Short.MAX_VALUE))));
        valuesPanelLayout.setVerticalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.radiusPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.facesPanel, -2, 32, -2).addGap(18, 18, 18).addComponent(this.heightPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.adjustForOverlappingCylinderCutsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.offsetAnglePanel, -2, 33, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.subtitle.setHorizontalAlignment(0);
        this.subtitle.setText("Generates the top half of a disc as a .map file to be opened in GtkRadiant.");
        GroupLayout subtitlePanelLayout = new GroupLayout(this.subtitlePanel);
        this.subtitlePanel.setLayout(subtitlePanelLayout);
        subtitlePanelLayout.setHorizontalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subtitlePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.subtitle, -2, 551, -2).addContainerGap(-1, Short.MAX_VALUE)));
        subtitlePanelLayout.setVerticalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.subtitle, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.description.setEditable(false);
        this.description.setColumns(20);
        this.description.setLineWrap(true);
        this.description.setRows(5);
        this.description.setWrapStyleWord(true);
        this.description.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.description.setFocusable(false);
        this.description.setMargin(new Insets(5, 5, 5, 5));
        this.descriptionScrollPane.setViewportView(this.description);
        this.descriptionTitle.setHorizontalAlignment(0);
        GroupLayout descriptionPanelLayout = new GroupLayout(this.descriptionPanel);
        this.descriptionPanel.setLayout(descriptionPanelLayout);
        descriptionPanelLayout.setHorizontalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap().addGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.descriptionTitle, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(descriptionPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.descriptionScrollPane, -2, 297, -2))).addContainerGap()));
        descriptionPanelLayout.setVerticalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.descriptionTitle, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.descriptionScrollPane, -1, 258, Short.MAX_VALUE).addContainerGap()));
        this.generate.setText("Generate");
        this.generate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DiscGeneratorGUI.this.generateActionPerformed(evt);
            }
        });
        this.status.setEditable(false);
        this.status.setColumns(20);
        this.status.setRows(5);
        this.status.setFocusable(false);
        this.statusScrollPane.setViewportView(this.status);
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusScrollPane, -1, 481, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.generate).addGap(18, 18, 18)));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addGap(26, 26, 26).addComponent(this.generate).addContainerGap(21, Short.MAX_VALUE)).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusScrollPane, -2, 0, Short.MAX_VALUE).addContainerGap()));
        this.icon.setHorizontalAlignment(0);
        this.icon.setIcon(new ImageIcon(this.getClass().getResource("/main/disc.png")));
        this.icon.setFocusable(false);
        GroupLayout iconPanelLayout = new GroupLayout(this.iconPanel);
        this.iconPanel.setLayout(iconPanelLayout);
        iconPanelLayout.setHorizontalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, iconPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.icon, -2, 252, -2).addGap(1, 1, 1)));
        iconPanelLayout.setVerticalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(iconPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.icon, -2, 196, -2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.subtitlePanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusPanel, -2, -1, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.valuesPanel, -2, -1, -2).addComponent(this.iconPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionPanel, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.subtitlePanel, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.iconPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.valuesPanel, -2, -1, -2)).addComponent(this.descriptionPanel, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.statusPanel, -2, -1, -2)));
        this.pack();
    }

    private void inRadiusFocusGained(FocusEvent evt) {
        this.radiusPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.radiusTitle);
        this.description.setText(this.radiusDescription);
    }

    private void inRadiusFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void radiusPanelFocusGained(FocusEvent evt) {
    }

    private void inFacesFocusGained(FocusEvent evt) {
        this.facesPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.facesTitle);
        this.description.setText(this.facesDescription);
    }

    private void inFacesFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inHeightFocusGained(FocusEvent evt) {
        this.heightPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.heightTitle);
        this.description.setText(this.heightDescription);
    }

    private void inHeightFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void adjustForOverlappingCylinderCutsFocusGained(FocusEvent evt) {
        this.adjustForOverlappingCylinderCutsPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.adjustForOverlappingCylinderCutsTitle);
        this.description.setText(this.adjustForOverlappingCylinderCutsDescription);
    }

    private void adjustForOverlappingCylinderCutsFocusLost(FocusEvent evt) {
        this.adjustForOverlappingCylinderCutsPanel.setBackground(this.normal);
    }

    private void inOffsetAngleFocusGained(FocusEvent evt) {
        this.offsetAnglePanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.offsetAngleTitle);
        this.description.setText(this.offsetAngleDescription);
    }

    private void inOffsetAngleFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void generateActionPerformed(ActionEvent evt) {
        this.generate.setEnabled(false);
        String[] args = new String[]{this.inRadius.getText(), this.inFaces.getText(), this.inHeight.getText(), Boolean.toString(this.adjustForOverlappingCylinderCuts.isSelected()), this.inOffsetAngle.getText()};
        this.status.setText("Generating disc...");
        DiscGenerator.main(args);
        this.status.setText("Generated - select save file name and location");
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Quake Map File (.map)", "map");
        chooser.setFileFilter(filter);
        File saveFile = null;
        String filename = null;
        boolean save = true;
        while (save) {
            int returnValue;
            if (this.configuration.getWorkingDirectory() != null && this.configuration.getWorkingDirectory().isDirectory()) {
                chooser.setCurrentDirectory(this.configuration.getWorkingDirectory());
            }
            if ((returnValue = chooser.showSaveDialog(this)) == 1 || returnValue == -1) {
                save = false;
            } else {
                saveFile = chooser.getSelectedFile();
                filename = saveFile.getAbsolutePath();
                if (!filename.endsWith(".map")) {
                    filename = filename + ".map";
                }
                if ((saveFile = new File(filename)).exists()) {
                    Object[] buttons = new Object[]{"Cancel", "No", "Yes"};
                    int response = JOptionPane.showOptionDialog(this, "Overwrite " + filename + " ?", "Confirm Overwrite", 2, 0, null, buttons, buttons[1]);
                    if (response == 1) continue;
                    if (response == 0) {
                        save = false;
                    }
                }
            }
            if (save) {
                this.status.setText("Saving...");
                MapFactory.saveText(filename);
                this.statusPanel.setBackground(Color.green);
                this.status.setText("Save successful\n" + filename);
                this.configuration.setWorkingDirectory(saveFile.getParentFile());
                save = false;
                continue;
            }
            this.status.setText("Save Cancelled");
        }
    }

    private void adjustForOverlappingCylinderCutsActionPerformed(ActionEvent evt) {
    }

    private void checkGenerateOK() {
        int temp;
        boolean generateOK = true;
        this.statusPanel.setBackground(this.normal);
        this.status.setText("");
        String statusText = "";
        try {
            temp = Integer.parseInt(this.inRadius.getText());
            if (temp <= 1) {
                throw new Exception("radius must be at least 1");
            }
            this.radiusPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.radiusPanel.setBackground(Color.red);
        }
        try {
            temp = Integer.parseInt(this.inFaces.getText());
            if (temp < 1) {
                throw new Exception("Min faces is 1");
            }
            this.facesPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.facesPanel.setBackground(Color.red);
        }
        try {
            int temp2 = Integer.parseInt(this.inHeight.getText());
            if (temp2 <= 1) {
                throw new Exception("Min height is 1");
            }
            this.heightPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.heightPanel.setBackground(Color.red);
        }
        try {
            double temp3 = Double.parseDouble(this.inOffsetAngle.getText());
            if (temp3 < 0.0) {
                throw new Exception("Please enter a positive number");
            }
            this.offsetAnglePanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.offsetAnglePanel.setBackground(Color.red);
        }
        if (generateOK) {
            this.generate.setEnabled(true);
        } else {
            this.generate.setEnabled(false);
            this.statusPanel.setBackground(Color.yellow);
            this.status.setText(statusText);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(DiscGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(DiscGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(DiscGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(DiscGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DiscGeneratorGUI(new Config()).setVisible(true);
            }
        });
    }
}

