/*
 * Decompiled with CFR 0.152.
 */
package generators;

import com.nerius.math.geom.Point3D;
import com.nerius.math.xform.AxisRotation3D;
import generators.GenerationUtils;

public final class CorkscrewShinglesGenerator
extends GenerationUtils {
    public static void main(String[] args) {
        Thread.currentThread().setPriority(1);
        int innerRadius = Integer.parseInt(args[0]);
        int altitude = Integer.parseInt(args[1]);
        int lip = Integer.parseInt(args[2]);
        int slices = Integer.parseInt(args[3]);
        int innerThickness = Integer.parseInt(args[4]);
        boolean adjustForOverlappingCylinderCuts = Boolean.valueOf(args[5]);
        int shinglesType = Integer.parseInt(args[6]);
        Point3D[][] mesh = new Point3D[slices + 1][2];
        Point3D[] innerCurve = CorkscrewShinglesGenerator.generatePipeCurve(innerRadius, slices, 0, 0.0, adjustForOverlappingCylinderCuts ? 1 : 0);
        AxisRotation3D rot = new AxisRotation3D(1, 1.5707963267948966);
        for (int i = 0; i <= slices; ++i) {
            innerCurve[i] = rot.transform(innerCurve[i]);
        }
        double stepsPerSlice = (double)altitude / (double)slices;
        for (int i = 0; i <= slices; ++i) {
            mesh[i][0] = new Point3D(innerCurve[i].x, innerCurve[i].y, innerCurve[i].z + (double)i * stepsPerSlice - (double)lip);
            mesh[i][1] = new Point3D(innerCurve[i].x, innerCurve[i].y, innerCurve[i].z + (double)i * stepsPerSlice - (double)(innerThickness + lip));
        }
        CorkscrewShinglesGenerator.startMap();
        for (int i = 0; i < slices; ++i) {
            Point3D ptOffsetLow;
            Point3D ptOffsetHigh;
            if (shinglesType == 1 || shinglesType == 2) {
                if (mesh[i][0].y >= mesh[i + 1][0].y) continue;
                ptOffsetHigh = new Point3D(mesh[i + 1][0].x - 1.0, mesh[i + 1][0].y, mesh[i + 1][0].z);
                ptOffsetLow = new Point3D(mesh[i + 1][1].x - 1.0, mesh[i + 1][1].y, mesh[i + 1][1].z);
            } else if (i < slices / 2) {
                ptOffsetHigh = new Point3D(mesh[i + 1][0].x - 1.0, mesh[i + 1][0].y, mesh[i + 1][0].z);
                ptOffsetLow = new Point3D(mesh[i + 1][1].x - 1.0, mesh[i + 1][1].y, mesh[i + 1][1].z);
            } else {
                ptOffsetHigh = new Point3D(mesh[i + 1][0].x, mesh[i + 1][0].y - 1.0, mesh[i + 1][0].z);
                ptOffsetLow = new Point3D(mesh[i + 1][1].x, mesh[i + 1][1].y - 1.0, mesh[i + 1][1].z);
            }
            CorkscrewShinglesGenerator.startBrush();
            CorkscrewShinglesGenerator.writeFace(mesh[i][0], mesh[i + 1][0], mesh[i + 1][1]);
            if (i == 0 && shinglesType == 1) {
                Point3D ptTemp = new Point3D(mesh[i][0].x - 1.0, mesh[i][0].y, mesh[i][0].z);
                CorkscrewShinglesGenerator.writeFace(ptTemp, mesh[i][0], mesh[i][1]);
                CorkscrewShinglesGenerator.writeFace(ptOffsetLow, ptOffsetHigh, ptTemp);
            } else {
                CorkscrewShinglesGenerator.writeFace(mesh[i][0], mesh[i][1], ptOffsetLow);
            }
            CorkscrewShinglesGenerator.writeFace(mesh[i + 1][1], mesh[i + 1][0], ptOffsetHigh);
            CorkscrewShinglesGenerator.writeFace(ptOffsetHigh, mesh[i + 1][0], mesh[i][0]);
            CorkscrewShinglesGenerator.writeFace(mesh[i][1], mesh[i + 1][1], ptOffsetLow);
            CorkscrewShinglesGenerator.endBrush();
        }
        CorkscrewShinglesGenerator.endMap();
    }
}

