/*
 * Decompiled with CFR 0.152.
 */
package main;

import generators.SineWaveGenerator;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import main.Config;
import tools.MapFactory;

public class SineWaveGeneratorGUI
extends JFrame {
    private Config configuration;
    private Color shaded = new Color(200, 200, 200);
    private Color normal = this.getBackground();
    private JTextArea description;
    private JPanel descriptionPanel;
    private JScrollPane descriptionScrollPane;
    private JLabel descriptionTitle;
    private JButton generate;
    private JLabel icon;
    private JPanel iconPanel;
    private JTextField inLeftAmplitude;
    private JTextField inLeftHeight;
    private JTextField inLeftPhase;
    private JTextField inLeftWavelength;
    private JTextField inRightAmplitude;
    private JTextField inRightHeight;
    private JTextField inRightPhase;
    private JTextField inRightWavelength;
    private JTextField inSlicesLength;
    private JTextField inSlicesWidth;
    private JTextField inSurfaceLength;
    private JTextField inSurfaceWidth;
    private JLabel labLeftAmplitude;
    private JLabel labLeftHeight;
    private JLabel labLeftWavelength;
    private JLabel labRightAmplitude;
    private JLabel labRightHeight;
    private JLabel labRightPhase;
    private JLabel labRightWavelength;
    private JLabel labSlicesLength;
    private JLabel labSlicesWidth;
    private JLabel labSurfaceLength;
    private JLabel labSurfaceWidth;
    private JLabel lableftPhase;
    private JPanel leftAmplitudePanel;
    private JPanel leftHeightPanel;
    private JPanel leftPhasePanel;
    private JPanel leftWavelengthPanel;
    private ButtonGroup options;
    private JPanel rightAmplitudePanel;
    private JPanel rightHeightPanel;
    private JPanel rightPhasePanel;
    private JPanel rightWavelengthPanel;
    private JPanel slicesLengthPanel;
    private JPanel slicesWidthPanel;
    private JTextArea status;
    private JPanel statusPanel;
    private JScrollPane statusScrollPane;
    private JLabel subtitle;
    private JPanel subtitlePanel;
    private JPanel surfaceLengthPanel;
    private JPanel surfaceWidthPanel;
    private JPanel valuesPanel;

    public SineWaveGeneratorGUI(Config configuration) {
        this.initComponents();
        this.configuration = configuration;
    }

    private void initComponents() {
        this.options = new ButtonGroup();
        this.valuesPanel = new JPanel();
        this.surfaceLengthPanel = new JPanel();
        this.labSurfaceLength = new JLabel();
        this.inSurfaceLength = new JTextField();
        this.leftAmplitudePanel = new JPanel();
        this.labLeftAmplitude = new JLabel();
        this.inLeftAmplitude = new JTextField();
        this.slicesLengthPanel = new JPanel();
        this.labSlicesLength = new JLabel();
        this.inSlicesLength = new JTextField();
        this.leftHeightPanel = new JPanel();
        this.labLeftHeight = new JLabel();
        this.inLeftHeight = new JTextField();
        this.leftPhasePanel = new JPanel();
        this.lableftPhase = new JLabel();
        this.inLeftPhase = new JTextField();
        this.leftWavelengthPanel = new JPanel();
        this.labLeftWavelength = new JLabel();
        this.inLeftWavelength = new JTextField();
        this.surfaceWidthPanel = new JPanel();
        this.labSurfaceWidth = new JLabel();
        this.inSurfaceWidth = new JTextField();
        this.rightHeightPanel = new JPanel();
        this.inRightHeight = new JTextField();
        this.labRightHeight = new JLabel();
        this.rightAmplitudePanel = new JPanel();
        this.inRightAmplitude = new JTextField();
        this.labRightAmplitude = new JLabel();
        this.rightWavelengthPanel = new JPanel();
        this.labRightWavelength = new JLabel();
        this.inRightWavelength = new JTextField();
        this.slicesWidthPanel = new JPanel();
        this.labSlicesWidth = new JLabel();
        this.inSlicesWidth = new JTextField();
        this.rightPhasePanel = new JPanel();
        this.labRightPhase = new JLabel();
        this.inRightPhase = new JTextField();
        this.subtitlePanel = new JPanel();
        this.subtitle = new JLabel();
        this.descriptionPanel = new JPanel();
        this.descriptionScrollPane = new JScrollPane();
        this.description = new JTextArea();
        this.descriptionTitle = new JLabel();
        this.statusPanel = new JPanel();
        this.generate = new JButton();
        this.statusScrollPane = new JScrollPane();
        this.status = new JTextArea();
        this.iconPanel = new JPanel();
        this.icon = new JLabel();
        this.setTitle("Sine Wave Generator");
        this.setLocationByPlatform(true);
        this.surfaceLengthPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SineWaveGeneratorGUI.this.surfaceLengthPanelFocusGained(evt);
            }
        });
        this.labSurfaceLength.setLabelFor(this.inSurfaceLength);
        this.labSurfaceLength.setText("surfaceLength:");
        this.inSurfaceLength.setText("4096");
        this.inSurfaceLength.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SineWaveGeneratorGUI.this.inSurfaceLengthActionPerformed(evt);
            }
        });
        this.inSurfaceLength.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inSurfaceLengthFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inSurfaceLengthFocusLost(evt);
            }
        });
        GroupLayout surfaceLengthPanelLayout = new GroupLayout(this.surfaceLengthPanel);
        this.surfaceLengthPanel.setLayout(surfaceLengthPanelLayout);
        surfaceLengthPanelLayout.setHorizontalGroup(surfaceLengthPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(surfaceLengthPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labSurfaceLength).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inSurfaceLength, -2, 64, -2).addContainerGap()));
        surfaceLengthPanelLayout.setVerticalGroup(surfaceLengthPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, surfaceLengthPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(surfaceLengthPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labSurfaceLength).addComponent(this.inSurfaceLength, -2, -1, -2)).addContainerGap()));
        this.labLeftAmplitude.setLabelFor(this.inLeftAmplitude);
        this.labLeftAmplitude.setText("leftAmplitude:");
        this.inLeftAmplitude.setText("384");
        this.inLeftAmplitude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SineWaveGeneratorGUI.this.inLeftAmplitudeActionPerformed(evt);
            }
        });
        this.inLeftAmplitude.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inLeftAmplitudeFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inLeftAmplitudeFocusLost(evt);
            }
        });
        GroupLayout leftAmplitudePanelLayout = new GroupLayout(this.leftAmplitudePanel);
        this.leftAmplitudePanel.setLayout(leftAmplitudePanelLayout);
        leftAmplitudePanelLayout.setHorizontalGroup(leftAmplitudePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(leftAmplitudePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labLeftAmplitude).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inLeftAmplitude, -2, 64, -2).addContainerGap()));
        leftAmplitudePanelLayout.setVerticalGroup(leftAmplitudePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, leftAmplitudePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(leftAmplitudePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labLeftAmplitude).addComponent(this.inLeftAmplitude, -2, -1, -2)).addContainerGap()));
        this.labSlicesLength.setLabelFor(this.inSlicesLength);
        this.labSlicesLength.setText("slicesLength:");
        this.inSlicesLength.setText("96");
        this.inSlicesLength.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SineWaveGeneratorGUI.this.inSlicesLengthActionPerformed(evt);
            }
        });
        this.inSlicesLength.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inSlicesLengthFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inSlicesLengthFocusLost(evt);
            }
        });
        GroupLayout slicesLengthPanelLayout = new GroupLayout(this.slicesLengthPanel);
        this.slicesLengthPanel.setLayout(slicesLengthPanelLayout);
        slicesLengthPanelLayout.setHorizontalGroup(slicesLengthPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(slicesLengthPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labSlicesLength).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inSlicesLength, -2, 64, -2).addContainerGap()));
        slicesLengthPanelLayout.setVerticalGroup(slicesLengthPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, slicesLengthPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(slicesLengthPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labSlicesLength).addComponent(this.inSlicesLength, -2, -1, -2)).addContainerGap()));
        this.labLeftHeight.setLabelFor(this.inLeftHeight);
        this.labLeftHeight.setText("leftHeight:");
        this.inLeftHeight.setText("512");
        this.inLeftHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SineWaveGeneratorGUI.this.inLeftHeightActionPerformed(evt);
            }
        });
        this.inLeftHeight.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inLeftHeightFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inLeftHeightFocusLost(evt);
            }
        });
        GroupLayout leftHeightPanelLayout = new GroupLayout(this.leftHeightPanel);
        this.leftHeightPanel.setLayout(leftHeightPanelLayout);
        leftHeightPanelLayout.setHorizontalGroup(leftHeightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(leftHeightPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labLeftHeight).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inLeftHeight, -2, 64, -2).addContainerGap()));
        leftHeightPanelLayout.setVerticalGroup(leftHeightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(leftHeightPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(leftHeightPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labLeftHeight).addComponent(this.inLeftHeight, -2, -1, -2))));
        this.lableftPhase.setLabelFor(this.inLeftAmplitude);
        this.lableftPhase.setText("leftPhase:");
        this.inLeftPhase.setText("-0.25");
        this.inLeftPhase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SineWaveGeneratorGUI.this.inLeftPhaseActionPerformed(evt);
            }
        });
        this.inLeftPhase.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inLeftPhaseFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inLeftPhaseFocusLost(evt);
            }
        });
        GroupLayout leftPhasePanelLayout = new GroupLayout(this.leftPhasePanel);
        this.leftPhasePanel.setLayout(leftPhasePanelLayout);
        leftPhasePanelLayout.setHorizontalGroup(leftPhasePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(leftPhasePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.lableftPhase).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inLeftPhase, -2, 64, -2).addContainerGap()));
        leftPhasePanelLayout.setVerticalGroup(leftPhasePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, leftPhasePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(leftPhasePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lableftPhase).addComponent(this.inLeftPhase, -2, -1, -2)).addContainerGap()));
        this.labLeftWavelength.setLabelFor(this.inLeftAmplitude);
        this.labLeftWavelength.setText("leftWavelength:");
        this.inLeftWavelength.setText("2048");
        this.inLeftWavelength.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SineWaveGeneratorGUI.this.inLeftWavelengthActionPerformed(evt);
            }
        });
        this.inLeftWavelength.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inLeftWavelengthFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inLeftWavelengthFocusLost(evt);
            }
        });
        GroupLayout leftWavelengthPanelLayout = new GroupLayout(this.leftWavelengthPanel);
        this.leftWavelengthPanel.setLayout(leftWavelengthPanelLayout);
        leftWavelengthPanelLayout.setHorizontalGroup(leftWavelengthPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(leftWavelengthPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labLeftWavelength).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inLeftWavelength, -2, 64, -2).addContainerGap()));
        leftWavelengthPanelLayout.setVerticalGroup(leftWavelengthPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, leftWavelengthPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(leftWavelengthPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labLeftWavelength).addComponent(this.inLeftWavelength, -2, -1, -2)).addContainerGap()));
        this.surfaceWidthPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SineWaveGeneratorGUI.this.surfaceWidthPanelFocusGained(evt);
            }
        });
        this.labSurfaceWidth.setLabelFor(this.inSurfaceLength);
        this.labSurfaceWidth.setText("surfaceWidth:");
        this.inSurfaceWidth.setText("224");
        this.inSurfaceWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SineWaveGeneratorGUI.this.inSurfaceWidthActionPerformed(evt);
            }
        });
        this.inSurfaceWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inSurfaceWidthFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inSurfaceWidthFocusLost(evt);
            }
        });
        GroupLayout surfaceWidthPanelLayout = new GroupLayout(this.surfaceWidthPanel);
        this.surfaceWidthPanel.setLayout(surfaceWidthPanelLayout);
        surfaceWidthPanelLayout.setHorizontalGroup(surfaceWidthPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(surfaceWidthPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labSurfaceWidth).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inSurfaceWidth, -2, 64, -2).addContainerGap()));
        surfaceWidthPanelLayout.setVerticalGroup(surfaceWidthPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, surfaceWidthPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(surfaceWidthPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labSurfaceWidth).addComponent(this.inSurfaceWidth, -2, -1, -2)).addContainerGap()));
        this.inRightHeight.setText("512");
        this.inRightHeight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SineWaveGeneratorGUI.this.inRightHeightActionPerformed(evt);
            }
        });
        this.inRightHeight.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inRightHeightFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inRightHeightFocusLost(evt);
            }
        });
        this.labRightHeight.setLabelFor(this.inLeftAmplitude);
        this.labRightHeight.setText("rightHeight:");
        GroupLayout rightHeightPanelLayout = new GroupLayout(this.rightHeightPanel);
        this.rightHeightPanel.setLayout(rightHeightPanelLayout);
        rightHeightPanelLayout.setHorizontalGroup(rightHeightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, rightHeightPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labRightHeight).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inRightHeight, -2, 64, -2).addContainerGap()));
        rightHeightPanelLayout.setVerticalGroup(rightHeightPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, rightHeightPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(rightHeightPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inRightHeight, -2, -1, -2).addComponent(this.labRightHeight)).addContainerGap()));
        this.inRightAmplitude.setText("384");
        this.inRightAmplitude.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SineWaveGeneratorGUI.this.inRightAmplitudeActionPerformed(evt);
            }
        });
        this.inRightAmplitude.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inRightAmplitudeFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inRightAmplitudeFocusLost(evt);
            }
        });
        this.labRightAmplitude.setLabelFor(this.inLeftAmplitude);
        this.labRightAmplitude.setText("rightAmplitude:");
        GroupLayout rightAmplitudePanelLayout = new GroupLayout(this.rightAmplitudePanel);
        this.rightAmplitudePanel.setLayout(rightAmplitudePanelLayout);
        rightAmplitudePanelLayout.setHorizontalGroup(rightAmplitudePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, rightAmplitudePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labRightAmplitude).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inRightAmplitude, -2, 64, -2).addContainerGap()));
        rightAmplitudePanelLayout.setVerticalGroup(rightAmplitudePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rightAmplitudePanelLayout.createSequentialGroup().addContainerGap().addGroup(rightAmplitudePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inRightAmplitude, -2, -1, -2).addComponent(this.labRightAmplitude)).addContainerGap(-1, Short.MAX_VALUE)));
        this.labRightWavelength.setLabelFor(this.inLeftAmplitude);
        this.labRightWavelength.setText("rightWavelength:");
        this.inRightWavelength.setText("4096");
        this.inRightWavelength.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SineWaveGeneratorGUI.this.inRightWavelengthActionPerformed(evt);
            }
        });
        this.inRightWavelength.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inRightWavelengthFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inRightWavelengthFocusLost(evt);
            }
        });
        GroupLayout rightWavelengthPanelLayout = new GroupLayout(this.rightWavelengthPanel);
        this.rightWavelengthPanel.setLayout(rightWavelengthPanelLayout);
        rightWavelengthPanelLayout.setHorizontalGroup(rightWavelengthPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rightWavelengthPanelLayout.createSequentialGroup().addContainerGap(21, Short.MAX_VALUE).addComponent(this.labRightWavelength).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inRightWavelength, -2, 64, -2).addContainerGap()));
        rightWavelengthPanelLayout.setVerticalGroup(rightWavelengthPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, rightWavelengthPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(rightWavelengthPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labRightWavelength).addComponent(this.inRightWavelength, -2, -1, -2)).addContainerGap()));
        this.slicesWidthPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SineWaveGeneratorGUI.this.slicesWidthPanelFocusGained(evt);
            }
        });
        this.labSlicesWidth.setLabelFor(this.inSurfaceLength);
        this.labSlicesWidth.setText("slicesWidth:");
        this.inSlicesWidth.setText("8");
        this.inSlicesWidth.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SineWaveGeneratorGUI.this.inSlicesWidthActionPerformed(evt);
            }
        });
        this.inSlicesWidth.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inSlicesWidthFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inSlicesWidthFocusLost(evt);
            }
        });
        GroupLayout slicesWidthPanelLayout = new GroupLayout(this.slicesWidthPanel);
        this.slicesWidthPanel.setLayout(slicesWidthPanelLayout);
        slicesWidthPanelLayout.setHorizontalGroup(slicesWidthPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(slicesWidthPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labSlicesWidth).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inSlicesWidth, -2, 64, -2).addContainerGap()));
        slicesWidthPanelLayout.setVerticalGroup(slicesWidthPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, slicesWidthPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(slicesWidthPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labSlicesWidth).addComponent(this.inSlicesWidth, -2, -1, -2)).addContainerGap()));
        this.labRightPhase.setLabelFor(this.inLeftAmplitude);
        this.labRightPhase.setText("rightPhase:");
        this.inRightPhase.setText("-0.25");
        this.inRightPhase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SineWaveGeneratorGUI.this.inRightPhaseActionPerformed(evt);
            }
        });
        this.inRightPhase.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inRightPhaseFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SineWaveGeneratorGUI.this.inRightPhaseFocusLost(evt);
            }
        });
        GroupLayout rightPhasePanelLayout = new GroupLayout(this.rightPhasePanel);
        this.rightPhasePanel.setLayout(rightPhasePanelLayout);
        rightPhasePanelLayout.setHorizontalGroup(rightPhasePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(rightPhasePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labRightPhase).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inRightPhase, -2, 64, -2).addContainerGap()));
        rightPhasePanelLayout.setVerticalGroup(rightPhasePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, rightPhasePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(rightPhasePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labRightPhase).addComponent(this.inRightPhase, -2, -1, -2)).addContainerGap()));
        GroupLayout valuesPanelLayout = new GroupLayout(this.valuesPanel);
        this.valuesPanel.setLayout(valuesPanelLayout);
        valuesPanelLayout.setHorizontalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, valuesPanelLayout.createSequentialGroup().addContainerGap().addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.surfaceLengthPanel, -1, -1, Short.MAX_VALUE).addComponent(this.surfaceWidthPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.slicesLengthPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.slicesWidthPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.leftHeightPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.leftAmplitudePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.leftWavelengthPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.leftPhasePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.rightHeightPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.rightAmplitudePanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.rightWavelengthPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.rightPhasePanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        valuesPanelLayout.setVerticalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.surfaceLengthPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.surfaceWidthPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slicesLengthPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slicesWidthPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.leftHeightPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.leftAmplitudePanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.leftWavelengthPanel, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.leftPhasePanel, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rightHeightPanel, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rightAmplitudePanel, -2, 37, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rightWavelengthPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rightPhasePanel, -2, 32, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.subtitle.setHorizontalAlignment(0);
        this.subtitle.setText("This is, at the moment, undocumented and experimental.");
        GroupLayout subtitlePanelLayout = new GroupLayout(this.subtitlePanel);
        this.subtitlePanel.setLayout(subtitlePanelLayout);
        subtitlePanelLayout.setHorizontalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subtitlePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.subtitle, -1, 578, Short.MAX_VALUE)));
        subtitlePanelLayout.setVerticalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.subtitle, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.description.setEditable(false);
        this.description.setColumns(20);
        this.description.setLineWrap(true);
        this.description.setRows(5);
        this.description.setWrapStyleWord(true);
        this.description.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.description.setFocusable(false);
        this.description.setMargin(new Insets(5, 5, 5, 5));
        this.descriptionScrollPane.setViewportView(this.description);
        this.descriptionTitle.setHorizontalAlignment(0);
        GroupLayout descriptionPanelLayout = new GroupLayout(this.descriptionPanel);
        this.descriptionPanel.setLayout(descriptionPanelLayout);
        descriptionPanelLayout.setHorizontalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.descriptionTitle, -1, -1, Short.MAX_VALUE).addComponent(this.descriptionScrollPane, -1, 297, Short.MAX_VALUE)).addContainerGap()));
        descriptionPanelLayout.setVerticalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.descriptionTitle, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.descriptionScrollPane, -2, 202, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.generate.setText("Generate");
        this.generate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SineWaveGeneratorGUI.this.generateActionPerformed(evt);
            }
        });
        this.status.setEditable(false);
        this.status.setColumns(20);
        this.status.setRows(5);
        this.status.setFocusable(false);
        this.statusScrollPane.setViewportView(this.status);
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusScrollPane, -2, 486, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.generate).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.statusScrollPane, -2, 41, -2).addComponent(this.generate)).addContainerGap(-1, Short.MAX_VALUE)));
        this.icon.setHorizontalAlignment(0);
        this.icon.setIcon(new ImageIcon(this.getClass().getResource("/main/sinewave.png")));
        this.icon.setFocusable(false);
        GroupLayout iconPanelLayout = new GroupLayout(this.iconPanel);
        this.iconPanel.setLayout(iconPanelLayout);
        iconPanelLayout.setHorizontalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(iconPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.icon, -1, -1, Short.MAX_VALUE).addContainerGap()));
        iconPanelLayout.setVerticalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, iconPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.icon, -2, 196, -2)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.subtitlePanel, -2, -1, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.statusPanel, GroupLayout.Alignment.TRAILING, -1, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.valuesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.descriptionPanel, -2, -1, -2).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.iconPanel, -2, -1, -2).addGap(40, 40, 40)))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.subtitlePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.descriptionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.iconPanel, -2, -1, -2)).addComponent(this.valuesPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.statusPanel, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void inSurfaceLengthFocusGained(FocusEvent evt) {
        this.surfaceLengthPanel.setBackground(this.shaded);
    }

    private void inSurfaceLengthFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void surfaceLengthPanelFocusGained(FocusEvent evt) {
    }

    private void inLeftAmplitudeFocusGained(FocusEvent evt) {
        this.leftAmplitudePanel.setBackground(this.shaded);
    }

    private void inLeftAmplitudeFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesLengthFocusGained(FocusEvent evt) {
        this.slicesLengthPanel.setBackground(this.shaded);
    }

    private void inSlicesLengthFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void generateActionPerformed(ActionEvent evt) {
        this.generate.setEnabled(false);
        String[] args = new String[]{this.inSurfaceLength.getText(), this.inSurfaceWidth.getText(), this.inSlicesLength.getText(), this.inSlicesWidth.getText(), this.inLeftHeight.getText(), this.inLeftAmplitude.getText(), this.inLeftWavelength.getText(), this.inLeftPhase.getText(), this.inRightHeight.getText(), this.inRightAmplitude.getText(), this.inRightWavelength.getText(), this.inRightPhase.getText()};
        this.status.setText("Generating sine wave...");
        SineWaveGenerator.main(args);
        this.status.setText("Generated - select save file name and location");
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Quake Map File (.map)", "map");
        chooser.setFileFilter(filter);
        File saveFile = null;
        String filename = null;
        boolean save = true;
        while (save) {
            int returnValue;
            if (this.configuration.getWorkingDirectory() != null && this.configuration.getWorkingDirectory().isDirectory()) {
                chooser.setCurrentDirectory(this.configuration.getWorkingDirectory());
            }
            if ((returnValue = chooser.showSaveDialog(this)) == 1 || returnValue == -1) {
                save = false;
            } else {
                saveFile = chooser.getSelectedFile();
                filename = saveFile.getAbsolutePath();
                if (!filename.endsWith(".map")) {
                    filename = filename + ".map";
                }
                if ((saveFile = new File(filename)).exists()) {
                    Object[] buttons = new Object[]{"Cancel", "No", "Yes"};
                    int response = JOptionPane.showOptionDialog(this, "Overwrite " + filename + " ?", "Confirm Overwrite", 2, 0, null, buttons, buttons[1]);
                    if (response == 1) continue;
                    if (response == 0) {
                        save = false;
                    }
                }
            }
            if (save) {
                this.status.setText("Saving...");
                MapFactory.saveText(filename);
                this.statusPanel.setBackground(Color.green);
                this.status.setText("Save successful\n" + filename);
                this.configuration.setWorkingDirectory(saveFile.getParentFile());
                save = false;
                continue;
            }
            this.status.setText("Save Cancelled");
        }
    }

    private void inSurfaceWidthFocusGained(FocusEvent evt) {
        this.surfaceWidthPanel.setBackground(this.shaded);
    }

    private void inSurfaceWidthFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void surfaceWidthPanelFocusGained(FocusEvent evt) {
    }

    private void inLeftHeightFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inLeftHeightFocusGained(FocusEvent evt) {
        this.leftHeightPanel.setBackground(this.shaded);
    }

    private void inRightWavelengthFocusGained(FocusEvent evt) {
        this.rightWavelengthPanel.setBackground(this.shaded);
    }

    private void inRightWavelengthFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inRightWavelengthActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inLeftAmplitudeActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inLeftHeightActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesLengthActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inSurfaceWidthActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inSurfaceLengthActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inLeftWavelengthActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inLeftWavelengthFocusGained(FocusEvent evt) {
        this.leftWavelengthPanel.setBackground(this.shaded);
    }

    private void inLeftWavelengthFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inLeftPhaseActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inLeftPhaseFocusGained(FocusEvent evt) {
        this.leftPhasePanel.setBackground(this.shaded);
    }

    private void inLeftPhaseFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inRightHeightActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inRightHeightFocusGained(FocusEvent evt) {
        this.rightHeightPanel.setBackground(this.shaded);
    }

    private void inRightHeightFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inRightAmplitudeActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inRightAmplitudeFocusGained(FocusEvent evt) {
        this.rightAmplitudePanel.setBackground(this.shaded);
    }

    private void inRightAmplitudeFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesWidthActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesWidthFocusGained(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesWidthFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void slicesWidthPanelFocusGained(FocusEvent evt) {
    }

    private void inRightPhaseActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inRightPhaseFocusGained(FocusEvent evt) {
        this.rightPhasePanel.setBackground(this.shaded);
    }

    private void inRightPhaseFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void checkGenerateOK() {
        int temp;
        boolean generateOK = true;
        this.statusPanel.setBackground(this.normal);
        this.status.setText("");
        String statusText = "";
        try {
            temp = Integer.parseInt(this.inSurfaceLength.getText());
            this.surfaceLengthPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for outerRadius\n" : statusText + ex.getMessage() + "\n";
            this.surfaceLengthPanel.setBackground(Color.red);
        }
        try {
            temp = Integer.parseInt(this.inSurfaceWidth.getText());
            this.surfaceWidthPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for outerRadius\n" : statusText + ex.getMessage() + "\n";
            this.surfaceWidthPanel.setBackground(Color.red);
        }
        try {
            int temp2 = Integer.parseInt(this.inSlicesLength.getText());
            this.slicesLengthPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for centreRadius\n" : statusText + ex.getMessage() + "\n";
            this.slicesLengthPanel.setBackground(Color.red);
        }
        try {
            int temp3 = Integer.parseInt(this.inSlicesWidth.getText());
            this.slicesWidthPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for centreRadius\n" : statusText + ex.getMessage() + "\n";
            this.slicesWidthPanel.setBackground(Color.red);
        }
        try {
            int temp4 = Integer.parseInt(this.inLeftHeight.getText());
            this.leftHeightPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for outerThickness\n" : statusText + ex.getMessage() + "\n";
            this.leftHeightPanel.setBackground(Color.red);
        }
        try {
            int temp5 = Integer.parseInt(this.inLeftAmplitude.getText());
            this.leftAmplitudePanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            this.statusPanel.setBackground(Color.yellow);
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for innerThickness\n" : statusText + ex.getMessage() + "\n";
            this.leftAmplitudePanel.setBackground(Color.red);
        }
        try {
            int temp6 = Integer.parseInt(this.inLeftWavelength.getText());
            this.leftWavelengthPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            this.statusPanel.setBackground(Color.yellow);
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for centreThickness\n" : statusText + ex.getMessage() + "\n";
            this.leftWavelengthPanel.setBackground(Color.red);
        }
        try {
            double temp7 = Double.parseDouble(this.inLeftPhase.getText());
            this.leftPhasePanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            this.statusPanel.setBackground(Color.yellow);
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for teeth\n" : statusText + ex.getMessage() + "\n";
            this.leftPhasePanel.setBackground(Color.red);
        }
        try {
            int temp8 = Integer.parseInt(this.inRightHeight.getText());
            this.rightHeightPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            this.statusPanel.setBackground(Color.yellow);
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for innerToothLengthRatio\n" : statusText + ex.getMessage() + "\n";
            this.rightHeightPanel.setBackground(Color.red);
        }
        try {
            int temp9 = Integer.parseInt(this.inRightAmplitude.getText());
            this.rightAmplitudePanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            this.statusPanel.setBackground(Color.yellow);
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for innerToothLengthRatio\n" : statusText + ex.getMessage() + "\n";
            this.rightAmplitudePanel.setBackground(Color.red);
        }
        try {
            int temp10 = Integer.parseInt(this.inRightWavelength.getText());
            this.rightWavelengthPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for the offsetAngle\n" : statusText + ex.getMessage() + "\n";
            this.rightWavelengthPanel.setBackground(Color.red);
        }
        try {
            double temp11 = Double.parseDouble(this.inRightPhase.getText());
            this.rightPhasePanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number for the offsetAngle\n" : statusText + ex.getMessage() + "\n";
            this.rightPhasePanel.setBackground(Color.red);
        }
        if (generateOK) {
            this.generate.setEnabled(true);
        } else {
            this.generate.setEnabled(false);
            this.statusPanel.setBackground(Color.yellow);
            this.status.setText(statusText);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(SineWaveGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(SineWaveGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(SineWaveGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(SineWaveGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SineWaveGeneratorGUI(new Config()).setVisible(true);
            }
        });
    }
}

