/*
 * Decompiled with CFR 0.152.
 */
package main;

import generators.BowlGenerator;
import generators.ExtrudeRadiusFactorCalculator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import main.Config;
import tools.MapFactory;

public class BowlGeneratorGUI
extends JFrame {
    private Config configuration;
    private int circumferenceRadius = 1024;
    private int slopeRadius = 512;
    private Color shaded = new Color(200, 200, 200);
    private Color normal = this.getBackground();
    private String circumferenceRadiusTitle = "Circumference Radius";
    private String circumferenceRadiusDescription = "The radius of the circumference of the bowl (circumference is the rim of the bowl). This value should be greater than or equal to slopeRadius. ";
    private String slopeRadiusTitle = "slopeRadius";
    private String slopeRadiusDescription = "The radius of the upward slope of the bowl. Setting slopeRadius to be equal to circumferenceRadius will produce a perfectly spherical bowl surface. slopeRadius should not be greater than circumferenceRadius. ";
    private String slicesCircumferenceTitle = "slicesCirumference";
    private String slicesCircumferenceDescription = "How many slices to chop the quarter circumference of the bowl into. The total number of triangular surfaces making up this bowl will be 2 * slicesCircumference * slicesSlope. ";
    private String slicesSlopeTitle = "slicesSlope";
    private String slicesSlopeDescription = "How many slices to chop the vertical slope of the bowl into. The total number of triangular surfaces making up this bowl will be 2 * slicesCircumference * slicesSlope. ";
    private String crossSectionTitle = "crossSection";
    private String crossSectionDescription = "The width and height of the square cross section of the rim of the bowl. This value should be greater than slopeRadius.";
    private String offsetTopTitle = "offsetTop";
    private String offsetTopDescription = "Alters the pattern of the mesh by flipping the even-odd rule in which vertices get rotated by half a slice along the circumference. This is useful when joining other offset objects to the circumference of the bowl, such as offset cylinders or funnels. ";
    private String extrudeTopNSlicesTitle = "extrudeTopNSlices";
    private String extrudeTopNSlicesDescription = "If this is greater than zero and if extrudeRadiusFactor is greater than one, the topmost extrudeTopNSlices vertices of the bowl will be pushed back so that the top of the bowl is no longer vertical. It \"relaxes\" the top of the bowl to have a less steep slope. ";
    private String extrudeRadiusFactorTitle = "Extrude Radius Factor";
    private String extrudeRadiusFactorDescription = "Used together with extrudeTopNSlices. This value should be greater than one and extrudeTopNSlices should be greater than zero to make the top of the bowl less steep. It is possible to use values slightly less than one here to generate an \"oversteep\" top, but if used improperly, poor results will be generated, or [possibly] nothing will be generated at all. A value of 1.0 corresponds to a normal bowl with perfectly vertical top. Otherwise, the top vertices are generated based on a radius of slopeRadius * extrudeRadiusFactor.";
    private String adjustForOverlappingPipeCutsTitle = "Adjust For Overlapping Pipe Cuts";
    private String adjustForOverlappingPipeCutsDescription = "In the case where pipe brushes are joined at the seam of this bowl, set this flag whenever the pipe brushes are generated with adjustForOverlappingPipeCuts also. ";
    private String adjustForOverlappingBowlCutsTitle = "Adjust For Overlapping Bowl Cuts";
    private String adjustForOverlappingBowlCutsDescription = "When cutting overlapping bowl brushes at the top (z = 0), set this flag so that the resulting cut brushes lie on integer coordinates. ";
    private String generateOnlySeamTitle = "generateOnlySeam";
    private String generateOnlySeamDescription = "Generates only the seam brushes. ";
    private String adjustSeamForJoiningTitle = "adjustSeamForJoining";
    private String adjustSeamForJoiningDescription = "Perturb the vertices of the seam brushes so that other structures such as pipes can be joined perfectly to this quarter bowl. ";
    private String opNormalTitle = "Generate normal non-overlapping brushes";
    private String opNormalDescription = "Generates ordinary brushes. To make a bowl wall to fling you around at high speeds, you will have to generate overlapping brushes in order to prevent \"bouncing\". Another purpose for normal brushes is to define the visual component of a structure, for example by using surfaceparm nonsolid.";
    private String opOverlappingTitle = "Generate overlapping brushes";
    private String opOverlappingDescription = "Overlapping brushes are useful for making bowls such that the player doesn't \"bounce\" off the surface when flying along the bowl. However, it is not advised to texture the overlapping brush faces with drawn textures. Instead, apply [slick] caulk to all of the overlapping brushes, then superimpose a set of normal non-overlapping brushes that have surfaceparm nonsolid. NOTE: When you are done generating overlapping brushes, you will likely want to cut everything off that is above z = 0. Use adjustForOverlappingBowlCuts to ensure that the resulting cuts are clean and along integer coordinates. ";
    private JCheckBox adjustForOverlappingBowlCuts;
    private JPanel adjustForOverlappingBowlCutsPanel;
    private JCheckBox adjustForOverlappingPipeCuts;
    private JPanel adjustForOverlappingPipeCutsPanel;
    private JCheckBox adjustSeamForJoining;
    private JPanel adjustSeamForJoiningPanel;
    private JButton calculate;
    private JMenuItem calculateExtrudeRadiusFactor;
    private JDialog calculateExtrudeRadiusPopup;
    private JPanel calculatePanel;
    private JMenu calculator;
    private JTextArea calculatorDescription;
    private JPanel calculatorDescriptionPanel;
    private JPanel calculatorOptionPanel;
    private JPanel calculatorPanel;
    private JLabel calculatorStatus;
    private JPanel calculatorStatusPanel;
    private JPanel circumferenceRadiusPanel;
    private JOptionPane confirmOverwrite;
    private JPanel crossSectionPanel;
    private JTextArea description;
    private JPanel descriptionPanel;
    private JScrollPane descriptionScrollPane;
    private JLabel descriptionTitle;
    private JPanel extrudeRadiusFactorPanel;
    private JPanel extrudeTopNSlicesPanel;
    private JButton generate;
    private JCheckBox generateOnlySeam;
    private JPanel generateOnlySeamPanel;
    private JLabel icon;
    private JPanel iconPanel;
    private JTextField inCircumferenceRadius;
    private JTextField inCrossSection;
    private JTextField inExtrudeRadiusFactor;
    private JTextField inExtrudeTopNSlices;
    private JTextField inLipOffset;
    private JTextField inSlicesCirumference;
    private JTextField inSlicesSlope;
    private JTextField inSlopeRadius;
    private JScrollPane jScrollPane1;
    private JLabel laLipOffset;
    private JLabel labCircumferenceRadius;
    private JLabel labCrossSection;
    private JLabel labExtrudeRadiusFactor;
    private JLabel labExtrudeTopNSlices;
    private JLabel labSlicesCircumference;
    private JLabel labSlicesSlope;
    private JLabel labSlopeRadius;
    private JMenuBar menuBar;
    private JPanel normalOptionPanel;
    private JCheckBox offsetTop;
    private JPanel offsetTopPanel;
    private JRadioButton opNormal;
    private JRadioButton opOverlapping;
    private ButtonGroup options;
    private JPanel optionsPanel;
    private JPanel overlappingBrushOptionPanel;
    private JScrollPane scrollPane;
    private JPanel slicesCircumferencePanel;
    private JPanel slicesSlopePanel;
    private JPanel slopeRadiusPanel;
    private JTextArea status;
    private JPanel statusPanel;
    private JScrollPane statusScrollPane;
    private JLabel subtitle;
    private JPanel subtitlePanel;
    private JPanel valuesPanel;
    private JPanel viewPanel;

    public BowlGeneratorGUI(Config configuration) {
        this.initComponents();
        this.configuration = configuration;
        Dimension frameSize = this.getSize();
        int frameHeight = frameSize.height;
        int frameWidth = frameSize.width;
        if (frameHeight > configuration.getScreenHeight()) {
            this.setSize(frameWidth, configuration.getScreenHeight());
        }
    }

    private void initComponents() {
        this.options = new ButtonGroup();
        this.calculateExtrudeRadiusPopup = new JDialog();
        this.calculatorPanel = new JPanel();
        this.calculatorOptionPanel = new JPanel();
        this.laLipOffset = new JLabel();
        this.inLipOffset = new JTextField();
        this.calculatorStatusPanel = new JPanel();
        this.calculatorStatus = new JLabel();
        this.calculatePanel = new JPanel();
        this.calculate = new JButton();
        this.calculatorDescriptionPanel = new JPanel();
        this.calculatorDescription = new JTextArea();
        this.confirmOverwrite = new JOptionPane();
        this.jScrollPane1 = new JScrollPane();
        this.scrollPane = new JScrollPane();
        this.viewPanel = new JPanel();
        this.iconPanel = new JPanel();
        this.icon = new JLabel();
        this.statusPanel = new JPanel();
        this.generate = new JButton();
        this.statusScrollPane = new JScrollPane();
        this.status = new JTextArea();
        this.optionsPanel = new JPanel();
        this.normalOptionPanel = new JPanel();
        this.opNormal = new JRadioButton();
        this.overlappingBrushOptionPanel = new JPanel();
        this.opOverlapping = new JRadioButton();
        this.descriptionPanel = new JPanel();
        this.descriptionScrollPane = new JScrollPane();
        this.description = new JTextArea();
        this.descriptionTitle = new JLabel();
        this.subtitlePanel = new JPanel();
        this.subtitle = new JLabel();
        this.valuesPanel = new JPanel();
        this.circumferenceRadiusPanel = new JPanel();
        this.labCircumferenceRadius = new JLabel();
        this.inCircumferenceRadius = new JTextField();
        this.crossSectionPanel = new JPanel();
        this.labCrossSection = new JLabel();
        this.inCrossSection = new JTextField();
        this.slicesCircumferencePanel = new JPanel();
        this.labSlicesCircumference = new JLabel();
        this.inSlicesCirumference = new JTextField();
        this.slicesSlopePanel = new JPanel();
        this.labSlicesSlope = new JLabel();
        this.inSlicesSlope = new JTextField();
        this.extrudeRadiusFactorPanel = new JPanel();
        this.labExtrudeRadiusFactor = new JLabel();
        this.inExtrudeRadiusFactor = new JTextField();
        this.adjustForOverlappingBowlCutsPanel = new JPanel();
        this.adjustForOverlappingBowlCuts = new JCheckBox();
        this.extrudeTopNSlicesPanel = new JPanel();
        this.labExtrudeTopNSlices = new JLabel();
        this.inExtrudeTopNSlices = new JTextField();
        this.adjustForOverlappingPipeCutsPanel = new JPanel();
        this.adjustForOverlappingPipeCuts = new JCheckBox();
        this.slopeRadiusPanel = new JPanel();
        this.labSlopeRadius = new JLabel();
        this.inSlopeRadius = new JTextField();
        this.offsetTopPanel = new JPanel();
        this.offsetTop = new JCheckBox();
        this.adjustSeamForJoiningPanel = new JPanel();
        this.adjustSeamForJoining = new JCheckBox();
        this.generateOnlySeamPanel = new JPanel();
        this.generateOnlySeam = new JCheckBox();
        this.menuBar = new JMenuBar();
        this.calculator = new JMenu();
        this.calculateExtrudeRadiusFactor = new JMenuItem();
        this.calculateExtrudeRadiusPopup.setTitle("Extrude Radius Factor Calculator");
        this.calculateExtrudeRadiusPopup.setMinimumSize(new Dimension(330, 372));
        this.laLipOffset.setFont(new Font("Tahoma", 0, 12));
        this.laLipOffset.setText("lipOffset:");
        this.inLipOffset.setFont(new Font("Tahoma", 0, 12));
        this.inLipOffset.setText("5");
        this.inLipOffset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BowlGeneratorGUI.this.inLipOffsetActionPerformed(evt);
            }
        });
        this.inLipOffset.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BowlGeneratorGUI.this.inLipOffsetFocusLost(evt);
            }
        });
        this.inLipOffset.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BowlGeneratorGUI.this.inLipOffsetPropertyChange(evt);
            }
        });
        this.inLipOffset.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                BowlGeneratorGUI.this.inLipOffsetKeyTyped(evt);
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                BowlGeneratorGUI.this.inLipOffsetKeyPressed(evt);
            }
        });
        GroupLayout calculatorOptionPanelLayout = new GroupLayout(this.calculatorOptionPanel);
        this.calculatorOptionPanel.setLayout(calculatorOptionPanelLayout);
        calculatorOptionPanelLayout.setHorizontalGroup(calculatorOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorOptionPanelLayout.createSequentialGroup().addContainerGap(18, Short.MAX_VALUE).addComponent(this.laLipOffset).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.inLipOffset, -2, 48, -2).addContainerGap()));
        calculatorOptionPanelLayout.setVerticalGroup(calculatorOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, calculatorOptionPanelLayout.createSequentialGroup().addGap(0, 25, Short.MAX_VALUE).addGroup(calculatorOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inLipOffset, -2, -1, -2).addComponent(this.laLipOffset))));
        this.calculatorStatus.setFont(new Font("Tahoma", 0, 12));
        this.calculatorStatus.setText("Enter a value for the lip offset");
        GroupLayout calculatorStatusPanelLayout = new GroupLayout(this.calculatorStatusPanel);
        this.calculatorStatusPanel.setLayout(calculatorStatusPanelLayout);
        calculatorStatusPanelLayout.setHorizontalGroup(calculatorStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorStatusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorStatus, -1, 220, Short.MAX_VALUE).addContainerGap()));
        calculatorStatusPanelLayout.setVerticalGroup(calculatorStatusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, calculatorStatusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.calculatorStatus).addContainerGap()));
        this.calculate.setText("Calculate");
        this.calculate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BowlGeneratorGUI.this.calculateActionPerformed(evt);
            }
        });
        GroupLayout calculatePanelLayout = new GroupLayout(this.calculatePanel);
        this.calculatePanel.setLayout(calculatePanelLayout);
        calculatePanelLayout.setHorizontalGroup(calculatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, calculatePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.calculate, -1, -1, Short.MAX_VALUE).addContainerGap()));
        calculatePanelLayout.setVerticalGroup(calculatePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, calculatePanelLayout.createSequentialGroup().addGap(0, 24, Short.MAX_VALUE).addComponent(this.calculate)));
        this.calculatorDescription.setEditable(false);
        this.calculatorDescription.setBackground(new Color(240, 240, 240));
        this.calculatorDescription.setColumns(20);
        this.calculatorDescription.setLineWrap(true);
        this.calculatorDescription.setRows(5);
        this.calculatorDescription.setText("Calculates the extrudeRadiusFactor based on the values of slopeRadius, slicesSlope and topNSlices.\n\nThe lipOffset is the number of units the top edge of the circular arc is to be nudged outward.\n\nNote that specifying a lipOffset of greater than what is possible to extrude (by setting a radius to be very large)  will generate erroneous results. ");
        this.calculatorDescription.setWrapStyleWord(true);
        GroupLayout calculatorDescriptionPanelLayout = new GroupLayout(this.calculatorDescriptionPanel);
        this.calculatorDescriptionPanel.setLayout(calculatorDescriptionPanelLayout);
        calculatorDescriptionPanelLayout.setHorizontalGroup(calculatorDescriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorDescriptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorDescription, -2, 292, -2).addContainerGap(-1, Short.MAX_VALUE)));
        calculatorDescriptionPanelLayout.setVerticalGroup(calculatorDescriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, calculatorDescriptionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.calculatorDescription, -2, 198, -2).addGap(245, 245, 245)));
        GroupLayout calculatorPanelLayout = new GroupLayout(this.calculatorPanel);
        this.calculatorPanel.setLayout(calculatorPanelLayout);
        calculatorPanelLayout.setHorizontalGroup(calculatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorPanelLayout.createSequentialGroup().addContainerGap().addGroup(calculatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(calculatorPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.calculatorStatusPanel, -2, -1, -2).addGroup(calculatorPanelLayout.createSequentialGroup().addComponent(this.calculatorOptionPanel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.calculatePanel, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.calculatorDescriptionPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        calculatorPanelLayout.setVerticalGroup(calculatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculatorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorDescriptionPanel, -2, 222, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(calculatorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.calculatorOptionPanel, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.calculatePanel, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.calculatorStatusPanel, -2, -1, -2).addContainerGap()));
        GroupLayout calculateExtrudeRadiusPopupLayout = new GroupLayout(this.calculateExtrudeRadiusPopup.getContentPane());
        this.calculateExtrudeRadiusPopup.getContentPane().setLayout(calculateExtrudeRadiusPopupLayout);
        calculateExtrudeRadiusPopupLayout.setHorizontalGroup(calculateExtrudeRadiusPopupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculateExtrudeRadiusPopupLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        calculateExtrudeRadiusPopupLayout.setVerticalGroup(calculateExtrudeRadiusPopupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(calculateExtrudeRadiusPopupLayout.createSequentialGroup().addContainerGap().addComponent(this.calculatorPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.setTitle("Bowl Generator");
        this.setLocationByPlatform(true);
        this.icon.setHorizontalAlignment(0);
        this.icon.setIcon(new ImageIcon(this.getClass().getResource("/main/bowl.png")));
        this.icon.setFocusable(false);
        GroupLayout iconPanelLayout = new GroupLayout(this.iconPanel);
        this.iconPanel.setLayout(iconPanelLayout);
        iconPanelLayout.setHorizontalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(iconPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.icon, -1, -1, Short.MAX_VALUE).addContainerGap()));
        iconPanelLayout.setVerticalGroup(iconPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, iconPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.icon, -2, 196, -2)));
        this.generate.setText("Generate");
        this.generate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BowlGeneratorGUI.this.generateActionPerformed(evt);
            }
        });
        this.status.setEditable(false);
        this.status.setColumns(20);
        this.status.setRows(5);
        this.status.setFocusable(false);
        this.statusScrollPane.setViewportView(this.status);
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusScrollPane).addGap(18, 18, 18).addComponent(this.generate).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, statusPanelLayout.createSequentialGroup().addContainerGap().addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusScrollPane, -2, 0, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.generate).addGap(0, 9, Short.MAX_VALUE))).addContainerGap()));
        this.normalOptionPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                BowlGeneratorGUI.this.normalOptionPanelFocusLost(evt);
            }
        });
        this.options.add(this.opNormal);
        this.opNormal.setSelected(true);
        this.opNormal.setText("generate normal non-overlapping brushes");
        this.opNormal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BowlGeneratorGUI.this.opNormalActionPerformed(evt);
            }
        });
        this.opNormal.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                BowlGeneratorGUI.this.opNormalFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                BowlGeneratorGUI.this.opNormalFocusLost(evt);
            }
        });
        GroupLayout normalOptionPanelLayout = new GroupLayout(this.normalOptionPanel);
        this.normalOptionPanel.setLayout(normalOptionPanelLayout);
        normalOptionPanelLayout.setHorizontalGroup(normalOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(normalOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opNormal).addContainerGap(-1, Short.MAX_VALUE)));
        normalOptionPanelLayout.setVerticalGroup(normalOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.opNormal, -1, 27, Short.MAX_VALUE));
        this.options.add(this.opOverlapping);
        this.opOverlapping.setText("generate overlapping brushes");
        this.opOverlapping.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BowlGeneratorGUI.this.opOverlappingActionPerformed(evt);
            }
        });
        this.opOverlapping.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                BowlGeneratorGUI.this.opOverlappingFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                BowlGeneratorGUI.this.opOverlappingFocusLost(evt);
            }
        });
        GroupLayout overlappingBrushOptionPanelLayout = new GroupLayout(this.overlappingBrushOptionPanel);
        this.overlappingBrushOptionPanel.setLayout(overlappingBrushOptionPanelLayout);
        overlappingBrushOptionPanelLayout.setHorizontalGroup(overlappingBrushOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(overlappingBrushOptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.opOverlapping).addContainerGap(-1, Short.MAX_VALUE)));
        overlappingBrushOptionPanelLayout.setVerticalGroup(overlappingBrushOptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.opOverlapping));
        GroupLayout optionsPanelLayout = new GroupLayout(this.optionsPanel);
        this.optionsPanel.setLayout(optionsPanelLayout);
        optionsPanelLayout.setHorizontalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, optionsPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.overlappingBrushOptionPanel, -1, -1, Short.MAX_VALUE).addComponent(this.normalOptionPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        optionsPanelLayout.setVerticalGroup(optionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(optionsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.normalOptionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.overlappingBrushOptionPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.description.setEditable(false);
        this.description.setColumns(20);
        this.description.setLineWrap(true);
        this.description.setRows(5);
        this.description.setWrapStyleWord(true);
        this.description.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.description.setFocusable(false);
        this.description.setMargin(new Insets(5, 5, 5, 5));
        this.descriptionScrollPane.setViewportView(this.description);
        this.descriptionTitle.setHorizontalAlignment(0);
        GroupLayout descriptionPanelLayout = new GroupLayout(this.descriptionPanel);
        this.descriptionPanel.setLayout(descriptionPanelLayout);
        descriptionPanelLayout.setHorizontalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.descriptionTitle, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.descriptionScrollPane, -2, 297, -2).addGap(26, 26, 26)));
        descriptionPanelLayout.setVerticalGroup(descriptionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, descriptionPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.descriptionTitle, -2, 43, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.descriptionScrollPane, -1, 258, Short.MAX_VALUE).addContainerGap()));
        this.subtitle.setHorizontalAlignment(0);
        this.subtitle.setText("Generates the rim of a quarter bowl as a .map file to be opened in GtkRadiant.");
        GroupLayout subtitlePanelLayout = new GroupLayout(this.subtitlePanel);
        this.subtitlePanel.setLayout(subtitlePanelLayout);
        subtitlePanelLayout.setHorizontalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(subtitlePanelLayout.createSequentialGroup().addContainerGap().addComponent(this.subtitle, -1, 718, Short.MAX_VALUE)));
        subtitlePanelLayout.setVerticalGroup(subtitlePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.subtitle, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        this.circumferenceRadiusPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                BowlGeneratorGUI.this.circumferenceRadiusPanelFocusGained(evt);
            }
        });
        this.labCircumferenceRadius.setLabelFor(this.inCircumferenceRadius);
        this.labCircumferenceRadius.setText("circumferenceRadius:");
        this.inCircumferenceRadius.setText("1024");
        this.inCircumferenceRadius.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BowlGeneratorGUI.this.inCircumferenceRadiusActionPerformed(evt);
            }
        });
        this.inCircumferenceRadius.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                BowlGeneratorGUI.this.inCircumferenceRadiusFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                BowlGeneratorGUI.this.inCircumferenceRadiusFocusLost(evt);
            }
        });
        GroupLayout circumferenceRadiusPanelLayout = new GroupLayout(this.circumferenceRadiusPanel);
        this.circumferenceRadiusPanel.setLayout(circumferenceRadiusPanelLayout);
        circumferenceRadiusPanelLayout.setHorizontalGroup(circumferenceRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(circumferenceRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labCircumferenceRadius).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inCircumferenceRadius, -2, 64, -2).addContainerGap()));
        circumferenceRadiusPanelLayout.setVerticalGroup(circumferenceRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, circumferenceRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(circumferenceRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labCircumferenceRadius).addComponent(this.inCircumferenceRadius, -2, -1, -2)).addContainerGap()));
        this.labCrossSection.setLabelFor(this.inCrossSection);
        this.labCrossSection.setText("crossSection:");
        this.inCrossSection.setText("768");
        this.inCrossSection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BowlGeneratorGUI.this.inCrossSectionActionPerformed(evt);
            }
        });
        this.inCrossSection.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                BowlGeneratorGUI.this.inCrossSectionFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                BowlGeneratorGUI.this.inCrossSectionFocusLost(evt);
            }
        });
        GroupLayout crossSectionPanelLayout = new GroupLayout(this.crossSectionPanel);
        this.crossSectionPanel.setLayout(crossSectionPanelLayout);
        crossSectionPanelLayout.setHorizontalGroup(crossSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(crossSectionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labCrossSection).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inCrossSection, -2, 64, -2).addContainerGap()));
        crossSectionPanelLayout.setVerticalGroup(crossSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, crossSectionPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(crossSectionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labCrossSection).addComponent(this.inCrossSection, -2, -1, -2)).addContainerGap()));
        this.labSlicesCircumference.setLabelFor(this.inSlicesCirumference);
        this.labSlicesCircumference.setText("slicesCircumference:");
        this.inSlicesCirumference.setText("16");
        this.inSlicesCirumference.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BowlGeneratorGUI.this.inSlicesCirumferenceActionPerformed(evt);
            }
        });
        this.inSlicesCirumference.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                BowlGeneratorGUI.this.inSlicesCirumferenceFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                BowlGeneratorGUI.this.inSlicesCirumferenceFocusLost(evt);
            }
        });
        GroupLayout slicesCircumferencePanelLayout = new GroupLayout(this.slicesCircumferencePanel);
        this.slicesCircumferencePanel.setLayout(slicesCircumferencePanelLayout);
        slicesCircumferencePanelLayout.setHorizontalGroup(slicesCircumferencePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(slicesCircumferencePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labSlicesCircumference).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inSlicesCirumference, -2, 64, -2).addContainerGap()));
        slicesCircumferencePanelLayout.setVerticalGroup(slicesCircumferencePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, slicesCircumferencePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(slicesCircumferencePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labSlicesCircumference).addComponent(this.inSlicesCirumference, -2, -1, -2)).addContainerGap()));
        this.labSlicesSlope.setLabelFor(this.inSlicesSlope);
        this.labSlicesSlope.setText("slicesSlope:");
        this.inSlicesSlope.setText("14");
        this.inSlicesSlope.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BowlGeneratorGUI.this.inSlicesSlopeActionPerformed(evt);
            }
        });
        this.inSlicesSlope.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                BowlGeneratorGUI.this.inSlicesSlopeFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                BowlGeneratorGUI.this.inSlicesSlopeFocusLost(evt);
            }
        });
        GroupLayout slicesSlopePanelLayout = new GroupLayout(this.slicesSlopePanel);
        this.slicesSlopePanel.setLayout(slicesSlopePanelLayout);
        slicesSlopePanelLayout.setHorizontalGroup(slicesSlopePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(slicesSlopePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labSlicesSlope).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inSlicesSlope, -2, 64, -2).addContainerGap()));
        slicesSlopePanelLayout.setVerticalGroup(slicesSlopePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(slicesSlopePanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(slicesSlopePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labSlicesSlope).addComponent(this.inSlicesSlope, -2, -1, -2))));
        this.labExtrudeRadiusFactor.setLabelFor(this.inExtrudeRadiusFactor);
        this.labExtrudeRadiusFactor.setText("extrudeRadiusFactor:");
        this.labExtrudeRadiusFactor.setEnabled(false);
        this.inExtrudeRadiusFactor.setText("1.0");
        this.inExtrudeRadiusFactor.setEnabled(false);
        this.inExtrudeRadiusFactor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BowlGeneratorGUI.this.inExtrudeRadiusFactorActionPerformed(evt);
            }
        });
        this.inExtrudeRadiusFactor.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                BowlGeneratorGUI.this.inExtrudeRadiusFactorFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                BowlGeneratorGUI.this.inExtrudeRadiusFactorFocusLost(evt);
            }
        });
        GroupLayout extrudeRadiusFactorPanelLayout = new GroupLayout(this.extrudeRadiusFactorPanel);
        this.extrudeRadiusFactorPanel.setLayout(extrudeRadiusFactorPanelLayout);
        extrudeRadiusFactorPanelLayout.setHorizontalGroup(extrudeRadiusFactorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(extrudeRadiusFactorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.labExtrudeRadiusFactor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 70, Short.MAX_VALUE).addComponent(this.inExtrudeRadiusFactor, -2, 165, -2).addContainerGap()));
        extrudeRadiusFactorPanelLayout.setVerticalGroup(extrudeRadiusFactorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, extrudeRadiusFactorPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(extrudeRadiusFactorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labExtrudeRadiusFactor).addComponent(this.inExtrudeRadiusFactor, -2, -1, -2)).addContainerGap()));
        this.adjustForOverlappingBowlCuts.setText("adjustForOverlappingBowlCuts");
        this.adjustForOverlappingBowlCuts.setHorizontalAlignment(11);
        this.adjustForOverlappingBowlCuts.setHorizontalTextPosition(10);
        this.adjustForOverlappingBowlCuts.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                BowlGeneratorGUI.this.adjustForOverlappingBowlCutsFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                BowlGeneratorGUI.this.adjustForOverlappingBowlCutsFocusLost(evt);
            }
        });
        GroupLayout adjustForOverlappingBowlCutsPanelLayout = new GroupLayout(this.adjustForOverlappingBowlCutsPanel);
        this.adjustForOverlappingBowlCutsPanel.setLayout(adjustForOverlappingBowlCutsPanelLayout);
        adjustForOverlappingBowlCutsPanelLayout.setHorizontalGroup(adjustForOverlappingBowlCutsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(adjustForOverlappingBowlCutsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.adjustForOverlappingBowlCuts, -1, -1, Short.MAX_VALUE).addContainerGap()));
        adjustForOverlappingBowlCutsPanelLayout.setVerticalGroup(adjustForOverlappingBowlCutsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, adjustForOverlappingBowlCutsPanelLayout.createSequentialGroup().addGap(0, 12, Short.MAX_VALUE).addComponent(this.adjustForOverlappingBowlCuts, -2, 23, -2)));
        this.labExtrudeTopNSlices.setText("extrudeTopNSlices:");
        this.inExtrudeTopNSlices.setText("0");
        this.inExtrudeTopNSlices.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BowlGeneratorGUI.this.inExtrudeTopNSlicesActionPerformed(evt);
            }
        });
        this.inExtrudeTopNSlices.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                BowlGeneratorGUI.this.inExtrudeTopNSlicesFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                BowlGeneratorGUI.this.inExtrudeTopNSlicesFocusLost(evt);
            }
        });
        GroupLayout extrudeTopNSlicesPanelLayout = new GroupLayout(this.extrudeTopNSlicesPanel);
        this.extrudeTopNSlicesPanel.setLayout(extrudeTopNSlicesPanelLayout);
        extrudeTopNSlicesPanelLayout.setHorizontalGroup(extrudeTopNSlicesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(extrudeTopNSlicesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labExtrudeTopNSlices).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inExtrudeTopNSlices, -2, 64, -2).addContainerGap()));
        extrudeTopNSlicesPanelLayout.setVerticalGroup(extrudeTopNSlicesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, extrudeTopNSlicesPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(extrudeTopNSlicesPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labExtrudeTopNSlices).addComponent(this.inExtrudeTopNSlices, -2, -1, -2)).addContainerGap()));
        this.adjustForOverlappingPipeCuts.setText("adjustForOverlappingPipeCuts");
        this.adjustForOverlappingPipeCuts.setHorizontalAlignment(11);
        this.adjustForOverlappingPipeCuts.setHorizontalTextPosition(10);
        this.adjustForOverlappingPipeCuts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BowlGeneratorGUI.this.adjustForOverlappingPipeCutsActionPerformed(evt);
            }
        });
        this.adjustForOverlappingPipeCuts.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                BowlGeneratorGUI.this.adjustForOverlappingPipeCutsFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                BowlGeneratorGUI.this.adjustForOverlappingPipeCutsFocusLost(evt);
            }
        });
        GroupLayout adjustForOverlappingPipeCutsPanelLayout = new GroupLayout(this.adjustForOverlappingPipeCutsPanel);
        this.adjustForOverlappingPipeCutsPanel.setLayout(adjustForOverlappingPipeCutsPanelLayout);
        adjustForOverlappingPipeCutsPanelLayout.setHorizontalGroup(adjustForOverlappingPipeCutsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, adjustForOverlappingPipeCutsPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.adjustForOverlappingPipeCuts).addContainerGap()));
        adjustForOverlappingPipeCutsPanelLayout.setVerticalGroup(adjustForOverlappingPipeCutsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, adjustForOverlappingPipeCutsPanelLayout.createSequentialGroup().addGap(0, 10, Short.MAX_VALUE).addComponent(this.adjustForOverlappingPipeCuts, -2, 23, -2)));
        this.slopeRadiusPanel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                BowlGeneratorGUI.this.slopeRadiusPanelFocusGained(evt);
            }
        });
        this.labSlopeRadius.setLabelFor(this.inCircumferenceRadius);
        this.labSlopeRadius.setText("slopeRadius:");
        this.inSlopeRadius.setText("512");
        this.inSlopeRadius.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BowlGeneratorGUI.this.inSlopeRadiusActionPerformed(evt);
            }
        });
        this.inSlopeRadius.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                BowlGeneratorGUI.this.inSlopeRadiusFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                BowlGeneratorGUI.this.inSlopeRadiusFocusLost(evt);
            }
        });
        GroupLayout slopeRadiusPanelLayout = new GroupLayout(this.slopeRadiusPanel);
        this.slopeRadiusPanel.setLayout(slopeRadiusPanelLayout);
        slopeRadiusPanelLayout.setHorizontalGroup(slopeRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(slopeRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.labSlopeRadius).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.inSlopeRadius, -2, 64, -2).addContainerGap()));
        slopeRadiusPanelLayout.setVerticalGroup(slopeRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, slopeRadiusPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(slopeRadiusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labSlopeRadius).addComponent(this.inSlopeRadius, -2, -1, -2)).addContainerGap()));
        this.offsetTop.setText("offsetTop");
        this.offsetTop.setHorizontalAlignment(11);
        this.offsetTop.setHorizontalTextPosition(10);
        this.offsetTop.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                BowlGeneratorGUI.this.offsetTopFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                BowlGeneratorGUI.this.offsetTopFocusLost(evt);
            }
        });
        GroupLayout offsetTopPanelLayout = new GroupLayout(this.offsetTopPanel);
        this.offsetTopPanel.setLayout(offsetTopPanelLayout);
        offsetTopPanelLayout.setHorizontalGroup(offsetTopPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, offsetTopPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.offsetTop, -2, 137, -2).addContainerGap()));
        offsetTopPanelLayout.setVerticalGroup(offsetTopPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(offsetTopPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.offsetTop).addContainerGap(-1, Short.MAX_VALUE)));
        this.adjustSeamForJoining.setText("adjustSeamForJoining");
        this.adjustSeamForJoining.setHorizontalAlignment(11);
        this.adjustSeamForJoining.setHorizontalTextPosition(10);
        this.adjustSeamForJoining.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                BowlGeneratorGUI.this.adjustSeamForJoiningFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                BowlGeneratorGUI.this.adjustSeamForJoiningFocusLost(evt);
            }
        });
        GroupLayout adjustSeamForJoiningPanelLayout = new GroupLayout(this.adjustSeamForJoiningPanel);
        this.adjustSeamForJoiningPanel.setLayout(adjustSeamForJoiningPanelLayout);
        adjustSeamForJoiningPanelLayout.setHorizontalGroup(adjustSeamForJoiningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(adjustSeamForJoiningPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.adjustSeamForJoining, -1, -1, Short.MAX_VALUE).addContainerGap()));
        adjustSeamForJoiningPanelLayout.setVerticalGroup(adjustSeamForJoiningPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, adjustSeamForJoiningPanelLayout.createSequentialGroup().addGap(0, 6, Short.MAX_VALUE).addComponent(this.adjustSeamForJoining, -2, 23, -2)));
        this.generateOnlySeam.setText("generateOnlySeam");
        this.generateOnlySeam.setHorizontalAlignment(11);
        this.generateOnlySeam.setHorizontalTextPosition(10);
        this.generateOnlySeam.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BowlGeneratorGUI.this.generateOnlySeamActionPerformed(evt);
            }
        });
        this.generateOnlySeam.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                BowlGeneratorGUI.this.generateOnlySeamFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                BowlGeneratorGUI.this.generateOnlySeamFocusLost(evt);
            }
        });
        GroupLayout generateOnlySeamPanelLayout = new GroupLayout(this.generateOnlySeamPanel);
        this.generateOnlySeamPanel.setLayout(generateOnlySeamPanelLayout);
        generateOnlySeamPanelLayout.setHorizontalGroup(generateOnlySeamPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, generateOnlySeamPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.generateOnlySeam, -1, -1, Short.MAX_VALUE).addContainerGap()));
        generateOnlySeamPanelLayout.setVerticalGroup(generateOnlySeamPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, generateOnlySeamPanelLayout.createSequentialGroup().addGap(0, 6, Short.MAX_VALUE).addComponent(this.generateOnlySeam, -2, 23, -2)));
        GroupLayout valuesPanelLayout = new GroupLayout(this.valuesPanel);
        this.valuesPanel.setLayout(valuesPanelLayout);
        valuesPanelLayout.setHorizontalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, valuesPanelLayout.createSequentialGroup().addContainerGap().addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.offsetTopPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.extrudeTopNSlicesPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.crossSectionPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.slicesSlopePanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.slicesCircumferencePanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.slopeRadiusPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.circumferenceRadiusPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, valuesPanelLayout.createSequentialGroup().addContainerGap().addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.adjustSeamForJoiningPanel, -1, -1, Short.MAX_VALUE).addComponent(this.generateOnlySeamPanel, -1, -1, Short.MAX_VALUE))).addGroup(valuesPanelLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.extrudeRadiusFactorPanel, -1, -1, Short.MAX_VALUE).addComponent(this.adjustForOverlappingBowlCutsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.adjustForOverlappingPipeCutsPanel, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        valuesPanelLayout.setVerticalGroup(valuesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(valuesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.circumferenceRadiusPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slopeRadiusPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slicesCircumferencePanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.slicesSlopePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.crossSectionPanel, -2, 32, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.offsetTopPanel, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.extrudeTopNSlicesPanel, -2, 31, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.extrudeRadiusFactorPanel, -2, 33, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.adjustForOverlappingPipeCutsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.adjustForOverlappingBowlCutsPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.generateOnlySeamPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.adjustSeamForJoiningPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout viewPanelLayout = new GroupLayout(this.viewPanel);
        this.viewPanel.setLayout(viewPanelLayout);
        viewPanelLayout.setHorizontalGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(viewPanelLayout.createSequentialGroup().addContainerGap().addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(viewPanelLayout.createSequentialGroup().addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.valuesPanel, -2, -1, -2).addComponent(this.optionsPanel, -2, -1, -2)).addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(viewPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.descriptionPanel, -2, 323, -2)).addGroup(viewPanelLayout.createSequentialGroup().addGap(40, 40, 40).addComponent(this.iconPanel, -2, -1, -2)))).addComponent(this.statusPanel, -1, -1, Short.MAX_VALUE).addComponent(this.subtitlePanel, -2, -1, -2)).addContainerGap(204, Short.MAX_VALUE)));
        viewPanelLayout.setVerticalGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, viewPanelLayout.createSequentialGroup().addContainerGap(35, Short.MAX_VALUE).addComponent(this.subtitlePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(viewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(viewPanelLayout.createSequentialGroup().addComponent(this.descriptionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.iconPanel, -2, -1, -2)).addGroup(viewPanelLayout.createSequentialGroup().addComponent(this.valuesPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.optionsPanel, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusPanel, -2, -1, -2).addContainerGap()));
        this.scrollPane.setViewportView(this.viewPanel);
        this.calculator.setText("Calculator");
        this.calculator.setToolTipText("Calculates the extrudeRadiusFactor for a given lip offset");
        this.calculateExtrudeRadiusFactor.setText("Calculate extrudeRadiusFactor");
        this.calculateExtrudeRadiusFactor.setToolTipText("extrudeTopNSlices must be positive to use the calculator");
        this.calculateExtrudeRadiusFactor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BowlGeneratorGUI.this.calculateExtrudeRadiusFactorActionPerformed(evt);
            }
        });
        this.calculator.add(this.calculateExtrudeRadiusFactor);
        this.menuBar.add(this.calculator);
        this.setJMenuBar(this.menuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.scrollPane, -2, 777, -2).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.scrollPane, -2, -1, -2)));
        this.pack();
    }

    private void inCircumferenceRadiusFocusGained(FocusEvent evt) {
        this.circumferenceRadiusPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.circumferenceRadiusTitle);
        this.description.setText(this.circumferenceRadiusDescription);
    }

    private void inCircumferenceRadiusFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void circumferenceRadiusPanelFocusGained(FocusEvent evt) {
    }

    private void inCrossSectionFocusGained(FocusEvent evt) {
        this.crossSectionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.crossSectionTitle);
        this.description.setText(this.crossSectionDescription);
    }

    private void inCrossSectionFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesCirumferenceFocusGained(FocusEvent evt) {
        this.slicesCircumferencePanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.slicesCircumferenceTitle);
        this.description.setText(this.slicesCircumferenceDescription);
    }

    private void inSlicesCirumferenceFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void adjustForOverlappingPipeCutsFocusGained(FocusEvent evt) {
        this.adjustForOverlappingPipeCutsPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.adjustForOverlappingPipeCutsTitle);
        this.description.setText(this.adjustForOverlappingPipeCutsDescription);
    }

    private void adjustForOverlappingPipeCutsFocusLost(FocusEvent evt) {
        this.adjustForOverlappingPipeCutsPanel.setBackground(this.normal);
    }

    private void inExtrudeRadiusFactorFocusGained(FocusEvent evt) {
        this.extrudeRadiusFactorPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.extrudeRadiusFactorTitle);
        this.description.setText(this.extrudeRadiusFactorDescription);
    }

    private void inExtrudeRadiusFactorFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void generateActionPerformed(ActionEvent evt) {
        this.generate.setEnabled(false);
        if (this.opNormal.isSelected() || this.opOverlapping.isSelected()) {
            String[] args = new String[]{this.inCircumferenceRadius.getText(), this.inSlopeRadius.getText(), this.inSlicesCirumference.getText(), this.inSlicesSlope.getText(), this.inCrossSection.getText(), Boolean.toString(this.offsetTop.isSelected()), Boolean.toString(this.opOverlapping.isSelected()), this.inExtrudeTopNSlices.getText(), this.inExtrudeRadiusFactor.getText(), Boolean.toString(this.adjustForOverlappingPipeCuts.isSelected()), Boolean.toString(this.adjustForOverlappingBowlCuts.isSelected()), Boolean.toString(this.generateOnlySeam.isSelected()), Boolean.toString(this.adjustForOverlappingBowlCuts.isSelected()), Boolean.toString(this.adjustSeamForJoining.isSelected())};
            this.status.setText("Generating bowl...");
            BowlGenerator.main(args);
        }
        this.status.setText("Generated - select save file name and location");
        JFileChooser chooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Quake Map File (.map)", "map");
        chooser.setFileFilter(filter);
        File saveFile = null;
        String filename = null;
        boolean save = true;
        while (save) {
            int returnValue;
            if (this.configuration.getWorkingDirectory() != null && this.configuration.getWorkingDirectory().isDirectory()) {
                chooser.setCurrentDirectory(this.configuration.getWorkingDirectory());
            }
            if ((returnValue = chooser.showSaveDialog(this)) == 1 || returnValue == -1) {
                save = false;
            } else {
                saveFile = chooser.getSelectedFile();
                filename = saveFile.getAbsolutePath();
                if (!filename.endsWith(".map")) {
                    filename = filename + ".map";
                }
                if ((saveFile = new File(filename)).exists()) {
                    Object[] buttons = new Object[]{"Cancel", "No", "Yes"};
                    int response = JOptionPane.showOptionDialog(this, "Overwrite " + filename + " ?", "Confirm Overwrite", 2, 0, null, buttons, buttons[1]);
                    if (response == 1) continue;
                    if (response == 0) {
                        save = false;
                    }
                }
            }
            if (save) {
                this.status.setText("Saving...");
                MapFactory.saveText(filename);
                this.statusPanel.setBackground(Color.green);
                this.status.setText("Save successful\n" + filename);
                this.configuration.setWorkingDirectory(saveFile.getParentFile());
                save = false;
                continue;
            }
            this.status.setText("Save Cancelled");
        }
    }

    private void adjustForOverlappingPipeCutsActionPerformed(ActionEvent evt) {
    }

    private void opOverlappingFocusLost(FocusEvent evt) {
        this.overlappingBrushOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void opOverlappingFocusGained(FocusEvent evt) {
        this.overlappingBrushOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opOverlappingTitle);
        this.description.setText(this.opOverlappingDescription);
    }

    private void opOverlappingActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void normalOptionPanelFocusLost(FocusEvent evt) {
    }

    private void opNormalFocusLost(FocusEvent evt) {
        this.normalOptionPanel.setBackground(this.normal);
        this.checkGenerateOK();
    }

    private void opNormalFocusGained(FocusEvent evt) {
        this.checkGenerateOK();
        this.normalOptionPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.opNormalTitle);
        this.description.setText(this.opNormalDescription);
    }

    private void opNormalActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inExtrudeTopNSlicesFocusGained(FocusEvent evt) {
        this.extrudeTopNSlicesPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.extrudeTopNSlicesTitle);
        this.description.setText(this.extrudeTopNSlicesDescription);
    }

    private void inExtrudeTopNSlicesFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void adjustForOverlappingBowlCutsFocusGained(FocusEvent evt) {
        this.adjustForOverlappingBowlCutsPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.adjustForOverlappingBowlCutsTitle);
        this.description.setText(this.adjustForOverlappingBowlCutsDescription);
    }

    private void adjustForOverlappingBowlCutsFocusLost(FocusEvent evt) {
        this.adjustForOverlappingBowlCutsPanel.setBackground(this.normal);
    }

    private void inSlopeRadiusFocusGained(FocusEvent evt) {
        this.slopeRadiusPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.slopeRadiusTitle);
        this.description.setText(this.slopeRadiusDescription);
    }

    private void inSlopeRadiusFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void slopeRadiusPanelFocusGained(FocusEvent evt) {
    }

    private void adjustSeamForJoiningFocusGained(FocusEvent evt) {
        this.adjustSeamForJoiningPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.adjustSeamForJoiningTitle);
        this.description.setText(this.adjustSeamForJoiningDescription);
    }

    private void adjustSeamForJoiningFocusLost(FocusEvent evt) {
        this.adjustSeamForJoiningPanel.setBackground(this.normal);
    }

    private void generateOnlySeamFocusGained(FocusEvent evt) {
        this.generateOnlySeamPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.generateOnlySeamTitle);
        this.description.setText(this.generateOnlySeamDescription);
    }

    private void generateOnlySeamFocusLost(FocusEvent evt) {
        this.generateOnlySeamPanel.setBackground(this.normal);
    }

    private void inSlicesSlopeFocusLost(FocusEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesSlopeFocusGained(FocusEvent evt) {
        this.slicesSlopePanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.slicesSlopeTitle);
        this.description.setText(this.slicesSlopeDescription);
    }

    private void generateOnlySeamActionPerformed(ActionEvent evt) {
    }

    private void offsetTopFocusGained(FocusEvent evt) {
        this.offsetTopPanel.setBackground(this.shaded);
        this.descriptionTitle.setText(this.offsetTopTitle);
        this.description.setText(this.offsetTopDescription);
    }

    private void offsetTopFocusLost(FocusEvent evt) {
        this.offsetTopPanel.setBackground(this.normal);
    }

    private void inLipOffsetFocusLost(FocusEvent evt) {
        this.status.setText("");
        try {
            int temp = Integer.parseInt(this.inLipOffset.getText());
            if (temp < 0) {
                throw new Exception("lipOffset cannot be negative");
            }
            this.calculatorOptionPanel.setBackground(this.normal);
            this.calculatorStatusPanel.setBackground(this.normal);
            this.calculate.setEnabled(true);
        }
        catch (Exception ex) {
            this.calculate.setEnabled(false);
            if (ex instanceof NumberFormatException) {
                this.calculatorStatus.setText("Please enter a number");
            } else {
                this.calculatorStatus.setText(ex.getMessage());
            }
            this.calculatorOptionPanel.setBackground(Color.red);
            this.calculatorStatusPanel.setBackground(Color.yellow);
        }
    }

    private void inLipOffsetPropertyChange(PropertyChangeEvent evt) {
    }

    private void inLipOffsetKeyPressed(KeyEvent evt) {
    }

    private void inLipOffsetKeyTyped(KeyEvent evt) {
    }

    private void calculateActionPerformed(ActionEvent evt) {
        String[] args = new String[]{this.inSlopeRadius.getText(), this.inSlicesSlope.getText(), this.inExtrudeTopNSlices.getText(), this.inLipOffset.getText()};
        this.inExtrudeRadiusFactor.setText(Double.toString(ExtrudeRadiusFactorCalculator.calculate(args)));
        this.calculateExtrudeRadiusPopup.setVisible(false);
    }

    private void calculateExtrudeRadiusFactorActionPerformed(ActionEvent evt) {
        this.calculateExtrudeRadiusPopup.setVisible(true);
    }

    private void inExtrudeRadiusFactorActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inCircumferenceRadiusActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlopeRadiusActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesCirumferenceActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inSlicesSlopeActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inCrossSectionActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inExtrudeTopNSlicesActionPerformed(ActionEvent evt) {
        this.checkGenerateOK();
    }

    private void inLipOffsetActionPerformed(ActionEvent evt) {
        this.status.setText("");
        try {
            int temp = Integer.parseInt(this.inLipOffset.getText());
            if (temp < 0) {
                throw new Exception("lipOffset cannot be negative");
            }
            this.calculatorOptionPanel.setBackground(this.normal);
            this.calculatorStatusPanel.setBackground(this.normal);
            this.calculate.setEnabled(true);
        }
        catch (Exception ex) {
            this.calculate.setEnabled(false);
            if (ex instanceof NumberFormatException) {
                this.calculatorStatus.setText("Please enter a number");
            } else {
                this.calculatorStatus.setText(ex.getMessage());
            }
            this.calculatorOptionPanel.setBackground(Color.red);
            this.calculatorStatusPanel.setBackground(Color.yellow);
        }
    }

    private void checkGenerateOK() {
        int temp;
        boolean generateOK = true;
        boolean calculateOK = true;
        this.statusPanel.setBackground(this.normal);
        this.status.setText("");
        String statusText = "";
        try {
            temp = Integer.parseInt(this.inCircumferenceRadius.getText());
            if (temp <= 0) {
                throw new Exception("circumferenceRadius must be positive");
            }
            if (temp < this.slopeRadius) {
                throw new Exception("circumferenceRadius must be greater than or equalto slopeRadius");
            }
            this.circumferenceRadius = temp;
            this.circumferenceRadiusPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.circumferenceRadiusPanel.setBackground(Color.red);
        }
        try {
            temp = Integer.parseInt(this.inSlopeRadius.getText());
            if (temp < 0) {
                throw new Exception("slopeRadius cannot be negative");
            }
            if (temp > this.circumferenceRadius) {
                throw new Exception("slopeRadius must be less than or equal to circumferenceRadius");
            }
            this.slopeRadius = temp;
            this.slopeRadiusPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            calculateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.slopeRadiusPanel.setBackground(Color.red);
        }
        try {
            int temp2 = Integer.parseInt(this.inSlicesCirumference.getText());
            if (temp2 < 1) {
                throw new Exception("Min slices is 1");
            }
            this.slicesCircumferencePanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.slicesCircumferencePanel.setBackground(Color.red);
        }
        try {
            int temp3 = Integer.parseInt(this.inSlicesSlope.getText());
            if (temp3 < 1) {
                throw new Exception("Min slices is 1");
            }
            this.slicesSlopePanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.slicesSlopePanel.setBackground(Color.red);
        }
        try {
            int temp4 = Integer.parseInt(this.inExtrudeTopNSlices.getText());
            if (temp4 <= 0) {
                calculateOK = false;
                this.labExtrudeRadiusFactor.setEnabled(false);
                this.inExtrudeRadiusFactor.setEnabled(false);
            } else {
                this.labExtrudeRadiusFactor.setEnabled(true);
                this.inExtrudeRadiusFactor.setEnabled(true);
            }
            if (temp4 < 0) {
                throw new Exception("ExtrudeTopNSlices cannot be negative");
            }
            this.extrudeTopNSlicesPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            calculateOK = false;
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.extrudeTopNSlicesPanel.setBackground(Color.red);
        }
        try {
            double temp5 = Double.parseDouble(this.inExtrudeRadiusFactor.getText());
            if (temp5 < 0.0) {
                throw new Exception("Please enter a positive number");
            }
            this.extrudeRadiusFactorPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            statusText = ex.getMessage().startsWith("For input String:") ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.extrudeRadiusFactorPanel.setBackground(Color.red);
        }
        try {
            int temp6 = Integer.parseInt(this.inCrossSection.getText());
            if (temp6 <= 0) {
                throw new Exception("inCrossSection cannot be negative");
            }
            this.crossSectionPanel.setBackground(this.normal);
        }
        catch (Exception ex) {
            generateOK = false;
            this.statusPanel.setBackground(Color.yellow);
            statusText = ex instanceof NumberFormatException ? statusText + "Please enter a number\n" : statusText + ex.getMessage() + "\n";
            this.crossSectionPanel.setBackground(Color.red);
        }
        if (generateOK) {
            this.generate.setEnabled(true);
        } else {
            this.generate.setEnabled(false);
            this.statusPanel.setBackground(Color.yellow);
            this.status.setText(statusText);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(BowlGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(BowlGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(BowlGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(BowlGeneratorGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new BowlGeneratorGUI(new Config()).setVisible(true);
            }
        });
    }
}

