/*
 * Decompiled with CFR 0.152.
 */
package generators;

import com.nerius.math.geom.Point3D;
import generators.GenerationUtils;

public final class PipeShinglesGenerator
extends GenerationUtils {
    public static void main(String[] args) {
        Thread.currentThread().setPriority(1);
        int radius = Integer.parseInt(args[0]);
        int slices = Integer.parseInt(args[1]);
        int length = Integer.parseInt(args[2]);
        int extrudeTopNSlices = Integer.parseInt(args[3]);
        double extrudeRadiusFactor = Double.parseDouble(args[4]);
        boolean adjustForOverlappingPipeCuts = Boolean.valueOf(args[5]);
        boolean adjustForOverlappingBowlCuts = Boolean.valueOf(args[6]);
        int shinglesType = Integer.parseInt(args[7]);
        int adjustMask = 0;
        if (adjustForOverlappingBowlCuts) {
            adjustMask |= 2;
        }
        if (adjustForOverlappingPipeCuts) {
            adjustMask |= 1;
        }
        Point3D[] curve = PipeShinglesGenerator.generatePipeCurve(radius, slices, extrudeTopNSlices, extrudeRadiusFactor, adjustMask);
        PipeShinglesGenerator.startMap();
        if (shinglesType == 1) {
            PipeShinglesGenerator.writeBrushExtendY(length, curve[0], curve[1], new Point3D(curve[1].x - 1.0, curve[1].y, curve[1].z), new Point3D(curve[0].x - 1.0, curve[0].y, curve[0].z));
            for (int i = 1; i < slices; ++i) {
                if (!(curve[i].z > curve[i + 1].z)) continue;
                PipeShinglesGenerator.writeBrushExtendY(length, curve[i], curve[i + 1], new Point3D(curve[i + 1].x - 1.0, curve[i + 1].y, curve[i + 1].z), false);
            }
        } else if (shinglesType == 2) {
            for (int i = 0; i < slices; ++i) {
                if (!(curve[i].z > curve[i + 1].z)) continue;
                PipeShinglesGenerator.writeBrushExtendY(length, curve[i], curve[i + 1], new Point3D(curve[i + 1].x - 1.0, curve[i + 1].y, curve[i + 1].z), false);
            }
        } else {
            int i;
            for (i = 0; i < slices / 2; ++i) {
                PipeShinglesGenerator.writeBrushExtendY(length, curve[i], curve[i + 1], new Point3D(curve[i + 1].x - 1.0, curve[i + 1].y, curve[i + 1].z), false);
            }
            for (i = slices / 2; i < slices; ++i) {
                PipeShinglesGenerator.writeBrushExtendY(length, curve[i], curve[i + 1], new Point3D(curve[i + 1].x, curve[i + 1].y, curve[i + 1].z + 1.0), false);
            }
        }
        PipeShinglesGenerator.endMap();
    }
}

