/*
 * Decompiled with CFR 0.152.
 */
package generators;

import com.nerius.math.geom.Point3D;
import com.nerius.math.xform.AxisRotation3D;
import generators.GenerationUtils;

public final class CylinderGenerator
extends GenerationUtils {
    public static void main(String[] args) {
        int i;
        Thread.currentThread().setPriority(1);
        int outerRadius = Integer.parseInt(args[0]);
        int innerRadius = Integer.parseInt(args[1]);
        int slices = Integer.parseInt(args[2]);
        int height = Integer.parseInt(args[3]);
        boolean overlappingBrushes = Boolean.valueOf(args[4]);
        boolean adjustForOverlappingCylinderCuts = Boolean.valueOf(args[5]);
        double offsetAngle = Double.parseDouble(args[6]);
        Point3D[] outerCurve = CylinderGenerator.generatePipeCurve(outerRadius, slices, 0, 0.0, adjustForOverlappingCylinderCuts ? 1 : 0);
        Point3D[] innerCurve = CylinderGenerator.generatePipeCurve(innerRadius, slices, 0, 0.0, adjustForOverlappingCylinderCuts ? 1 : 0);
        AxisRotation3D rot = new AxisRotation3D(1, 1.5707963267948966);
        for (i = 0; i <= slices; ++i) {
            outerCurve[i] = rot.transform(outerCurve[i]);
            innerCurve[i] = rot.transform(innerCurve[i]);
        }
        if (offsetAngle != 0.0) {
            double radians = Math.PI * offsetAngle / 180.0;
            rot = new AxisRotation3D(4, radians);
            for (int i2 = 0; i2 <= slices; ++i2) {
                outerCurve[i2] = rot.transform(outerCurve[i2]);
                innerCurve[i2] = rot.transform(innerCurve[i2]);
            }
        }
        CylinderGenerator.startMap();
        for (i = 0; i < slices; ++i) {
            Point3D pt3;
            Point3D pt2;
            if ((double)innerRadius == 0.0) {
                CylinderGenerator.writeBrushExtendZ(-height, outerCurve[i], innerCurve[i], outerCurve[i + 1], false);
                continue;
            }
            Point3D pt1 = outerCurve[i];
            Point3D pt4 = outerCurve[i + 1];
            if (!overlappingBrushes) {
                pt2 = innerCurve[i];
                pt3 = innerCurve[i + 1];
            } else {
                double pt2x = Math.round(innerCurve[i].x);
                double pt2y = Math.round(innerCurve[i].y);
                double pt3x = Math.round(innerCurve[i + 1].x);
                double pt3y = Math.round(innerCurve[i + 1].y);
                double z = innerCurve[i].z;
                pt2 = new Point3D(pt2x + (pt2x - pt3x), pt2y + (pt2y - pt3y), z);
                pt3 = new Point3D(pt3x + (pt3x - pt2x), pt3y + (pt3y - pt2y), z);
            }
            CylinderGenerator.writeBrushExtendZ(-height, pt1, pt2, pt3, pt4);
        }
        CylinderGenerator.endMap();
    }
}

