/*
 * Decompiled with CFR 0.152.
 */
package generators;

import com.nerius.math.geom.Point3D;
import com.nerius.math.xform.AxisRotation3D;
import generators.GenerationUtils;

public final class CorkscrewCapGenerator
extends GenerationUtils {
    private static final double OFFSET_FUDGE_FACTOR = 0.95;
    private static final double OFFSET_NUDGE_INCREMENT = 0.1;

    public static void main(String[] args) {
        int i;
        Thread.currentThread().setPriority(1);
        int outerRadius = Integer.parseInt(args[0]);
        int altitude = Integer.parseInt(args[1]);
        int slices = Integer.parseInt(args[2]);
        int outerThickness = Integer.parseInt(args[3]);
        boolean adjustForOverlappingCylinderCuts = Boolean.valueOf(args[4]);
        Point3D[][] mesh = new Point3D[slices + 1][2];
        Point3D[] outerCurve = CorkscrewCapGenerator.generatePipeCurve(outerRadius, slices, 0, 0.0, adjustForOverlappingCylinderCuts ? 1 : 0);
        AxisRotation3D rot = new AxisRotation3D(1, 1.5707963267948966);
        for (int i2 = 0; i2 <= slices; ++i2) {
            outerCurve[i2] = rot.transform(outerCurve[i2]);
        }
        double stepsPerSlice = (double)altitude / (double)slices;
        for (int i3 = 0; i3 <= slices; ++i3) {
            mesh[i3][0] = new Point3D(outerCurve[i3].x, outerCurve[i3].y, outerCurve[i3].z + (double)i3 * stepsPerSlice);
            mesh[i3][1] = new Point3D(outerCurve[i3].x, outerCurve[i3].y, outerCurve[i3].z + (double)i3 * stepsPerSlice - (double)outerThickness);
        }
        Point3D[][] offsets = new Point3D[slices][2];
        for (i = 0; i < slices; ++i) {
            Point3D candidatePoint;
            double nudge = 0.0;
            while (true) {
                if (CorkscrewCapGenerator.sufficientOffset(mesh[i][0], mesh[i + 1][0], candidatePoint = new Point3D(mesh[i][0].x, mesh[i][0].y + nudge, mesh[i][0].z))) break;
                nudge += 0.1;
            }
            offsets[i][0] = candidatePoint;
            offsets[i][1] = new Point3D(mesh[i][1].x, mesh[i][1].y + nudge, mesh[i][1].z);
        }
        CorkscrewCapGenerator.startMap();
        CorkscrewCapGenerator.startBrush();
        CorkscrewCapGenerator.writeFace(mesh[0][1], mesh[0][0], new Point3D(mesh[0][0].x + 1.0, mesh[0][0].y, mesh[0][0].z));
        CorkscrewCapGenerator.writeFace(new Point3D(mesh[0][1].x + 1.0, mesh[0][1].y, mesh[0][1].z), new Point3D(mesh[0][0].x + 1.0, mesh[0][0].y, mesh[0][0].z), new Point3D(mesh[0][0].x + 1.0, mesh[0][0].y + 1.0, mesh[0][0].z));
        CorkscrewCapGenerator.writeFace(new Point3D(mesh[0][0].x + 1.0, mesh[0][0].y + 1.0, mesh[0][0].z), offsets[0][0], offsets[0][1]);
        CorkscrewCapGenerator.writeFace(mesh[0][0], mesh[0][1], offsets[0][1]);
        CorkscrewCapGenerator.writeFace(new Point3D(mesh[0][0].x + 1.0, mesh[0][0].y, mesh[0][0].z), mesh[0][0], offsets[0][0]);
        CorkscrewCapGenerator.writeFace(offsets[0][1], mesh[0][1], new Point3D(mesh[0][1].x + 1.0, mesh[0][1].y, mesh[0][1].z));
        CorkscrewCapGenerator.endBrush();
        for (i = 0; i < slices - 1; ++i) {
            CorkscrewCapGenerator.startBrush();
            CorkscrewCapGenerator.writeFace(mesh[i][1], mesh[i][0], offsets[i][0]);
            CorkscrewCapGenerator.writeFace(offsets[i][1], offsets[i][0], offsets[i + 1][0]);
            CorkscrewCapGenerator.writeFace(offsets[i + 1][0], mesh[i + 1][0], mesh[i + 1][1]);
            CorkscrewCapGenerator.writeFace(mesh[i + 1][0], mesh[i][0], mesh[i][1]);
            CorkscrewCapGenerator.writeFace(mesh[i][0], mesh[i + 1][0], offsets[i + 1][0]);
            CorkscrewCapGenerator.writeFace(offsets[i + 1][1], mesh[i + 1][1], mesh[i][1]);
            CorkscrewCapGenerator.endBrush();
        }
        CorkscrewCapGenerator.startBrush();
        CorkscrewCapGenerator.writeFace(mesh[slices - 1][1], mesh[slices - 1][0], offsets[slices - 1][0]);
        CorkscrewCapGenerator.writeFace(mesh[slices][0], mesh[slices - 1][0], mesh[slices - 1][1]);
        CorkscrewCapGenerator.writeFace(offsets[slices - 1][0], mesh[slices][0], mesh[slices][1]);
        CorkscrewCapGenerator.writeFace(offsets[slices - 1][0], mesh[slices - 1][0], mesh[slices][0]);
        CorkscrewCapGenerator.writeFace(offsets[slices - 1][1], mesh[slices][1], mesh[slices - 1][1]);
        CorkscrewCapGenerator.endBrush();
        CorkscrewCapGenerator.endMap();
    }

    private static boolean sufficientOffset(Point3D base, Point3D ptA, Point3D ptB) {
        double vecALen;
        Point3D vecB;
        base = new Point3D(Math.round(base.x), Math.round(base.y), 0.0);
        ptA = new Point3D(Math.round(ptA.x), Math.round(ptA.y), 0.0);
        ptB = new Point3D(Math.round(ptB.x), Math.round(ptB.y), 0.0);
        Point3D vecA = ptA.subtract(base);
        Point3D xProd = vecA.crossProduct(vecB = ptB.subtract(base));
        double xProdLen = xProd.distanceFromOrigin();
        return xProdLen / (vecALen = vecA.distanceFromOrigin()) >= 0.95;
    }
}

