unit FileId;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ShellApi;

type
  TFormFileId = class(TForm)
    MemoEdit: TMemo;
    BtnOK: TButton;
    BtnLoad: TButton;
    BtnSave: TButton;
    BtnClear: TButton;
    LabelRuler2: TLabel;
    LabelRuler1: TLabel;
    LabelWhat: TLabel;
    CBDefault: TCheckBox;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    Label1: TLabel;
    procedure LabelWhatClick(Sender: TObject);
    procedure BtnLoadClick(Sender: TObject);
    procedure BtnSaveClick(Sender: TObject);
    procedure BtnClearClick(Sender: TObject);
    procedure BtnOKClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormFileId: TFormFileId;

implementation

{$R *.dfm}

uses
   Main;

{==============================================================================}
procedure TFormFileId.LabelWhatClick(Sender: TObject);
begin
  ShellExecute(Application.Handle,
               PChar('open'),
               PChar('http://www.a-direct.com/fileid.html'),
               PChar(''),
               nil,
               SW_NORMAL);
end;

{==============================================================================}
procedure TFormFileId.BtnLoadClick(Sender: TObject);
begin
   with OpenDialog do
   begin
      Title := 'Open...';
      InitialDir := MyDir;
      FileName := '';
      Filter := 'Text Files (*.txt)|*.txt|All Files (*.*)|*.*';
      DefaultExt := 'txt';
      OptionsEx := OptionsEx + [ofExNoPlacesBar];
   end;
   if OpenDialog.Execute then
   begin
      MemoEdit.Lines.LoadFromFile(OpenDialog.FileName);
   end;
end;

{==============================================================================}
procedure TFormFileId.BtnSaveClick(Sender: TObject);
begin
   with SaveDialog do
   begin
      Title := 'Save to...';
      InitialDir := MyDir;
      Filter := 'Text Files (*.txt)|*.txt|All Files (*.*)|*.*';
      DefaultExt := 'txt';
      Options := Options + [ofOverwritePrompt];
      OptionsEx := OptionsEx + [ofExNoPlacesBar];
   end;

   if SaveDialog.Execute then
   begin
      MemoEdit.Lines.SaveToFile(SaveDialog.FileName);
   end;
end;

{==============================================================================}
procedure TFormFileId.BtnClearClick(Sender: TObject);
begin
   MemoEdit.Clear;
end;

{==============================================================================}
procedure TFormFileId.BtnOKClick(Sender: TObject);
begin
   if CBDefault.Checked then
   begin
      MemoEdit.Lines.SaveToFile(MyDir+'\'+'File_Id.Def');
   end;
   ModalResult := mrOK;
end;

{==============================================================================}
procedure TFormFileId.FormCreate(Sender: TObject);
begin
   if FileExists(Mydir+'\File_Id.def') then
   begin
      MemoEdit.Lines.LoadFromFile(MyDir+'\File_Id.def');
   end;
end;

end.
