/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.entdata;

import com.technofovea.hl2parse.entdata.EntdataException;
import com.technofovea.hl2parse.vdf.VdfAttribute;
import com.technofovea.hl2parse.vdf.VdfNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapEntity {
    private static final Logger logger = LoggerFactory.getLogger(MapEntity.class);
    static String KEY_CLASS = "classname";
    static String KEY_ID = "hammerid";
    protected String entityClass = null;
    protected int hammerId = -1;
    protected Map<String, List<String>> attrs = new HashMap<String, List<String>>();

    public static List<MapEntity> fromVdf(VdfNode rootNode) throws EntdataException {
        ArrayList<MapEntity> entities = new ArrayList<MapEntity>();
        for (VdfNode entNode : rootNode.getChildren()) {
            MapEntity e = new MapEntity(entNode);
            entities.add(e);
        }
        return entities;
    }

    public MapEntity(Map<String, List<String>> attributes) throws EntdataException {
        if (!attributes.containsKey(KEY_CLASS)) {
            throw new EntdataException("No class-name specified for entity");
        }
        if (attributes.get(KEY_CLASS).size() >= 1) {
            throw new EntdataException("No class-name specified for entity");
        }
        this.entityClass = attributes.remove(KEY_CLASS).get(0).toLowerCase().trim();
        for (String key : attributes.keySet()) {
            key = key.trim().toLowerCase();
            List<String> vals = attributes.get(key);
            if (key.equalsIgnoreCase(KEY_ID)) {
                try {
                    this.hammerId = Integer.parseInt(vals.get(0).toLowerCase());
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new EntdataException("Invalid hammer ID: " + vals);
                }
            }
            if (vals.size() <= 0) continue;
            this.attrs.put(key, vals);
        }
    }

    public MapEntity(VdfNode entityNode) throws EntdataException {
        if (entityNode.getChildren().size() > 0) {
            throw new EntdataException("Entity nodes may not have child blocks, but " + entityNode.getChildren().size() + " found.");
        }
        for (VdfAttribute attr : entityNode.getAttributes()) {
            String key = attr.getName().toLowerCase().trim();
            String val = attr.getValue();
            if (key.equalsIgnoreCase(KEY_CLASS)) {
                this.entityClass = val.toLowerCase();
                continue;
            }
            if (key.equalsIgnoreCase(KEY_ID)) {
                try {
                    this.hammerId = Integer.parseInt(val.toLowerCase());
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new EntdataException("Invalid hammer ID: " + val);
                }
            }
            if (!this.attrs.containsKey(key)) {
                this.attrs.put(key, new ArrayList());
            }
            this.attrs.get(key).add(val);
        }
        if (this.entityClass == null) {
            throw new EntdataException("No entity class found");
        }
        if (this.hammerId == -1) {
            // empty if block
        }
    }

    public String getEntityClass() {
        return this.entityClass;
    }

    public int getHammerId() {
        return this.hammerId;
    }

    public Set<String> getKeys() {
        return new HashSet<String>(this.attrs.keySet());
    }

    public boolean containsKey(String propertyName) {
        return this.attrs.containsKey(propertyName);
    }

    public List<String> getValues(String propertyName) {
        return new ArrayList<String>((Collection)this.attrs.get(propertyName));
    }
}

