/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.vdf;

import com.technofovea.hl2parse.JxPathUtil;
import com.technofovea.hl2parse.vdf.VdfRoot;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.jxpath.JXPathContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropDataReader {
    private static final Logger logger = LoggerFactory.getLogger(PropDataReader.class);
    VdfRoot root;
    JXPathContext context;

    public PropDataReader(VdfRoot rootNode) {
        this.root = rootNode;
        this.context = JXPathContext.newContext((Object)this.root);
        JxPathUtil.addFunctions(this.context);
    }

    public List<String> getRagdollModels() {
        Iterator allSnds = this.context.iterate("children[custom:equals(name,'break')]/attributes[custom:equals(name,'ragdoll')]/value");
        ArrayList<String> ret = new ArrayList<String>();
        while (allSnds.hasNext()) {
            String path = (String)allSnds.next();
            ret.add("models/" + path + ".mdl");
        }
        return ret;
    }

    public List<String> getRigidGibModels() {
        Iterator allSnds = this.context.iterate("children[custom:equals(name,'break')]/attributes[custom:equals(name,'model')]/value");
        ArrayList<String> ret = new ArrayList<String>();
        while (allSnds.hasNext()) {
            String path = (String)allSnds.next();
            ret.add(path);
        }
        return ret;
    }

    public Set<String> getAllGibs() {
        HashSet<String> ret = new HashSet<String>();
        ret.addAll(this.getRagdollModels());
        ret.addAll(this.getRigidGibModels());
        return ret;
    }
}

