/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.fgd;

import com.technofovea.hl2parse.fgd.FgdInput;
import com.technofovea.hl2parse.fgd.FgdOutput;
import com.technofovea.hl2parse.fgd.FgdProperty;
import com.technofovea.hl2parse.fgd.FgdSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FgdEntClass {
    public static final String INHERITANCE_MODIFIER = "base";
    private static final Logger logger = LoggerFactory.getLogger(FgdEntClass.class);
    String type;
    String description = "";
    Map<String, List<String>> modifiers = new HashMap<String, List<String>>();
    Map<String, FgdProperty> props = new HashMap<String, FgdProperty>();
    Map<String, FgdInput> inputs = new HashMap<String, FgdInput>();
    Map<String, FgdOutput> outputs = new HashMap<String, FgdOutput>();

    static String quoteModifierVal(String type, String val) {
        if ("studio".equalsIgnoreCase(type)) {
            return "\"" + type + "\"";
        }
        if ("studioprop".equalsIgnoreCase(type)) {
            return "\"" + type + "\"";
        }
        if ("sprite".equalsIgnoreCase(type)) {
            return "\"" + type + "\"";
        }
        if ("lightprop".equalsIgnoreCase(type)) {
            return "\"" + type + "\"";
        }
        return val;
    }

    public String toText(String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("@");
        sb.append(this.type);
        sb.append(" ");
        for (String modName : this.modifiers.keySet()) {
            List<String> values = this.modifiers.get(modName);
            sb.append(modName);
            sb.append("(");
            for (int i = 0; i < values.size(); ++i) {
                sb.append(FgdEntClass.quoteModifierVal(modName, values.get(i)));
                if (i + 1 == values.size()) continue;
                sb.append(",");
            }
            sb.append(")");
        }
        sb.append(" = ");
        sb.append(name);
        if (!"".equals(this.description)) {
            sb.append(" :\n");
            sb.append("\"");
            sb.append(this.description);
            sb.append("\"");
        }
        sb.append(" [\n");
        for (String pName : this.props.keySet()) {
            FgdProperty prop = this.props.get(pName);
            sb.append(prop.toText(pName));
            sb.append("\n");
        }
        for (String iName : this.inputs.keySet()) {
            FgdInput input = this.inputs.get(iName);
            sb.append(input.toText(iName));
            sb.append("\n");
        }
        for (String oName : this.outputs.keySet()) {
            FgdOutput output = this.outputs.get(oName);
            sb.append(output.toText(oName));
            sb.append("\n");
        }
        sb.append("]\n");
        return sb.toString();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if ((type = FgdSpec.cleanQuotes(type)).startsWith("@")) {
            type = type.substring(1);
        }
        this.type = type;
    }

    void addModifier(String name, List<String> values) {
        if (values == null) {
            values = new ArrayList<String>();
        }
        ArrayList<String> cleaned = new ArrayList<String>();
        for (String item : values) {
            cleaned.add(FgdSpec.cleanQuotes(item));
        }
        this.modifiers.put(name.toLowerCase(), cleaned);
    }

    void setDescription(String str) {
        this.description = FgdSpec.cleanQuotes(str);
    }

    public String getDescription() {
        return this.description;
    }

    public void addProp(String name, FgdProperty prop) {
        this.props.put(name, prop);
    }

    public void addInput(String name, FgdInput input) {
        this.inputs.put(name, input);
    }

    public void addOutput(String name, FgdOutput output) {
        this.outputs.put(name, output);
    }

    public Map<String, FgdInput> getInputs() {
        return this.inputs;
    }

    public Map<String, List<String>> getModifiers() {
        return this.modifiers;
    }

    public Map<String, FgdOutput> getOutputs() {
        return this.outputs;
    }

    public Map<String, FgdProperty> getProps() {
        return this.props;
    }

    List<FgdEntClass> getDirectParents(FgdSpec spec) {
        if (!this.modifiers.containsKey(INHERITANCE_MODIFIER)) {
            return new ArrayList<FgdEntClass>();
        }
        List<String> parentNames = this.modifiers.get(INHERITANCE_MODIFIER);
        ArrayList<FgdEntClass> parentObjects = new ArrayList<FgdEntClass>();
        for (String n : parentNames) {
            FgdEntClass p = spec.getEntClass(n);
            if (p != null) {
                parentObjects.add(p);
                continue;
            }
            logger.error("Specified parent {} is missing from specification.", (Object)n);
        }
        return parentObjects;
    }

    List<FgdEntClass> getAncestry(FgdSpec spec) {
        ArrayList<FgdEntClass> ancestry = new ArrayList<FgdEntClass>();
        ancestry.add(this);
        this.appendAncestry(ancestry, spec);
        return ancestry;
    }

    protected void appendAncestry(List<FgdEntClass> ancestry, FgdSpec spec) {
        List<FgdEntClass> parents = this.getDirectParents(spec);
        for (int i = parents.size() - 1; i >= 0; --i) {
            FgdEntClass p = parents.get(i);
            if (ancestry.contains(p)) {
                logger.trace("Ancestry already contains element {}, skipping.", (Object)p);
                return;
            }
            ancestry.add(p);
            p.appendAncestry(ancestry, spec);
        }
    }

    public FgdEntClass getInherited(FgdSpec spec) {
        List<FgdEntClass> ancestry = this.getAncestry(spec);
        FgdEntClass inherited = new FgdEntClass();
        inherited.setType(this.getType());
        inherited.setDescription(this.getDescription());
        Collections.reverse(ancestry);
        for (FgdEntClass ancestor : ancestry) {
            inherited.props.putAll(ancestor.props);
            inherited.modifiers.putAll(ancestor.modifiers);
            inherited.outputs.putAll(ancestor.outputs);
            inherited.inputs.putAll(ancestor.inputs);
        }
        inherited.modifiers.remove(INHERITANCE_MODIFIER);
        return inherited;
    }
}

