/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.bsp;

import com.technofovea.hl2parse.Vector3f;
import com.technofovea.hl2parse.bsp.GameLumpHeader;
import java.nio.ByteBuffer;

public class GamePropSection {
    private Vector3f origin;
    private Vector3f rotation;
    private int propNameIndex;
    private int firstLeaf;
    private int leafCount;
    private byte solid;
    private byte flags;
    private int skin;
    private float fadeMinDist;
    private float fadeMaxDist;
    private Vector3f lightingOrigin;
    private float forcedFadeScale = 0.0f;
    private byte[] unknown1 = new byte[4];

    public GamePropSection(GameLumpHeader hdr, ByteBuffer buf) {
        this.origin = new Vector3f(buf);
        this.rotation = new Vector3f(buf);
        this.propNameIndex = buf.getShort();
        this.firstLeaf = buf.getShort();
        this.leafCount = buf.getShort();
        this.solid = buf.get();
        this.flags = buf.get();
        this.skin = buf.getInt();
        this.fadeMinDist = buf.getFloat();
        this.fadeMaxDist = buf.getFloat();
        this.lightingOrigin = new Vector3f(buf);
        if (hdr.getVersion() >= 5) {
            this.forcedFadeScale = buf.getFloat();
        }
        if (hdr.getVersion() >= 6) {
            buf.get(this.unknown1);
        }
    }

    public float getFadeMaxDist() {
        return this.fadeMaxDist;
    }

    public float getFadeMinDist() {
        return this.fadeMinDist;
    }

    public int getFirstLeaf() {
        return this.firstLeaf;
    }

    public byte getFlags() {
        return this.flags;
    }

    public float getForcedFadeScale() {
        return this.forcedFadeScale;
    }

    public int getLeafCount() {
        return this.leafCount;
    }

    public Vector3f getLightingOrigin() {
        return this.lightingOrigin;
    }

    public Vector3f getOrigin() {
        return this.origin;
    }

    public int getPropNameIndex() {
        return this.propNameIndex;
    }

    public Vector3f getRotation() {
        return this.rotation;
    }

    public int getSkin() {
        return this.skin;
    }

    public byte getSolid() {
        return this.solid;
    }

    public byte[] getUnknown1() {
        return this.unknown1;
    }
}

