/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.registry;

import com.technofovea.hl2parse.registry.BlobValue;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;

public class BlobRaw
extends BlobValue {
    ByteBuffer data;
    WeakReference<byte[]> byteVersion = null;

    public BlobRaw(String name, ByteBuffer realValue) {
        super(name);
        this.data = realValue.asReadOnlyBuffer();
    }

    public BlobValue.DataType getType() {
        return BlobValue.DataType.RAW;
    }

    public ByteBuffer asBuffer() {
        return this.data;
    }

    public synchronized byte[] getRaw() {
        byte[] cached = (byte[])this.byteVersion.get();
        if (cached != null) {
            return cached;
        }
        this.data.clear();
        byte[] raw = new byte[this.data.remaining()];
        this.data.get(raw);
        this.byteVersion = new WeakReference<byte[]>(raw);
        return raw;
    }
}

