/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.mdl;

import com.technofovea.hl2parse.ParseUtil;
import com.technofovea.hl2parse.Vector3f;
import com.technofovea.hl2parse.mdl.ModelFlag;
import com.technofovea.hl2parse.mdl.ModelParseException;
import com.technofovea.hl2parse.mdl.ModelSection;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelData {
    private static final Logger logger = LoggerFactory.getLogger(ModelData.class);
    Map<ModelSection, Integer> indexes = new HashMap<ModelSection, Integer>();
    Map<ModelSection, Integer> contentCounts = new HashMap<ModelSection, Integer>();
    ByteBuffer bb;
    int id = -1;
    int version = -1;
    int checksum = 0;
    String modelName = null;
    int dataLength = 0;
    BitSet flags = null;
    List<String> texturePaths = new ArrayList<String>();
    List<String> textureNames = new ArrayList<String>();
    Map<Integer, List<Integer>> skinTable = new HashMap<Integer, List<Integer>>();
    List<String> includeModels = new ArrayList<String>();
    private Vector3f eyeposition;
    private Vector3f illumposition;
    private Vector3f hull_min;
    private Vector3f hull_max;
    private Vector3f view_bbmin;
    private Vector3f view_bbmax;
    private float mass;
    private int contents;
    private int numskinfamilies;

    public ModelData(ByteBuffer bb) throws ModelParseException {
        this.bb = bb.slice();
        this.bb.order(ByteOrder.LITTLE_ENDIAN);
        logger.debug("Parsing model data, {} remaining", (Object)this.bb.remaining());
        try {
            this.load();
            this.fixPaths();
        }
        catch (BufferUnderflowException bue) {
            throw new ModelParseException(bue);
        }
    }

    private void load() {
        assert (this.bb.position() == 0);
        this.id = this.readInt();
        this.version = this.readInt();
        this.checksum = this.readInt();
        this.modelName = this.readString(64);
        this.dataLength = this.readInt();
        logger.debug("ID is {} ({}), version is {}, name is {}", new Object[]{ParseUtil.toAscii(this.id, true), this.id, this.version, this.modelName});
        this.eyeposition = new Vector3f(this.bb);
        this.illumposition = new Vector3f(this.bb);
        this.hull_min = new Vector3f(this.bb);
        this.hull_max = new Vector3f(this.bb);
        this.view_bbmin = new Vector3f(this.bb);
        this.view_bbmax = new Vector3f(this.bb);
        this.flags = ParseUtil.readBitset(this.bb, 4);
        this.loadCountAndIndex(ModelSection.BONE);
        this.loadCountAndIndex(ModelSection.BONECONTROLLER);
        this.loadCountAndIndex(ModelSection.HITBOXSET);
        this.loadCountAndIndex(ModelSection.LOCALANIM);
        this.loadCountAndIndex(ModelSection.LOCALSEQ);
        BitSet activitylistversion = ParseUtil.readBitset(this.bb, 4);
        int eventsindexed = this.readInt();
        this.loadCountAndIndex(ModelSection.TEXTURE);
        this.loadCountAndIndex(ModelSection.CDTEXTURE);
        this.loadCount(ModelSection.SKIN);
        this.numskinfamilies = this.readInt();
        this.loadIndex(ModelSection.SKIN);
        this.loadCountAndIndex(ModelSection.BODYPART);
        this.loadCountAndIndex(ModelSection.LOCALATTACHMENT);
        int numlocalnodes = this.readInt();
        this.loadIndex(ModelSection.LOCALNODE);
        this.loadIndex(ModelSection.LOCALNODENAME);
        this.loadCountAndIndex(ModelSection.FLEXDESC);
        this.loadCountAndIndex(ModelSection.FLEXCONTROLLER);
        this.loadCountAndIndex(ModelSection.FLEXRULE);
        this.loadCountAndIndex(ModelSection.IKCHAIN);
        this.loadCountAndIndex(ModelSection.MOUTH);
        this.loadCountAndIndex(ModelSection.LOCALPOSEPARAM);
        this.loadIndex(ModelSection.SURFACEPROP);
        this.loadIndex(ModelSection.KEYVALUE);
        this.loadCount(ModelSection.KEYVALUE);
        this.loadCountAndIndex(ModelSection.LOCALIKAUTOPLAYLOCK);
        this.mass = this.readFloat();
        this.contents = this.readInt();
        this.loadCountAndIndex(ModelSection.INCLUDEMODEL);
        int virtualModel = this.readInt();
        this.loadIndex(ModelSection.SZANIMBLOCKNAME);
        this.loadCountAndIndex(ModelSection.ANIMBLOCK);
        int animblockModel = this.readInt();
        this.loadIndex(ModelSection.BONETABLEBYNAME);
        int pVertexBase = this.readInt();
        int pIndexBase = this.readInt();
        byte constdirectionallightdot = this.readByte();
        byte rootLOD = this.readByte();
        byte numAllowedRootLODs = this.readByte();
        byte unused = this.readByte();
        int zero_frame_cache_index = this.readInt();
        this.loadCountAndIndex(ModelSection.FLEXCONTROLLERUI);
        int[] unused3 = this.readIntArray(2);
        this.loadIndex(ModelSection.STUDIOHDR2);
        int[] unused4 = this.readIntArray(1);
        assert (this.bb.position() == 408);
        int[] idxList = new int[this.indexes.size()];
        ArrayList<Integer> temp = new ArrayList<Integer>(this.indexes.values());
        Collections.sort(temp);
        for (int i = 0; i < temp.size(); ++i) {
            idxList[i] = temp.get(i);
        }
        if (this.indexes.get((Object)ModelSection.STUDIOHDR2) > 0) {
            // empty if block
        }
        int pos = this.bb.position();
        this.loadMaterialPaths();
        this.bb.position(pos);
        this.loadMaterialNames();
        this.bb.position(pos);
        this.loadSkinTable();
        this.bb.position(pos);
        this.loadIncludeModels();
        this.bb.position(pos);
        this.loadBodyParts();
        this.bb.position(pos);
    }

    private int readShort() {
        return this.bb.getShort();
    }

    private int readInt() {
        return this.bb.getInt();
    }

    private void loadCountAndIndex(ModelSection modelSection) {
        this.loadCount(modelSection);
        this.loadIndex(modelSection);
    }

    private void loadIndex(ModelSection modelSection) {
        this.indexes.put(modelSection, this.bb.getInt());
    }

    private void loadCount(ModelSection modelSection) {
        this.contentCounts.put(modelSection, this.bb.getInt());
    }

    private byte[] readBytes(int count) {
        byte[] ret = new byte[count];
        this.bb.get(ret);
        return ret;
    }

    private byte readByte() {
        return this.bb.get();
    }

    private float readFloat() {
        return this.bb.getFloat();
    }

    private String readString(int len) {
        return ParseUtil.readString(this.bb, len);
    }

    private int[] readIntArray(int size) {
        int[] ret = new int[size];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.bb.getInt();
        }
        return ret;
    }

    public String getModelName() {
        return ModelData.fixPath(this.modelName);
    }

    public boolean checkModelFlag(ModelFlag m) {
        return this.flags.get(m.getBitIndex());
    }

    static String fixPath(String origPath) {
        return origPath.replace("\\", "/");
    }

    public List<String> getTextureSearchPaths() {
        return Collections.unmodifiableList(this.texturePaths);
    }

    public List<String> getTextureNames() {
        return Collections.unmodifiableList(this.textureNames);
    }

    public int getSkinCount() {
        return this.numskinfamilies;
    }

    public List<String> getTexturesForSkin(int skinId) {
        if (!this.skinTable.containsKey(skinId)) {
            logger.error("Skin {} does not exist", (Object)skinId);
            return new ArrayList<String>();
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (int texId : this.skinTable.get(skinId)) {
            String matName = this.textureNames.get(texId);
            ret.add(matName);
        }
        return ret;
    }

    public List<String> getIncludedModels() {
        return Collections.unmodifiableList(this.includeModels);
    }

    private void loadSkinTable() {
        this.bb.position(this.indexes.get((Object)ModelSection.SKIN));
        logger.trace("Loading skin-family replacement tables at offset {}", (Object)this.bb.position());
        for (int i = 0; i < this.numskinfamilies; ++i) {
            ArrayList<Integer> targets = new ArrayList<Integer>();
            this.skinTable.put(i, targets);
            for (int j = 0; j < this.contentCounts.get((Object)ModelSection.SKIN); ++j) {
                int indexVal = this.readShort();
                targets.add(indexVal);
            }
        }
    }

    private void loadMaterialPaths() {
        this.bb.position(this.indexes.get((Object)ModelSection.CDTEXTURE));
        logger.trace("Loading material paths at offset {} ", (Object)this.bb.position());
        ArrayList<Integer> pathIndexes = new ArrayList<Integer>();
        for (int i = 0; i < this.contentCounts.get((Object)ModelSection.CDTEXTURE); ++i) {
            int stringStartIndex = this.readInt();
            pathIndexes.add(stringStartIndex);
        }
        Iterator i$ = pathIndexes.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            this.bb.position(i);
            String path = this.readString(256);
            this.texturePaths.add(path);
        }
    }

    private void loadMaterialNames() {
        this.bb.position(this.indexes.get((Object)ModelSection.TEXTURE));
        logger.trace("Loading material names at offset {}", (Object)this.bb.position());
        for (int i = 0; i < this.contentCounts.get((Object)ModelSection.TEXTURE); ++i) {
            int blockStartPos = this.bb.position();
            int relativeNameOffset = this.readInt();
            int lastPos = this.bb.position();
            this.bb.position(blockStartPos + relativeNameOffset);
            String name = this.readString(128);
            this.bb.position(lastPos);
            this.textureNames.add(name);
            int flags = this.readInt();
            int used = this.readInt();
            int unused1 = this.readInt();
            int matPtr = this.readInt();
            int clientMatPtr = this.readInt();
            int[] unused2 = this.readIntArray(10);
        }
    }

    private void loadIncludeModels() {
        this.bb.position(this.indexes.get((Object)ModelSection.INCLUDEMODEL));
        logger.trace("Loading {} include models at offset {}", (Object)this.contentCounts.get((Object)ModelSection.INCLUDEMODEL), (Object)this.bb.position());
        for (int i = 0; i < this.contentCounts.get((Object)ModelSection.INCLUDEMODEL); ++i) {
            int blockStartPos = this.bb.position();
            int descNameOffset = this.readInt();
            int fileNameOffset = this.readInt();
            int endPos = this.bb.position();
            this.bb.position(blockStartPos + descNameOffset);
            String descName = this.readString(128);
            this.bb.position(blockStartPos + fileNameOffset);
            String filename = this.readString(128);
            this.includeModels.add(filename);
            this.bb.position(endPos);
        }
    }

    private void loadBodyParts() {
        int startPos = this.indexes.get((Object)ModelSection.BODYPART);
        int count = this.contentCounts.get((Object)ModelSection.BODYPART);
        logger.trace("Loading {} bodyparts at offset {}", (Object)count, (Object)startPos);
        this.bb.position(startPos);
        for (int i = 0; i < count; ++i) {
            int structStartPos = this.bb.position();
            int name_offset = this.readInt();
            int numModels = this.readInt();
            int base = this.readInt();
            int model_offset = this.readInt();
            int prev = this.bb.position();
            this.bb.position(structStartPos + name_offset);
            String bodypartName = this.readString(256);
            this.bb.position(structStartPos + model_offset);
            this.bb.position(prev);
        }
    }

    private void fixPaths() {
        ArrayList<String> newPaths = new ArrayList<String>();
        for (String p : this.texturePaths) {
            String fixed = p.replace("\\", "/");
            fixed = fixed.replaceFirst("^/+", "");
            fixed = "materials/" + fixed;
            if (!fixed.endsWith("/")) {
                fixed = fixed + "/";
            }
            newPaths.add(fixed);
        }
        this.texturePaths = newPaths;
        ArrayList<String> newNames = new ArrayList<String>();
        for (String n : this.textureNames) {
            String fixed = n.replace("\\", "/");
            fixed = fixed.replaceAll("^/+", "");
            fixed = fixed + ".vmt";
            newNames.add(fixed);
        }
        this.textureNames = newNames;
    }
}

