/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.registry;

import com.technofovea.hl2parse.registry.BlobNode;
import java.nio.ByteBuffer;

public abstract class BlobValue
extends BlobNode {
    String name;

    public BlobValue(String name) {
        this.name = name;
    }

    public abstract DataType getType();

    public String getName() {
        return this.name;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataType {
        TEXT(0),
        DWORD(1),
        RAW(2);

        private int num;

        public static DataType fromNumber(int typeNum) {
            for (DataType t : DataType.values()) {
                if (t.getNumericCode() != typeNum) continue;
                return t;
            }
            return null;
        }

        public static DataType fromDescriptor(ByteBuffer meta) {
            byte typeNum = meta.get();
            return DataType.fromNumber(typeNum);
        }

        private DataType(int num) {
            this.num = num;
        }

        public int getNumericCode() {
            return this.num;
        }
    }
}

