/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.registry;

import com.technofovea.hl2parse.registry.BlobNode;
import com.technofovea.hl2parse.registry.BlobValue;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlobFolder
extends BlobNode {
    String name;
    Map<String, BlobFolder> folders = new HashMap<String, BlobFolder>();
    Map<String, BlobValue> values = new HashMap<String, BlobValue>();

    public BlobFolder(String name) {
        this.name = name;
    }

    public Map<String, BlobFolder> getFolders() {
        return this.folders;
    }

    public Map<String, BlobValue> getValues() {
        return this.values;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "{" + this.getName() + ":" + this.values.toString() + "," + this.folders.toString() + "}";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FolderItemType {
        FOLDER(1),
        FILE(2);

        private int num;

        public static FolderItemType fromNumber(int typeNum) {
            for (FolderItemType t : FolderItemType.values()) {
                if (t.getNumericCode() != typeNum) continue;
                return t;
            }
            return null;
        }

        public static FolderItemType fromDescriptor(ByteBuffer meta) {
            byte typeNum = meta.get();
            return FolderItemType.fromNumber(typeNum);
        }

        private FolderItemType(int num) {
            this.num = num;
        }

        public int getNumericCode() {
            return this.num;
        }
    }
}

