/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.vdf;

import com.technofovea.hl2parse.JxPathUtil;
import com.technofovea.hl2parse.vdf.VdfRoot;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.jxpath.JXPathContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameInfoReader {
    public static final String PLACEHOLDER_ALLSOURCE = "all_source_engine_paths";
    public static final String PLACEHOLDER_GAMEINFODIR = "gameinfo_path";
    public static final String PATH_DELIM = "|";
    public static final String DEFAULT_FILENAME = "gameinfo.txt";
    private static final Logger logger = LoggerFactory.getLogger(GameInfoReader.class);
    VdfRoot root;
    JXPathContext context;
    File sourceFile;

    public GameInfoReader(VdfRoot rootNode, File sourceFile) {
        this.sourceFile = sourceFile;
        this.root = rootNode;
        this.context = JXPathContext.newContext((Object)this.root);
        JxPathUtil.addFunctions(this.context);
    }

    public File getSourceFile() {
        return this.sourceFile;
    }

    public String getGameName() {
        return (String)this.context.getValue("children[custom:equals(name,'GameInfo')]/attributes[custom:equals(name,'game')]/value");
    }

    public int getSteamAppId() {
        String id = (String)this.context.getValue("children[custom:equals(name,'GameInfo')]/children[custom:equals(name,'FileSystem')]/attributes[custom:equals(name,'SteamAppId')]/value");
        return Integer.parseInt(id);
    }

    public List<String> getSearchPaths() {
        ArrayList<String> ret = new ArrayList<String>();
        Iterator iter = this.context.iterate("children[custom:equals(name,'GameInfo')]/children[custom:equals(name,'FileSystem')]/children[custom:equals(name,'SearchPaths')]/attributes[custom:equals(name,'game')]/value");
        while (iter.hasNext()) {
            ret.add((String)iter.next());
        }
        return ret;
    }

    public List<Integer> getAdditionalIds() {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        Iterator iter = this.context.iterate("children[custom:equals(name,'GameInfo')]/children[custom:equals(name,'FileSystem')]/attributes[custom:equals(name,'AdditionalContentId')]/value");
        while (iter.hasNext()) {
            ret.add(Integer.parseInt((String)iter.next()));
        }
        return ret;
    }
}

