/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.fgd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlagValue
implements Comparable<FlagValue> {
    private int intValue;
    private String name;
    private boolean defaultOn;

    public FlagValue(int intValue, String name, boolean defaultOn) {
        this.intValue = intValue;
        this.name = name;
        this.defaultOn = defaultOn;
    }

    public boolean isDefaultOn() {
        return this.defaultOn;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public String getName() {
        return this.name;
    }

    public String toText() {
        String ret = this.getIntValue() + ":\"" + this.getName() + "\":";
        ret = this.isDefaultOn() ? ret + "1" : ret + "0";
        return ret;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FlagValue other = (FlagValue)obj;
        if (this.intValue != other.intValue) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.defaultOn == other.defaultOn;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + this.intValue;
        hash = 59 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 59 * hash + (this.defaultOn ? 1 : 0);
        return hash;
    }

    @Override
    public int compareTo(FlagValue other) {
        int valueDifference = this.getIntValue() - other.getIntValue();
        if (valueDifference != 0) {
            return valueDifference;
        }
        return this.getName().compareTo(other.getName());
    }
}

