/*
 * Decompiled with CFR 0.152.
 */
package com.technofovea.hl2parse.entdata;

import com.technofovea.hl2parse.entdata.PathFixer;
import com.technofovea.hl2parse.entdata.ValueSource;

public class DefaultPathFixer
implements PathFixer {
    private static DefaultPathFixer instance;
    String nonPathPrefix = ":";

    private DefaultPathFixer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultPathFixer getInstance() {
        Class<DefaultPathFixer> clazz = DefaultPathFixer.class;
        synchronized (DefaultPathFixer.class) {
            if (instance == null) {
                instance = new DefaultPathFixer();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String fixPath(String origPath, ValueSource src) {
        if ("material".equalsIgnoreCase(src.getDataType())) {
            return this.fixMaterial(origPath, src);
        }
        if ("sound".equalsIgnoreCase(src.getDataType())) {
            return this.fixSound(origPath, src);
        }
        if ("sprite".equalsIgnoreCase(src.getDataType())) {
            return this.fixMaterial(origPath, src);
        }
        if ("decal".equalsIgnoreCase(src.getDataType())) {
            return this.fixMaterial(origPath, src);
        }
        if ("vtf".equalsIgnoreCase(src.getDataType())) {
            return this.fixTexture(origPath, src);
        }
        return origPath;
    }

    private String fixMaterial(String origPath, ValueSource src) {
        String path = origPath;
        if (!(path = path.replace("\\", "/")).toLowerCase().endsWith(".vmt") && !path.toLowerCase().endsWith(".spr")) {
            path = path + ".vmt";
        }
        if (!path.toLowerCase().startsWith("materials/")) {
            path = "materials/" + path;
        }
        return path;
    }

    private String fixTexture(String origPath, ValueSource src) {
        String path = origPath;
        if (!(path = path.replace("\\", "/")).toLowerCase().endsWith(".vtf")) {
            path = path + ".vtf";
        }
        if (!path.toLowerCase().startsWith("materials/")) {
            path = "materials/" + path;
        }
        return path;
    }

    private String fixSound(String origPath, ValueSource src) {
        String path = origPath;
        if (!(path = path.replace("\\", "/")).contains("/") && !path.toLowerCase().endsWith(".wav")) {
            return this.getNonPathPrefix() + origPath;
        }
        if (!path.toLowerCase().endsWith(".wav")) {
            path = path + ".wav";
        }
        if (!path.toLowerCase().startsWith("sound/")) {
            path = "sound/" + path;
        }
        return path;
    }

    public String getNonPathPrefix() {
        return this.nonPathPrefix;
    }

    public void setNonPathPrefix(String nonPathPrefix) {
        this.nonPathPrefix = nonPathPrefix;
    }
}

