#include <std.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <fnmatch.h>
#include <sys/stat.h>
#include <errno.h>

char **__crt0_glob_function(char *_argument)
{
   return NULL;
}

typedef struct
{
   char id[4];
   int dstart;
   int dsize;
} header_t;

typedef struct
{
   char name[56];
   int start;
   int size;
} item_t;

FILE *pak;
header_t header;
item_t *items;
int n_items;

void ExtractFiles(char *wildcard,int extract)
{
   int i;
   void *buf;
   FILE *f;
   char dir[56],name[56];
   char *d;
   int size,tsize;

   tsize=0;
   for (i=0;i<n_items;i++)
   {
      if (!fnmatch(wildcard,items[i].name,0))
      {
         printf("%10i %s\n",items[i].size,items[i].name);
         tsize+=items[i].size;

         if (extract)
         {
            if (strrchr(items[i].name,'/'))
            {
               strcpy(name,strrchr(items[i].name,'/')+1);
               memset(dir,0,sizeof(dir));
               strncpy(dir,items[i].name,strlen(items[i].name)-strlen(name));
            }
            else
            {
               strcpy(name,items[i].name);
               dir[0]=0;
            }
   
            d=dir;
            while (strlen(d))
            {
               while (*d!='/') d++;
               *d=0;
               if (mkdir(dir,0))
               {
                  if (errno!=EEXIST)
                  {
                     perror(dir);
                     exit(1);
                  }
               }
               *d++='/';
            }
   
            f=fopen(items[i].name,"wb");
            if (!f)
            {
               perror(items[i].name);
               exit(1);
            }
            size=items[i].size;
            fseek(pak,items[i].start,SEEK_SET);
            buf=malloc(size);
            fread(buf,1,size,pak);
            fwrite(buf,1,size,f);
            free(buf);
            fclose(f);
         }
      }
   }
   printf("%10i total (%i kb,%i mb)\n",tsize,tsize/1024,tsize/1024/1024);
}

int main(int argc, char **argv)
{
   printf("--- recdir ---\n");

   if (argc!=4)
   {
      printf("Syntax:\n");
      printf("%s pakfile.pak extract wildcard\n",argv[0]);
      printf("\n"
             "   pakfile.pak is the name of the pak file.\n"
             "   extract is 1 if you want to extract files, or 0 if you just want\n"
             "   to list them.\n"
             "   wildcard is a unix-like wildcard.\n"
             "\n"
             "To extract all textures, type:\n"
             "   recdir pak0.pak 1 *.wal\n");
      return 0;
   }

   pak=fopen(argv[1],"rb");
   if (!pak)
   {
      printf("Unable to open .pak file!\n");
      return 1;
   }

   fread(&header,1,sizeof(header_t),pak);
   n_items=header.dsize/sizeof(item_t);

   items=malloc(header.dsize);
   fseek(pak,header.dstart,SEEK_SET);
   fread(items,1,header.dsize,pak);

   printf("%s\n",argv[1]);
   printf("%5i items\n",n_items);

   if (argc==4)
   {
      ExtractFiles(argv[3],atoi(argv[2]));
   }

   fclose(pak);

   return 0;
}

