/*
memory.c file of the MergeT3D Source Code

Copyright 1997, 1998 Alexander Malmberg
Copyright Gyro Gearloose
Copyright 1996, Trey Harrison and Chris Carollo

This program is distributed under the GNU General Public License.
See legal.txt for more information.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "types.h"

#include "memory.h"


/* memory stuffs */
int memused;          /*mainly used for memory debugging*/
int Q_TotalMem;       /* ""*/
int maxused;


#define TRACK_MEM_USED

void InitMemory(unsigned int heapsize)
{
	memused = maxused = 0;
	Q_TotalMem = -1;
}

void CloseMemory(void)
{
   /* do nothing */
}

void *Q_malloc(int size)
{
	void *temp;

#ifdef TRACK_MEM_USED
	temp = (void *)malloc(size+4);
#else
	temp = (void *)malloc(size);
#endif
	if (temp==NULL)
	{
//      printf("Warning! malloc failed for %i bytes\n",size);
		return NULL;
	}
#ifdef TRACK_MEM_USED
	memused += size;
   if (memused>maxused)
      maxused=memused;
   *(int *)temp=size;
	return temp+4;
#else
   return temp;
#endif
}

void *Q_realloc(void *temp, int size)
{
#ifdef TRACK_MEM_USED
   int oldsize=0;

   if (temp != NULL)
   {
      temp-=4;
      oldsize = *(int *)temp;
   }
   temp = (void *)realloc(temp,size+4);
#else
   temp = (void *)realloc(temp,size);
#endif

#ifdef TRACK_MEM_USED
   if (temp != NULL)
   {
     memused -= oldsize;
	  memused += size;
     if (memused>maxused)
        maxused=memused;
     *(int *)temp=size;
     return temp+4;
   }
#endif

   return temp;
}

int Q_free(void *temp)
{
	if (temp == NULL)
		return 0;

#ifdef TRACK_MEM_USED
   temp-=4;
	memused -= *(int *)temp;
#endif
	free(temp);
	return 1;
}

char *Q_strdup(const char *src)
{
   char *r;

   r=Q_malloc(strlen(src)+1);
   if (!r)
      return NULL;
   strcpy(r,src);

   return r;
}

