/*
misc.c file of the MergeT3D Source Code

Copyright 1997, 1998 Alexander Malmberg
Copyright Gyro Gearloose
Copyright 1996, Trey Harrison and Chris Carollo

This program is distributed under the GNU General Public License.
See legal.txt for more information.
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <math.h>

#include "types.h"

#include "misc.h"

#include "geom.h"
#include "globals.h"


void RecalcAllNormals(void)
{
	brush_t *b;

	for (b=BrushHead; b; b=b->Next)
		RecalcNormals(b);
}

void RecalcNormals(brush_t *b)
{

	int       j, k;
	int       k_next, k_prev, k_cur;
	plane_t  *p;
	vec3_t    vec1, vec2, norm;
	vec3_t    *vertarray;

	for (j=0; j<b->num_planes; j++)
	{
		p = &(b->plane[j]);
		vertarray = b->verts;

		norm.x = norm.y = norm.z = 0;
		k = 1;
		while ((norm.x == 0) && (norm.y == 0) && (norm.z == 0) &&
				(k <= p->num_verts))
      {

			k_cur = k % p->num_verts;
			k_next = (k + 1)% p->num_verts;
			k_prev = (k + p->num_verts - 1) % p->num_verts;

			vec1.x = vertarray[p->verts[k_cur]].x - vertarray[p->verts[k_prev]].x;
			vec1.y = vertarray[p->verts[k_cur]].y - vertarray[p->verts[k_prev]].y;
			vec1.z = vertarray[p->verts[k_cur]].z - vertarray[p->verts[k_prev]].z;

			vec2.x = vertarray[p->verts[k_cur]].x - vertarray[p->verts[k_next]].x;
			vec2.y = vertarray[p->verts[k_cur]].y - vertarray[p->verts[k_next]].y;
			vec2.z = vertarray[p->verts[k_cur]].z - vertarray[p->verts[k_next]].z;

			CrossProd(vec1, vec2, &norm);
			Normalize(&norm);

			k++;
		}

		if (k <= p->num_verts)
		{
			p->normal.x = norm.x;
			p->normal.y = norm.y;
			p->normal.z = norm.z;
			p->dist = DotProd(p->normal,vertarray[p->verts[0]]);
		}
		else
		{
			p->normal.x = 0;
			p->normal.y = 0;
			p->normal.z = 0;
			p->dist     = 0;
		}
	}
}

int VertsAreEqual(vec3_t one,vec3_t two)
{
   if ((fabs(one.x - two.x) < 0.1) &&
       (fabs(one.y - two.y) < 0.1) &&
       (fabs(one.z - two.z) < 0.1))
      return 1;
   else
      return 0;
}

int EdgesAreEqual(edge_t one,edge_t two)
{
   if ((one.startvertex == two.startvertex) &&
       (one.endvertex   == two.endvertex))
      return 1;

   if ((one.startvertex == two.endvertex) &&
       (one.endvertex   == two.startvertex))
      return 1;

   return 0;
}

void CalcBrushCenter(brush_t *b)
{
   int i, j;

   b->center.x = 0;
   b->center.y = 0;
   b->center.z = 0;

   for (i=0; i<b->num_verts; i++)
   {
      b->center.x += b->verts[i].x;
      b->center.y += b->verts[i].y;
      b->center.z += b->verts[i].z;
   }
   b->center.x /= b->num_verts;
   b->center.y /= b->num_verts;
   b->center.z /= b->num_verts;

   for (i=0; i<b->num_planes; i++)
   {
      b->plane[i].center.x = 0;
      b->plane[i].center.y = 0;
      b->plane[i].center.z = 0;
      for (j=0; j<b->plane[i].num_verts; j++)
      {
         b->plane[i].center.x += b->verts[b->plane[i].verts[j]].x;
         b->plane[i].center.y += b->verts[b->plane[i].verts[j]].y;
         b->plane[i].center.z += b->verts[b->plane[i].verts[j]].z;
      }
      b->plane[i].center.x /= b->plane[i].num_verts;
      b->plane[i].center.y /= b->plane[i].num_verts;
      b->plane[i].center.z /= b->plane[i].num_verts;
   }
}

