/*
Copyright 1998, 1998 Alexander Malmberg

Distributed under the GNU General Public License.
See legal.txt for more information.
*/

#include <std.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "error.h"

#include "vga.h"

void Error(char *format, ...)
{
   va_list args;

   asm volatile
   ("
      movl $0x0f00,%%eax
      intb $0x10
      cmpb $0x03,%%al
      jz 1f
      movl $0x0003,%%eax
      intb $0x10
1:
   "
   :
   :
   : "%eax");


   printf("--- Error ---\n");
   va_start(args,format);
   vprintf(format,args);
   va_end(args);
   printf("\n");

   exit(1);
}

void *Q_malloc(int size)
{
   void *temp;

   temp=malloc(size);

   if (!temp)
      Error("Out of memory (%i bytes)!",size);

   return temp;
}

