#ifndef VGA_H
#define VGA_H

typedef struct picture_s
{
   int xsize;
   int ysize;
   unsigned char data[0];
} picture_t;

extern unsigned char screen[64000];

extern unsigned char def_pal[768];

void UpdateScreen(void);

void InitVGA(void);

void SetMode(int m);

#define SetVGA() SetMode(0x13)

#define SetText() SetMode(0x03)

#define PutPixel(x,y,c) (screen[(x)+(y)*320]=(c))

#define GetPixel(x,y) (screen[(x)+(y)*320])

void ClrVGA(void);

void Line(int x1,int y1,int x2,int y2,int arg_c);

void WaitVBL(void);

void SetPal(unsigned char *pal);

void GetPal(unsigned char *pal);

void Rectangle(int x1,int y1,int x2,int y2,int arg_c);

void Bar(int x1,int y1,int x2,int y2,int arg_c);

void PutChar(int x,int y,int color,int ch);

void PutString(int x,int y,int color,char *format, ...);

picture_t *LoadPic(char *name);

void PutImage(int x,int y,picture_t *p);

void PutImageT(int x,int y,picture_t *p);

#endif

