/*
Copyright 1998, 1998 Alexander Malmberg

Distributed under the GNU General Public License.
See legal.txt for more information.
*/

#include <std.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "wad.h"

#include "error.h"

FILE *wad;

wadheader_t wh;
wadlump_t *lumps;

void InitWad(char *wadname)
{
   wad=fopen(wadname,"rb");
   if (!wad)
   {
      Error("Couldn't open '%s'!",wadname);
   }

   fread(&wh,1,sizeof(wh),wad);
   fseek(wad,wh.dirstart,SEEK_SET);
   lumps=Q_malloc(sizeof(wadlump_t)*wh.numlumps);
   fread(lumps,1,sizeof(wadlump_t)*wh.numlumps,wad);

   printf("InitWad(): loaded '%s', %i lumps\n",wadname,wh.numlumps);
}

int FindLump(char *name)
{
   int i;

   for (i=0;i<wh.numlumps;i++)
   {
      if (!strnicmp(name,lumps[i].name,8))
         return i;
   }

   Error("Can't find lump '%s'!",name);
}

void *LoadLump(int num,int *size)
{
   void *temp;

   fseek(wad,lumps[num].ofs,SEEK_SET);

   temp=Q_malloc(lumps[num].size);

   fread(temp,1,lumps[num].size,wad);
   if (size)
      *size=lumps[num].size;

   return temp;
}

void *LoadLumpBase(char *name,int base,int *size)
{
   int i;

   for (i=base+1;i<wh.numlumps;i++)
   {
      if (!lumps[i].size)
         break;

      if (!strnicmp(name,lumps[i].name,8))
      {
         return LoadLump(i,size);
      }
   }
   Error("Can't find lump '%s'!",name);
}

