/*
Copyright 1998, 1998 Alexander Malmberg

Distributed under the GNU General Public License.
See legal.txt for more information.
*/

#include <std.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <math.h>

#include "vec.h"

#include "error.h"
#include "vga.h"

float Angle(vec2_t v)
{
   float a;

   if (!fabs(v[0]) && !fabs(v[1]))
      return 0;

   if (v[0])
   {
      a=atan(fabs(v[1]/v[0]));
      a=a*180/PI;
   }
   else
   {
      a=90;
   }

   if (v[0]<0)
   {
      a=180-a;
   }

   if (v[1]<0)
   {
      a=360-a;
   }

   while (a<0) a+=360;
   while (a>=360) a-=360;

   return a;
}

/*

     v1
    /
   /
  /
 v2---v3

returns the angle at v2
*/
float Angle2(vec2_t v1,vec2_t v2,vec2_t v3)
{
   vec2_t t1,t2;
   float a1,a2;

   VecSub(t1,v1,v2);
   VecSub(t2,v3,v2);

   a1=Angle(t1);
   a2=Angle(t2);

   a1-=a2;
   while (a1<0) a1+=360;

   return a1;
}

int Intersect(vec2_t v00,vec2_t v01,vec2_t v10,vec2_t v11)
{
   vec2_t d1,d2;

   float a1,b1,c1;
   float a2,b2,c2;

   float x,y,y1,y2;

   VecSub(d1,v01,v00);
   VecSub(d2,v11,v10);

   a1= d1[1];
   b1=-d1[0];
   c1=-v00[0]*a1-v00[1]*b1;

   a2= d2[1];
   b2=-d2[0];
   c2=-v10[0]*a2-v10[1]*b2;

   y2=b2*a1-b1*a2;
   y1=c1*a2-c2*a1;

   if (!y2)
   {
//      printf("Warning: Parallel lines, considered not intersecting.\n");
      return 0;
   }

   y=y1/y2;

   if (a1)
   {
      y1=-c1-b1*y;
      x=y1/a1;
   }
   else
   {
      y1=-c2-b2*y;
      x=y1/a2;
   }

   if ((x==v00[0]) && (x==v10[0]) &&
       (y==v00[1]) && (y==v10[1]))
      return 0;

   if ((x==v01[0]) && (x==v10[0]) &&
       (y==v01[1]) && (y==v10[1]))
      return 0;

   if ((x==v00[0]) && (x==v11[0]) &&
       (y==v00[1]) && (y==v11[1]))
      return 0;

   if ((x==v01[0]) && (x==v11[0]) &&
       (y==v01[1]) && (y==v11[1]))
      return 0;

/*   printf("line1= (%g %g) - (%g %g)\n",v00[0],v00[1],v01[0],v01[1]);
   printf("line2= (%g %g) - (%g %g)\n",v10[0],v10[1],v11[0],v11[1]);

   printf("possible intersection at (%g %g)\n",x,y);*/


   if ((x-v00[0]<-0.01) && (x-v01[0]<-0.01))
      return 0;
   if ((x-v00[0]> 0.01) && (x-v01[0]> 0.01))
      return 0;

   if ((y-v00[1]<-0.01) && (y-v01[1]<-0.01))
      return 0;
   if ((y-v00[1]> 0.01) && (y-v01[1]> 0.01))
      return 0;


   if ((x-v10[0]<-0.01) && (x-v11[0]<-0.01))
      return 0;
   if ((x-v10[0]> 0.01) && (x-v11[0]> 0.01))
      return 0;

   if ((y-v10[1]<-0.01) && (y-v11[1]<-0.01))
      return 0;
   if ((y-v10[1]> 0.01) && (y-v11[1]> 0.01))
      return 0;


   return 1;
}


vec2_t origin={0,0};
float scale=0.07;

