/*
Copyright 1998, 1998 Alexander Malmberg

Distributed under the GNU General Public License.
See legal.txt for more information.
*/

#include <std.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <math.h>

#include "level.h"

#include "error.h"
#include "vec.h"
#include "wad.h"


thing_t *things;
linedef_t *linedefs;
sidedef_t *sidedefs;
int *sd_flag;
int *sd_added;
vertex_t *verts;
seg_t *segs;
ssector_t *ssectors;
node_t *nodes;
sector_t *sectors;

int n_things;
int n_linedefs;
int n_sidedefs;
int n_verts;
int n_segs;
int n_ssectors;
int n_nodes;
int n_sectors;


typedef struct
{
   vec2_t n;
   float dist;

   int child[2];
} mynode_t;

mynode_t *mynodes;

sector_t *InSector(int x,int y)
{
   mynode_t *n;
   int nn;
   float dist;
   linedef_t *ld;
   sidedef_t *sd;

   nn=n_nodes-1;

   while (1)
   {
      if (nn&0x8000)
         break;

      n=&mynodes[nn];

      dist=((float)x)*n->n[0]+((float)y)*n->n[1]-n->dist;

      if (dist>0)
         nn=n->child[0];
      else
         nn=n->child[1];
   }

   nn=ssectors[nn&0x7fff].start;
   ld=&linedefs[segs[nn].linedef];
   sd=&sidedefs[ld->sidedef[segs[nn].dir]];

/*   printf("seg=%i  linedef=%i  sidedef=%i  sector=%i  sec->fh=%i\n",
      nn,segs[nn].linedef,ld->sidedef[segs[nn].dir],
      sd->sector,sectors[sd->sector].fh);*/

   return &sectors[sd->sector];
}


void LoadLevel(char *lump)
{
   int base;
   int size;

   base=FindLump(lump);

#define AddLump(name,x) \
   x=LoadLumpBase(name,base,&size); \
   n_##x=size/sizeof(*x); \
   printf("%8s: %i (%i bytes)\n",name,n_##x,size);

   printf(
      "\n"
      "-- %s --\n",lump);

   AddLump("THINGS",things);
   AddLump("LINEDEFS",linedefs);
   AddLump("SIDEDEFS",sidedefs);
   AddLump("VERTEXES",verts);
   AddLump("SEGS",segs);
   AddLump("SSECTORS",ssectors);
   AddLump("NODES",nodes);
   AddLump("SECTORS",sectors);
   printf("\n");

   sd_flag=Q_malloc(sizeof(int)*n_sidedefs);
   sd_added=Q_malloc(sizeof(int)*n_sidedefs);
   mynodes=Q_malloc(sizeof(mynode_t)*n_nodes);
}

void InitBSP()
{
   int i;

   for (i=0;i<n_nodes;i++)
   {
      mynodes[i].n[0]= nodes[i].dp[1];
      mynodes[i].n[1]=-nodes[i].dp[0];

      if (mynodes[i].n[0])
      {
         mynodes[i].n[1]/=fabs(mynodes[i].n[0]);
         mynodes[i].n[0]/=fabs(mynodes[i].n[0]);
      }
      else
      {
         mynodes[i].n[0]/=fabs(mynodes[i].n[1]);
         mynodes[i].n[1]/=fabs(mynodes[i].n[1]);
      }

      mynodes[i].dist=
         nodes[i].p[0]*mynodes[i].n[0]+
         nodes[i].p[1]*mynodes[i].n[1];

      mynodes[i].child[0]=nodes[i].child[0];
      mynodes[i].child[1]=nodes[i].child[1];
   }
}

void Recenter(void)
{
   int i;
   int min[2],max[2],mid[2];
   vertex_t *v;
   thing_t *t;
   node_t *n;

   min[0]=min[1]= 32768;
   max[0]=max[1]=-32768;

   v=verts;
   for (i=n_verts;i;i--,v++)
   {
      if ((*v)[0]<min[0]) min[0]=(*v)[0];
      if ((*v)[1]<min[1]) min[1]=(*v)[1];

      if ((*v)[0]>max[0]) max[0]=(*v)[0];
      if ((*v)[1]>max[1]) max[1]=(*v)[1];
   }

   for (i=0;i<2;i++)
   {
      mid[i]=min[i]+max[i];
      mid[i]/=2;
      mid[i]&=~63;

      min[i]-=mid[i];
      max[i]-=mid[i];
   }

   v=verts;
   for (i=n_verts;i;i--,v++)
   {
      (*v)[0]-=mid[0];
      (*v)[1]-=mid[1];
   }

   t=things;
   for (i=n_things;i;i--,t++)
   {
      t->p[0]-=mid[0];
      t->p[1]-=mid[1];
   }

   n=nodes;
   for (i=n_nodes;i;i--,n++)
   {
      n->p[0]-=mid[0];
      n->p[1]-=mid[1];
   }

   printf("Recenter(): New extents: (%i %i) - (%i %i)\n",
      min[0],min[1],max[0],max[1]);
}

