#ifndef Q2_TEX_H
#define Q2_TEX_H

/*
Brush contents from qfiles.h found in q2source.zip (slightly modified)
*/

// contents flags are seperate bits
// a given brush can contribute multiple content bits
// multiple brushes can be in a single leaf

// lower bits are stronger, and will eat weaker brushes completely
#define	CONTENTS_SOLID			 1		// an eye is never valid in a solid
#define	CONTENTS_WINDOW		 2		// translucent, but not watery
#define	CONTENTS_AUX			 4
#define	CONTENTS_LAVA			 8
#define	CONTENTS_SLIME			 16
#define	CONTENTS_WATER			 32
#define	CONTENTS_MIST			 64

// remaining contents are non-visible, and don't eat brushes

#define	CONTENTS_AREAPORTAL	 0x8000

#define	CONTENTS_PLAYERCLIP	 0x10000
#define	CONTENTS_MONSTERCLIP	 0x20000

// currents can be added to any other contents, and may be mixed
#define	CONTENTS_CURRENT_0	 0x40000
#define	CONTENTS_CURRENT_90	 0x80000
#define	CONTENTS_CURRENT_180	 0x100000
#define	CONTENTS_CURRENT_270	 0x200000
#define	CONTENTS_CURRENT_UP	 0x400000
#define	CONTENTS_CURRENT_DOWN 0x800000

#define	CONTENTS_ORIGIN		 0x1000000	// removed before bsping an entity

#define	CONTENTS_DETAIL		 0x8000000	// brushes to be added after vis leafs
#define	CONTENTS_TRANSLUCENT	 0x10000000	// auto set if any surface has trans
#define	CONTENTS_LADDER	 	 0x20000000

/*
Plane flags from qfiles.h from q2source.zip (slightly modified)
*/

#define	SURF_LIGHT		0x1		// value will hold the light strength
#define	SURF_SLICK		0x2		// effects game physics
#define	SURF_SKY			0x4		// don't draw, but add to skybox
#define	SURF_WARP		0x8		// turbulent water warp
#define	SURF_TRANS33	0x10
#define	SURF_TRANS66	0x20
#define	SURF_FLOWING	0x40		// scroll towards angle
#define	SURF_NODRAW		0x80		// don't bother referencing the texture
#define	SURF_HINT		0x100		// make a primary bsp splitter
#define	SURF_SKIP		0x200		// completely ignore, allowing non-closed brushes

int Q2_LoadTexInfo(texdef_t *tex);
void Q2_SaveTexInfo(texdef_t *tex,FILE *fp);

#endif

