/*
Copyright (C) 2010 Ronie Salgado

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "stdafx.h"
#include "ProgressWindow.h"
#include "QMainFrame.h"

BEGIN_EVENT_TABLE(ProgressWindow, wxFrame)
	EVT_BUTTON(wxID_CANCEL, ProgressWindow::OnCancel)
	EVT_CLOSE(ProgressWindow::OnCloseWindow)
END_EVENT_TABLE()

// ProgressWindow
ProgressWindow::ProgressWindow(wxWindow *parent, const wxString &title, const wxString &caption,
			wxPoint position)
	: wxFrame(parent, wxID_ANY, title, position, wxDefaultSize, wxCAPTION | wxCLOSE_BOX)
{
	// Load the frame
	wxPanel *panel = wxXmlResource::Get()->LoadPanel(this, wxT("ProgressWindow"));
	ASSERT(panel);
	SetSize(panel->GetSize());

	// Get the progress control.
	progress = XRCCTRL(*panel, "progress", wxGauge);
	ASSERT(progress);

	// Get the progress label.
	wxStaticText *progressLabel = XRCCTRL(*panel, "progressLabel", wxStaticText);
	ASSERT(progressLabel);

	// Set the caption.
	progressLabel->SetLabel(caption);

	// Don't cancel.
	isCancelled = false;

	// Set the initial range and position.
	progress->SetRange(100);
	min = 0;
	max = 100;
	progressPosition = 0;
}

ProgressWindow::~ProgressWindow()
{
}

bool ProgressWindow::Cancelled() const
{
	return isCancelled;
}

int ProgressWindow::GetProgress()
{
	return progressPosition;
}

void ProgressWindow::GetRange(int &min, int &max)
{
	min = this->min;
	max = this->max;
}

void ProgressWindow::SetProgress(int position)
{
	progressPosition = position;

	// Update the progress postion.
	progress->SetValue(position - min);
}

void ProgressWindow::SetRange(int min, int max)
{
	this->min = min;
	this->max = max;

	// Update the range
	progress->SetRange(max - min);
}


void ProgressWindow::OnCancel(wxCommandEvent &event)
{
	isCancelled = true;
}

void ProgressWindow::OnCloseWindow(wxCloseEvent& event)
{
	isCancelled = true;
}

// ProgressFunc.
ProgressWindow *ProgressFunc::progressWindow = NULL;
ProgressFunc::ProgressFunc(const wxString &title, const wxString &caption)
{
	ASSERT(progressWindow == NULL);
	progressWindow = new ProgressWindow(GetMainFrame(), title, caption);
	progressWindow->Show(true);
	progressWindow->SetRange(0, 100);
	progressWindow->SetProgress(0);

}

ProgressFunc::~ProgressFunc()
{
	ASSERT(progressWindow);
	progressWindow->Destroy();
	progressWindow = NULL;
}

bool ProgressFunc::SetPos(int percent)
{
	ASSERT(progressWindow);
	if(progressWindow->Cancelled())
		return false;

	progressWindow->SetProgress(percent);
	wxEventLoop *loop = wxEventLoop::GetActive();
	while(loop->Pending())
		loop->Dispatch();
	return true;
}


